/*
 * Decompiled with CFR 0.152.
 */
package controlador.curso;

import controlador.curso.PnlHorarioClaseCTR;
import controlador.curso.PnlHorarioCursoCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.time.LocalTime;
import javax.swing.JOptionPane;
import modelo.curso.CursoMD;
import modelo.curso.SesionClaseBD;
import modelo.curso.SesionClaseMD;
import modelo.validaciones.TxtVHora;
import modelo.validaciones.Validar;
import vista.curso.JDHorario;
import vista.curso.PnlHorarioClase;

public class JDHorarioCTR
extends DVtnCTR {
    private final JDHorario jd;
    private final CursoMD curso;
    private final SesionClaseBD SCBD = SesionClaseBD.single();
    private int idSesion;
    private int posFil;
    private int posColum;
    private int dia;
    private int horaC;
    private int horaT;
    private int minutoC;
    private int minutoT;
    private String jornada;
    private String horaIni;
    private String horaFin;
    private String[] hs;
    private boolean guardar;
    private boolean editar;
    private PnlHorarioClase pnl;
    private PnlHorarioClase pnlCurso;
    private PnlHorarioClaseCTR ctrHClase;
    private PnlHorarioCursoCTR ctrHCurso;
    private LocalTime inicio;
    private LocalTime fin;
    private SesionClaseMD sesion;

    public JDHorarioCTR(VtnPrincipalCTR ctrPrin, CursoMD curso) {
        super(ctrPrin);
        this.curso = curso;
        this.jd = new JDHorario((Frame)ctrPrin.getVtnPrin(), false);
        this.jd.setLocationRelativeTo(ctrPrin.getVtnPrin());
    }

    public void iniciar() {
        this.cargarDatos();
        this.horarioClase();
        this.iniciarValidaciones();
        this.ctrPrin.eventoJDCerrar(this.jd);
        this.llenarCmbDias();
        this.jd.setVisible(true);
        this.jd.getBtnCancelar().setVisible(false);
        this.jd.getBtnCancelar().addActionListener(e -> this.clickCancelar());
        this.jd.getBtnGuardar().addActionListener(e -> this.guardar());
        this.clickTbl();
        this.horarioCurso();
        this.jd.getTbpHorario().addChangeListener(e -> this.clickTbp());
    }

    private void clickTbp() {
        if (this.jd.getTbpHorario().getSelectedIndex() == 1) {
            this.ctrHCurso.iniciar();
        }
    }

    private void clickCancelar() {
        this.editar = false;
        this.idSesion = 0;
        this.limpiarFrm();
    }

    private void llenarCmbDias() {
        this.jd.getCmbDia().removeAllItems();
        this.jd.getCmbDia().addItem("Seleccione");
        String[] t = new String[]{"H", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"};
        for (int i = 1; i < t.length; ++i) {
            this.jd.getCmbDia().addItem(t[i]);
        }
    }

    private void iniciarValidaciones() {
        this.jd.getTxtHoraInicio().addKeyListener(new TxtVHora(this.jd.getTxtHoraInicio()));
        this.jd.getTxtHoraFin().addKeyListener(new TxtVHora(this.jd.getTxtHoraFin()));
    }

    private void guardar() {
        this.guardar = true;
        this.dia = this.jd.getCmbDia().getSelectedIndex();
        this.horaIni = this.jd.getTxtHoraInicio().getText().trim();
        this.horaFin = this.jd.getTxtHoraFin().getText().trim();
        if (this.dia == 0) {
            this.guardar = false;
            this.jd.getLblError().setText("Debe seleccionar un dia.");
        } else {
            this.jd.getLblError().setText("");
        }
        if (!Validar.esHora(this.horaIni) || !Validar.esHora(this.horaFin)) {
            this.guardar = false;
            this.jd.getLblError().setText("<html>Debe ingresar horas validas <br>08:00 - 20:00</html>");
        } else {
            this.jd.getLblError().setText("");
            this.hs = this.horaIni.split(":");
            this.horaC = Integer.parseInt(this.hs[0]);
            this.minutoC = Integer.parseInt(this.hs[1]);
            this.hs = this.horaFin.split(":");
            this.horaT = Integer.parseInt(this.hs[0]);
            this.minutoT = Integer.parseInt(this.hs[1]);
            if (this.horaC > 22 || this.horaC < 7 || this.horaT > 22 || this.horaC < 7) {
                this.guardar = false;
                this.jd.getLblError().setText("<html>Esta fuera de rango recuerde el formato: <br>08:00 - 20:00</html>");
            } else {
                this.jd.getLblError().setText("");
                if (this.horaC > this.horaT) {
                    this.jd.getLblError().setText("<html>La clase debe empezar antes <br>" + this.horaIni + " - " + this.horaFin + "</html>");
                } else {
                    this.jd.getLblError().setText("");
                    this.todosLosCamposLlenos();
                }
            }
            if (this.horaT - this.horaC > 1 && this.editar) {
                this.jd.getLblError().setText("<html>Debe ingresar solamente una hora: <br>08:00 - 09:00</html>");
                this.guardar = false;
            }
        }
        if (this.guardar) {
            this.inicio = LocalTime.of(this.horaC, this.minutoC);
            this.fin = LocalTime.of(this.horaT, this.minutoT);
            SesionClaseMD s = this.SCBD.existeSesion(this.curso.getId(), this.dia, this.inicio, this.fin);
            if (s.getCurso() != null) {
                JOptionPane.showMessageDialog(this.pnlCurso, "Ya ingreso este horario.");
                this.guardar = false;
            }
        }
        if (!this.guardar || this.minutoC > 0 || this.minutoT > 0) {
            // empty if block
        }
        if (this.guardar) {
            String nsql = "";
            SesionClaseMD sc = new SesionClaseMD();
            if (this.horaT > this.horaC && this.minutoC == 0 && this.minutoT == 0) {
                for (int i = this.horaC; i < this.horaT; ++i) {
                    this.inicio = LocalTime.of(i, this.minutoC);
                    this.fin = LocalTime.of(i + 1, this.minutoT);
                    sc.setCurso(this.curso);
                    sc.setDia(this.dia);
                    sc.setHoraIni(this.inicio);
                    sc.setHoraFin(this.fin);
                    nsql = nsql + this.SCBD.obtenerInsert(sc) + "\n";
                }
            } else {
                this.inicio = LocalTime.of(this.horaC, this.minutoC);
                this.fin = LocalTime.of(this.horaT, this.minutoT);
                sc.setCurso(this.curso);
                sc.setDia(this.dia);
                sc.setHoraIni(this.inicio);
                sc.setHoraFin(this.fin);
                nsql = nsql + this.SCBD.obtenerInsert(sc) + "\n";
            }
            if (this.editar) {
                sc.setId(this.idSesion);
                this.SCBD.editar(sc);
                this.idSesion = 0;
                this.editar = false;
                this.jd.getBtnCancelar().setVisible(false);
            } else {
                this.SCBD.ingresarHorarios(nsql);
            }
            this.ctrHClase.actualizar(this.dia);
            this.limpiarFrm();
        }
    }

    private void todosLosCamposLlenos() {
        if (this.horaIni.equals("") || this.horaFin.equals("") || this.dia == 0) {
            this.guardar = false;
            this.jd.getLblError().setText("<html>Todos los campos son obligatorios <br> Formato hora: 08:00 - 20:00 </html>");
        } else {
            this.jd.getLblError().setText("");
        }
    }

    private void horarioClase() {
        this.pnl = new PnlHorarioClase();
        this.ctrHClase = new PnlHorarioClaseCTR(this.pnl, this.curso, this.SCBD);
        this.ctrHClase.iniciar();
        this.jd.getTbpHorario().addTab("Horario Clase", this.pnl);
    }

    private void horarioCurso() {
        this.pnlCurso = new PnlHorarioClase();
        this.ctrHCurso = new PnlHorarioCursoCTR(this.pnlCurso, this.curso);
        this.jd.getTbpHorario().addTab("Horario Curso", this.pnlCurso);
    }

    private void cargarDatos() {
        this.jd.setTitle("Horario - " + this.curso.getMateria().getNombre() + " - " + this.curso.getNombre());
        this.jd.getLblPrd().setText(this.curso.getPeriodo().getNombre());
        this.jd.getLblMateria().setText(this.curso.getMateria().getNombre());
        switch (this.curso.getNombre().charAt(0)) {
            case 'M': {
                this.jornada = "MATUTINA";
                break;
            }
            case 'V': {
                this.jornada = "VESPERTINA";
                break;
            }
            case 'N': {
                this.jornada = "NOCTURNA";
                break;
            }
            default: {
                this.jornada = "NA";
            }
        }
        this.jd.getLblJornada().setText(this.jornada);
        this.jd.getLblDocente().setText(this.curso.getDocente().getNombreCorto());
        this.jd.getLblCurso().setText(this.curso.getNombre());
        this.jd.getLblCapacidad().setText(this.curso.getCapacidad() + "");
    }

    private void clickTbl() {
        this.pnl.getTblHorario().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JDHorarioCTR.this.posFil = JDHorarioCTR.this.pnl.getTblHorario().getSelectedRow();
                JDHorarioCTR.this.posColum = JDHorarioCTR.this.pnl.getTblHorario().getSelectedColumn();
                if (JDHorarioCTR.this.posColum == 3 && JDHorarioCTR.this.pnl.getTblHorario().getValueAt(JDHorarioCTR.this.posFil, JDHorarioCTR.this.posColum) != null) {
                    JDHorarioCTR.this.idSesion = Integer.parseInt(JDHorarioCTR.this.pnl.getTblHorario().getValueAt(JDHorarioCTR.this.posFil, JDHorarioCTR.this.posColum).toString().split("%")[0]);
                    JDHorarioCTR.this.sesion = JDHorarioCTR.this.SCBD.buscarSesion(JDHorarioCTR.this.idSesion);
                    int r = JOptionPane.showOptionDialog(JDHorarioCTR.this.ctrPrin.getVtnPrin(), "Selecciono: " + JDHorarioCTR.this.idSesion + " " + JDHorarioCTR.this.jd.getCmbDia().getItemAt(JDHorarioCTR.this.sesion.getDia()) + "\nHora inicio: " + JDHorarioCTR.this.sesion.getHoraIni() + "\nHora fin: " + JDHorarioCTR.this.sesion.getHoraFin(), "Sesion Clase", 1, 1, null, new Object[]{"Editar", "Eliminar", "Cancelar"}, "Cancelar");
                    switch (r) {
                        case 0: {
                            JDHorarioCTR.this.jd.getCmbDia().setSelectedIndex(JDHorarioCTR.this.sesion.getDia());
                            JDHorarioCTR.this.jd.getTxtHoraInicio().setText(JDHorarioCTR.this.sesion.getHoraIni().toString());
                            JDHorarioCTR.this.jd.getTxtHoraFin().setText(JDHorarioCTR.this.sesion.getHoraFin().toString());
                            JDHorarioCTR.this.editar = true;
                            JDHorarioCTR.this.jd.getBtnCancelar().setVisible(true);
                            break;
                        }
                        case 1: {
                            JDHorarioCTR.this.idSesion = JDHorarioCTR.this.sesion.getId();
                            JDHorarioCTR.this.SCBD.eliminar(JDHorarioCTR.this.idSesion);
                            JDHorarioCTR.this.pnl.getTblHorario().setValueAt(null, JDHorarioCTR.this.posFil, JDHorarioCTR.this.posColum);
                            JDHorarioCTR.this.ctrHClase.actualizar(JDHorarioCTR.this.sesion.getDia());
                            break;
                        }
                        default: {
                            System.out.println("Desidio cancelar");
                        }
                    }
                }
            }
        });
    }

    private void limpiarFrm() {
        this.jd.getCmbDia().setSelectedIndex(0);
        this.jd.getTxtHoraFin().setText("");
        this.jd.getTxtHoraInicio().setText("");
        this.jd.getLblError().setText("");
    }
}

