/*
 * Decompiled with CFR 0.152.
 */
package controlador.curso;

import controlador.curso.VtnCursoCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.jornada.JornadaBD;
import modelo.jornada.JornadaMD;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.validaciones.Validar;
import vista.curso.FrmCurso;

public class FrmCursoCTR
extends DCTR {
    private final FrmCurso frmCurso;
    private final VtnCursoCTR ctrCurso;
    private final CursoBD CBD = CursoBD.single();
    private boolean editando = false;
    private int idCurso = 0;
    private final DocenteBD DBD = DocenteBD.single();
    private ArrayList<DocenteMD> docentes;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private final MateriaBD MTBD = MateriaBD.single();
    private ArrayList<MateriaMD> materias;
    private final JornadaBD JBD = JornadaBD.single();
    private List<JornadaMD> jornadas;
    private ArrayList<Integer> ciclos;

    public FrmCursoCTR(FrmCurso frmCurso, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmCurso = frmCurso;
        this.ctrCurso = null;
    }

    public FrmCursoCTR(FrmCurso frmCurso, VtnPrincipalCTR ctrPrin, VtnCursoCTR ctrCurso) {
        super(ctrPrin);
        this.frmCurso = frmCurso;
        this.ctrCurso = ctrCurso;
    }

    public void iniciar() {
        this.ocultarErrores();
        this.cargarCmbPrdLectivo();
        this.actualizarCmbMaterias();
        this.actualizarCmbDocentes();
        this.cargarCmbJornada();
        this.frmCurso.getCbxPeriodoLectivo().addActionListener(e -> this.clickCmbPrd());
        this.frmCurso.getCbxCiclo().addActionListener(e -> this.actualizarCmbMaterias());
        this.frmCurso.getCbxMateria().addActionListener(e -> this.actualizarCmbDocentes());
        this.frmCurso.getBtnGuardar().addActionListener(e -> this.guardarYSalir());
        this.frmCurso.getBtnGuardarContinuar().addActionListener(e -> this.guardarSeguirIngresando());
        this.frmCurso.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                if (FrmCursoCTR.this.ctrCurso != null) {
                    FrmCursoCTR.this.ctrCurso.actualizarVtn();
                }
            }
        });
        this.ctrPrin.agregarVtn(this.frmCurso);
    }

    private void ocultarErrores() {
        this.frmCurso.getLblError().setVisible(false);
        this.frmCurso.getLblErrorCapacidad().setVisible(false);
        this.frmCurso.getLblErrorCiclo().setVisible(false);
        this.frmCurso.getLblErrorDocente().setVisible(false);
        this.frmCurso.getLblErrorJornada().setVisible(false);
        this.frmCurso.getLblErrorMateria().setVisible(false);
        this.frmCurso.getLblErrorParalelo().setVisible(false);
        this.frmCurso.getLblErrorPrdLectivo().setVisible(false);
    }

    private void cargarCmbPrdLectivo() {
        this.periodos = this.PLBD.cargarPrdParaCmbFrm();
        if (this.periodos != null) {
            this.frmCurso.getCbxPeriodoLectivo().removeAllItems();
            this.frmCurso.getCbxPeriodoLectivo().addItem("Seleccione");
            this.periodos.forEach(p -> this.frmCurso.getCbxPeriodoLectivo().addItem(p.getNombre()));
        }
    }

    private void clickCmbPrd() {
        int posPr = this.frmCurso.getCbxPeriodoLectivo().getSelectedIndex();
        this.llenarCmbCiclos(posPr);
    }

    private void actualizarCmbMaterias() {
        this.frmCurso.getCbxMateria().setEnabled(true);
        int posPr = this.frmCurso.getCbxPeriodoLectivo().getSelectedIndex();
        int posCi = this.frmCurso.getCbxCiclo().getSelectedIndex();
        if (posPr > 0 && posCi > 0) {
            int ciclo = Integer.parseInt(this.frmCurso.getCbxCiclo().getSelectedItem().toString());
            this.materias = this.MTBD.cargarMateriaPorCarreraCiclo(this.periodos.get(posPr - 1).getCarrera().getId(), ciclo);
            this.cargarCmbMaterias(this.materias);
        } else {
            this.frmCurso.getCbxMateria().removeAllItems();
            this.frmCurso.getCbxMateria().setEnabled(false);
        }
    }

    private void llenarCmbCiclos(int posPrd) {
        this.ciclos = this.MTBD.cargarCiclosCarrera(this.periodos.get(posPrd - 1).getCarrera().getId());
        this.frmCurso.getCbxCiclo().removeAllItems();
        if (this.ciclos != null) {
            this.frmCurso.getCbxCiclo().addItem("Seleccione");
            this.ciclos.forEach(c -> this.frmCurso.getCbxCiclo().addItem(c + ""));
        }
    }

    private void actualizarCmbDocentes() {
        int posMat = this.frmCurso.getCbxMateria().getSelectedIndex();
        this.frmCurso.getCbxDocente().setEnabled(true);
        if (posMat > 0) {
            this.docentes = this.DBD.cargarDocentesPorMateria(this.materias.get(posMat - 1).getId());
            this.cargarCmbDocente(this.docentes);
        } else {
            this.frmCurso.getCbxDocente().setEnabled(false);
            this.frmCurso.getCbxDocente().removeAllItems();
        }
    }

    private void cargarCmbMaterias(ArrayList<MateriaMD> materias) {
        if (materias != null) {
            this.frmCurso.getCbxMateria().removeAllItems();
            this.frmCurso.getCbxMateria().addItem("Seleccione");
            materias.forEach(m -> this.frmCurso.getCbxMateria().addItem(m.getNombre()));
        }
    }

    private void cargarCmbDocente(ArrayList<DocenteMD> docentes) {
        if (docentes != null) {
            this.frmCurso.getCbxDocente().removeAllItems();
            this.frmCurso.getCbxDocente().addItem("Seleccione");
            docentes.forEach(d -> this.frmCurso.getCbxDocente().addItem(d.getPrimerNombre() + " " + d.getPrimerApellido()));
        }
    }

    private void cargarCmbJornada() {
        FrmCursoCTR frmCursoCTR = this;
        this.jornadas = frmCursoCTR.JBD.cargarJornadas();
        if (this.jornadas != null) {
            this.frmCurso.getCbxJornada().removeAllItems();
            this.frmCurso.getCbxJornada().addItem("Seleccione");
            this.jornadas.forEach(j -> this.frmCurso.getCbxJornada().addItem(j.getNombre()));
        }
    }

    public void guardarSeguirIngresando() {
        if (this.guardar()) {
            this.actualizarCmbMaterias();
            this.actualizarCmbDocentes();
            this.frmCurso.getLblError().setVisible(false);
        }
    }

    public void guardarYSalir() {
        if (this.guardar()) {
            this.frmCurso.dispose();
            this.ctrPrin.cerradoJIF();
            if (this.ctrCurso != null) {
                this.ctrCurso.actualizarVtn();
            }
        }
    }

    private boolean guardar() {
        boolean guardar = true;
        int posPrd = this.frmCurso.getCbxPeriodoLectivo().getSelectedIndex();
        int posJrd = this.frmCurso.getCbxJornada().getSelectedIndex();
        int posCic = this.frmCurso.getCbxCiclo().getSelectedIndex();
        int posPrl = this.frmCurso.getCbxParalelo().getSelectedIndex();
        int posMat = this.frmCurso.getCbxMateria().getSelectedIndex();
        int posDoc = this.frmCurso.getCbxDocente().getSelectedIndex();
        String capacidad = this.frmCurso.getTxtCapacidad().getText();
        int ciclo = 0;
        String paralelo = "SP";
        if (!Validar.esNumeros(capacidad)) {
            guardar = false;
            this.frmCurso.getLblErrorCapacidad().setVisible(true);
        } else {
            this.frmCurso.getLblErrorCapacidad().setVisible(false);
        }
        if (posPrd < 1 || posJrd < 1 || posCic < 1 || posPrl < 1 || posMat < 1 || posDoc < 1) {
            guardar = false;
            this.frmCurso.getLblError().setText("Todos los campos son obligatorios.");
            this.frmCurso.getLblError().setVisible(true);
        } else {
            this.frmCurso.getLblError().setVisible(false);
            ciclo = Integer.parseInt(this.frmCurso.getCbxCiclo().getSelectedItem().toString());
            paralelo = this.frmCurso.getCbxParalelo().getSelectedItem().toString();
            if (!this.editando) {
                CursoMD existeCurso = this.CBD.existeDocenteMateria(this.materias.get(posMat - 1).getId(), this.docentes.get(posDoc - 1).getIdDocente(), this.jornadas.get(posJrd - 1).getId(), this.periodos.get(posPrd - 1).getID(), ciclo, paralelo);
                if (existeCurso != null) {
                    guardar = false;
                    this.frmCurso.getLblError().setText("Datos ya guardados.");
                    this.frmCurso.getLblError().setVisible(true);
                } else {
                    this.frmCurso.getLblError().setVisible(false);
                    existeCurso = this.CBD.existeMateriaCursoJornada(this.materias.get(posMat - 1).getId(), ciclo, this.jornadas.get(posJrd - 1).getId(), this.periodos.get(posPrd - 1).getID(), paralelo);
                    if (existeCurso != null) {
                        guardar = false;
                        this.frmCurso.getLblError().setText("Este curso ya tiene guardado: " + this.materias.get(posMat - 1).getNombre() + ".");
                        this.frmCurso.getLblError().setVisible(true);
                    } else {
                        this.frmCurso.getLblError().setVisible(false);
                    }
                }
            }
        }
        if (guardar) {
            CursoMD curso = new CursoMD();
            String nombre = this.jornadas.get(posJrd - 1).getNombre().charAt(0) + "" + ciclo + "" + paralelo;
            curso.setCapacidad(Integer.parseInt(capacidad));
            curso.setCiclo(ciclo);
            curso.setJornada(this.jornadas.get(posJrd - 1));
            curso.setNombre(nombre);
            curso.setDocente(this.docentes.get(posDoc - 1));
            curso.setMateria(this.materias.get(posMat - 1));
            curso.setPeriodo(this.periodos.get(posPrd - 1));
            curso.setParalelo(paralelo);
            if (!this.editando) {
                this.CBD.guardarCurso(curso);
            } else if (this.idCurso > 0) {
                curso.setId(this.idCurso);
                this.CBD.editarCurso(curso);
                this.editando = false;
            }
        }
        return guardar;
    }

    public void editar(CursoMD c) {
        this.editando = true;
        this.idCurso = c.getId();
        int j = 0;
        switch (c.getNombre().charAt(0)) {
            case 'M': {
                j = 1;
                break;
            }
            case 'V': {
                j = 2;
                break;
            }
            case 'N': {
                j = 3;
            }
        }
        this.frmCurso.getBtnGuardarContinuar().setVisible(false);
        this.frmCurso.getCbxPeriodoLectivo().setSelectedItem(c.getPeriodo().getNombre());
        this.frmCurso.getCbxJornada().setSelectedIndex(j);
        this.frmCurso.getCbxCiclo().setSelectedItem(c.getCiclo() + "");
        this.frmCurso.getCbxParalelo().setSelectedItem(c.getNombre().charAt(2) + "");
        this.frmCurso.getCbxMateria().setSelectedItem(c.getMateria().getNombre());
        this.frmCurso.getCbxDocente().setSelectedItem(c.getDocente().getPrimerNombre() + " " + c.getDocente().getPrimerApellido());
        this.frmCurso.getTxtCapacidad().setText(c.getCapacidad() + "");
    }
}

