/*
 * Decompiled with CFR 0.152.
 */
package controlador.carrera;

import controlador.carrera.FrmCarreraCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.carrera.FrmCarrera;
import vista.carrera.VtnCarrera;

public class VtnCarreraCTR
extends DVtnCTR {
    private final VtnCarrera vtnCarrera;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private final CarreraBD CRBD = CarreraBD.single();
    private ArrayList<CarreraMD> carreras;
    private ArrayList<PeriodoLectivoMD> periodos;

    public VtnCarreraCTR(VtnCarrera vtnCarrera, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnCarrera = vtnCarrera;
    }

    public void iniciar() {
        this.vtnCarrera.getBtnReporteAlumnoCarrera().setEnabled(false);
        String[] titutlo = new String[]{"id", "Codigo", "Nombre", "Fecha Inicio", "Modalidad", "Semanas", "Coordinador"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titutlo);
        this.vtnCarrera.getTblMaterias().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.vtnCarrera.getTblMaterias());
        TblEstilo.ocualtarID(this.vtnCarrera.getTblMaterias());
        TblEstilo.columnaMedida(this.vtnCarrera.getTblMaterias(), 1, 50);
        TblEstilo.columnaMedida(this.vtnCarrera.getTblMaterias(), 3, 90);
        TblEstilo.columnaMedida(this.vtnCarrera.getTblMaterias(), 4, 90);
        TblEstilo.columnaMedida(this.vtnCarrera.getTblMaterias(), 5, 80);
        this.cargarCarreras();
        this.vtnCarrera.getBtnIngresar().addActionListener(e -> this.abrirFrmCarrera());
        this.vtnCarrera.getBtnEditar().addActionListener(e -> this.editarCarrera());
        this.vtnCarrera.getBtnEliminar().addActionListener(e -> this.eliminarCarrera());
        this.vtnCarrera.getTblMaterias().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                VtnCarreraCTR.this.validarBotonesReportes();
            }
        });
        this.vtnCarrera.getBtnReporteAlumnoCarrera().addActionListener(e -> this.llamaReporteAlumnoCarrera());
        this.vtnCarrera.getBtnReporteDocente().addActionListener(e -> this.botonDocentes());
        this.vtnCarrera.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnCarreraCTR.this.vtnCarrera.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnCarreraCTR.this.buscar(b);
                } else if (b.length() == 0) {
                    VtnCarreraCTR.this.cargarCarreras();
                }
            }
        });
        this.vtnCarrera.getBtnBuscar().addActionListener(e -> this.buscar(this.vtnCarrera.getTxtBuscar().getText().trim()));
        this.vtnCarrera.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnCarrera.getTxtBuscar(), this.vtnCarrera.getBtnBuscar()));
        this.ctrPrin.agregarVtn(this.vtnCarrera);
        this.InitPermisos();
    }

    private void buscar(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.carreras = this.CRBD.buscarCarrera(b);
            this.llenarTbl(this.carreras);
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "No debe ingresar caracteres especiales.");
        }
    }

    private void editarCarrera() {
        int fila = this.vtnCarrera.getTblMaterias().getSelectedRow();
        if (fila >= 0) {
            FrmCarrera frmCarrera = new FrmCarrera();
            this.ctrPrin.eventoInternal(frmCarrera);
            FrmCarreraCTR ctrFrmCarrera = new FrmCarreraCTR(frmCarrera, this.ctrPrin);
            ctrFrmCarrera.iniciar();
            ctrFrmCarrera.editar(this.carreras.get(fila));
            this.ctrPrin.cerradoJIF();
            this.vtnCarrera.dispose();
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una carrera primero.");
        }
    }

    private void eliminarCarrera() {
        int r;
        int fila = this.vtnCarrera.getTblMaterias().getSelectedRow();
        if (fila >= 0 && (r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Seguro que quiere eliminar \n" + this.vtnCarrera.getTblMaterias().getValueAt(fila, 2).toString() + "\nNo se podran recuperar los datos despues.")) == 0) {
            this.CRBD.eliminarCarrera(this.carreras.get(fila).getId());
            this.cargarCarreras();
        }
    }

    private void abrirFrmCarrera() {
        this.ctrPrin.abrirFrmCarrera();
        this.vtnCarrera.dispose();
        this.ctrPrin.cerradoJIF();
    }

    public void cargarCarreras() {
        this.carreras = this.CRBD.cargarCarreras();
        this.llenarTbl(this.carreras);
    }

    public void llenarTbl(ArrayList<CarreraMD> carreras) {
        this.mdTbl.setRowCount(0);
        if (carreras != null) {
            carreras.forEach(c -> {
                if (c.getCoordinador().getPrimerNombre() == null) {
                    Object[] valoresSD = new Object[]{c.getId(), c.getCodigo(), c.getNombre(), c.getFechaInicio(), c.getModalidad(), c.getNumSemanas(), "SIN COORDINADOR "};
                    this.mdTbl.addRow(valoresSD);
                } else {
                    Object[] valoresCD = new Object[]{c.getId(), c.getCodigo(), c.getNombre(), c.getFechaInicio(), c.getModalidad(), c.getNumSemanas(), c.getCoordinador().getPrimerApellido() + " " + c.getCoordinador().getSegundoApellido() + " " + c.getCoordinador().getPrimerNombre() + " " + c.getCoordinador().getSegundoNombre()};
                    this.mdTbl.addRow(valoresCD);
                }
            });
            this.vtnCarrera.getLblResultados().setText(carreras.size() + " Resutados obtendidos.");
        } else {
            this.vtnCarrera.getLblResultados().setText("0 Resutados obtendidos.");
        }
    }

    public void llamaReporteAlumnoCarrera() {
        this.posFila = this.vtnCarrera.getTblMaterias().getSelectedRow();
        String path = "/vista/reportes/repAlumnosCarrera.jasper";
        if (this.posFila >= 0) {
            try {
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("alumnoCarrera", this.carreras.get(this.posFila).getId());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de alumnos por Carrera");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnCarrera, "Seleccione una carrera.");
        }
    }

    public void botonDocentes() {
        int s = JOptionPane.showOptionDialog(this.vtnCarrera, "Reporte de Docentes por periodo LEctivo\n\u00bfElegir el tipo de Reporte?", "REPORTE DOCENTES", 1, 1, null, new Object[]{"Elegir Periodo", "Cancelar"}, "Cancelar");
        switch (s) {
            case 0: {
                this.seleccionarPeriodo();
                break;
            }
        }
    }

    public void seleccionarPeriodo() {
        this.periodos = this.PLBD.cargarPeriodos();
        ArrayList<String> nmPrd = new ArrayList<String>();
        nmPrd.add("Seleccione");
        this.periodos.forEach(p -> nmPrd.add(p.getNombre()));
        Object np = JOptionPane.showInputDialog(this.ctrPrin.getVtnPrin(), "Lista de periodos lectivos", "Periodos lectivos", 3, null, nmPrd.toArray(), "Seleccione");
        if (np == null) {
            this.botonDocentes();
        } else if (np.equals("Seleccione")) {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar un periodo lectivo.");
            this.seleccionarPeriodo();
        } else {
            String path = "/vista/reportes/repDocentesPrdLectivo.jasper";
            try {
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("idPeriodo", np);
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte de Materias del Docente por Periodos Lectivos");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        }
    }

    private void InitPermisos() {
        this.vtnCarrera.getBtnEliminar().getAccessibleContext().setAccessibleName("Carreras-Eliminar");
        this.vtnCarrera.getBtnEditar().getAccessibleContext().setAccessibleName("Carreras-Editar");
        this.vtnCarrera.getBtnIngresar().getAccessibleContext().setAccessibleName("Carreras-Ingresar");
        this.vtnCarrera.getBtnReporteAlumnoCarrera().getAccessibleContext().setAccessibleName("Carreras-Reporte-Alumno");
        this.vtnCarrera.getBtnReporteDocente().getAccessibleContext().setAccessibleName("Carreras-Reporte-Docente");
        CONS.activarBtns(this.vtnCarrera.getBtnEliminar(), this.vtnCarrera.getBtnEditar(), this.vtnCarrera.getBtnIngresar(), this.vtnCarrera.getBtnReporteAlumnoCarrera(), this.vtnCarrera.getBtnReporteDocente());
    }

    public void validarBotonesReportes() {
        int selecTabl = this.vtnCarrera.getTblMaterias().getSelectedRow();
        if (selecTabl >= 0) {
            this.vtnCarrera.getBtnReporteAlumnoCarrera().setEnabled(true);
        } else {
            this.vtnCarrera.getBtnReporteAlumnoCarrera().setEnabled(false);
        }
    }
}

