/*
 * Decompiled with CFR 0.152.
 */
package controlador.carrera;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.table.DefaultTableModel;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.persona.DocenteBD;
import modelo.persona.DocenteMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.TxtVLetras;
import modelo.validaciones.TxtVNumeros;
import modelo.validaciones.Validar;
import vista.carrera.FrmCarrera;

public class FrmCarreraCTR
extends DCTR {
    private final FrmCarrera frmCarrera;
    private boolean editar = false;
    private int idCarrera = 0;
    private final DocenteBD DBD = DocenteBD.single();
    private ArrayList<DocenteMD> docentes;
    private final String[] MODALIDADES = new String[]{"PRESENCIAL", "SEMIPRESENCIAL", "DISTANCIA", "DUAL", "ESPECIAL"};
    private DefaultTableModel mdTbl;
    private final Calendar fechaIni = Calendar.getInstance();

    public FrmCarreraCTR(FrmCarrera frmCarrera, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmCarrera = frmCarrera;
    }

    public void iniciar() {
        this.ocultarErrores();
        this.cargarCmbModalidades();
        this.validaciones();
        String[] titulo = new String[]{"C\u00e9dula", "Nombre"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.frmCarrera.getTblDocentes().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.frmCarrera.getTblDocentes());
        this.frmCarrera.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String a = FrmCarreraCTR.this.frmCarrera.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    FrmCarreraCTR.this.buscarDocentes(a);
                }
            }
        });
        this.frmCarrera.getBtnBuscar().addActionListener(e -> this.buscarDocentes(this.frmCarrera.getTxtBuscar().getText().trim()));
        this.frmCarrera.getBtnGuardar().addActionListener(e -> this.guardarYSalir());
        this.frmCarrera.getBtnGuardarContinuar().addActionListener(e -> this.guardarYContinuar());
        this.ctrPrin.agregarVtn(this.frmCarrera);
    }

    private void validaciones() {
        this.frmCarrera.getTxtBuscar().addKeyListener(new TxtVBuscador(this.frmCarrera.getTxtBuscar()));
        this.frmCarrera.getCmbModalidad().addActionListener(new CmbValidar(this.frmCarrera.getCmbModalidad()));
        this.frmCarrera.getTxtNombre().addKeyListener(new TxtVLetras(this.frmCarrera.getTxtNombre(), this.frmCarrera.getLblErrorNombre()));
        this.frmCarrera.getTxtCodigo().addKeyListener(new TxtVLetras(this.frmCarrera.getTxtCodigo(), this.frmCarrera.getLblErrorCodigo()));
        this.frmCarrera.getTxtSemanas().addKeyListener(new TxtVNumeros(this.frmCarrera.getTxtSemanas()));
    }

    private void ocultarErrores() {
        this.frmCarrera.getLblErrorCodigo().setVisible(false);
        this.frmCarrera.getLblErrorNombre().setVisible(false);
    }

    private void guardarYSalir() {
        if (this.guardar()) {
            this.frmCarrera.dispose();
            this.ctrPrin.cerradoJIF();
        }
    }

    private void guardarYContinuar() {
        if (this.guardar()) {
            this.borrarCampos();
        }
    }

    private boolean guardar() {
        boolean guardar = true;
        SimpleDateFormat formFecha = new SimpleDateFormat("dd/MM/yyyy");
        Date fecha = this.frmCarrera.getJdFechaInicio().getDate();
        String fechaS = formFecha.format(fecha);
        String[] fec = fechaS.split("/");
        String dia = fec[0];
        String mes = fec[1];
        String anio = fec[2];
        String nombre = this.frmCarrera.getTxtNombre().getText();
        String codigo = this.frmCarrera.getTxtCodigo().getText();
        String semanas = this.frmCarrera.getTxtSemanas().getText();
        String modalidad = this.frmCarrera.getCmbModalidad().getSelectedItem().toString();
        int posCoord = this.frmCarrera.getTblDocentes().getSelectedRow();
        LocalDate fechaInicio = LocalDate.now();
        if (Validar.esNumeros(dia) && Validar.esNumeros(mes) && Validar.esNumeros(anio)) {
            try {
                fechaInicio = LocalDate.of(Integer.parseInt(anio), Integer.parseInt(mes), Integer.parseInt(dia));
            }
            catch (NumberFormatException e) {
                System.out.println("No es fecha. " + e.getMessage());
                guardar = false;
            }
        } else {
            guardar = false;
        }
        if (!Validar.esNumeros(semanas)) {
            guardar = false;
        }
        if (posCoord < 0) {
            guardar = false;
        }
        if (guardar) {
            CarreraBD CRBD = CarreraBD.single();
            CarreraMD car = new CarreraMD();
            car.setCodigo(codigo);
            car.setFechaInicio(fechaInicio);
            car.setModalidad(modalidad);
            car.setNombre(nombre);
            car.setCoordinador(this.docentes.get(posCoord));
            car.setNumSemanas(Integer.parseInt(semanas));
            if (this.editar) {
                car.setId(this.idCarrera);
                guardar = CRBD.editarCarrera(car);
                if (guardar) {
                    this.editar = false;
                    return true;
                }
            } else {
                guardar = CRBD.guardarCarrera(car);
            }
        }
        return guardar;
    }

    private void buscarDocentes(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.docentes = this.DBD.buscar(aguja);
            this.llenarTblDocentes(this.docentes);
        }
    }

    private void llenarTblDocentes(ArrayList<DocenteMD> docentes) {
        this.mdTbl.setRowCount(0);
        if (docentes != null) {
            docentes.forEach(d -> {
                Object[] valores = new Object[]{d.getIdentificacion(), d.getPrimerApellido() + " " + d.getSegundoApellido() + " " + d.getPrimerNombre() + "  " + d.getSegundoNombre()};
                this.mdTbl.addRow(valores);
            });
        }
    }

    public void editar(CarreraMD carrera) {
        this.frmCarrera.getTxtNombre().setText(carrera.getNombre());
        this.frmCarrera.getTxtCodigo().setText(carrera.getCodigo());
        this.fechaIni.set(carrera.getFechaInicio().getYear(), carrera.getFechaInicio().getMonthValue() - 1, carrera.getFechaInicio().getDayOfMonth());
        this.frmCarrera.getJdFechaInicio().setCalendar(this.fechaIni);
        this.frmCarrera.getCmbModalidad().setSelectedItem(carrera.getModalidad());
        this.frmCarrera.getTxtSemanas().setText(carrera.getNumSemanas() + "");
        if (carrera.getCoordinador().getIdentificacion() != null) {
            this.frmCarrera.getTxtBuscar().setText(carrera.getCoordinador().getIdentificacion());
            this.buscarDocentes(carrera.getCoordinador().getIdentificacion());
            this.frmCarrera.getTblDocentes().selectAll();
            this.frmCarrera.getTxtBuscar().setEnabled(false);
            this.frmCarrera.getBtnBuscar().setEnabled(false);
            this.frmCarrera.getTblDocentes().setEnabled(false);
        }
        this.editar = true;
        this.idCarrera = carrera.getId();
    }

    private void borrarCampos() {
        this.frmCarrera.getTxtNombre().setText("");
        this.frmCarrera.getTxtCodigo().setText("");
        this.frmCarrera.getJdFechaInicio().setCalendar(null);
        this.frmCarrera.getCmbModalidad().setSelectedItem("Seleccione");
        this.frmCarrera.getTxtBuscar().setText("");
        this.mdTbl.setRowCount(0);
    }

    private void cargarCmbModalidades() {
        this.frmCarrera.getCmbModalidad().removeAllItems();
        this.frmCarrera.getCmbModalidad().addItem("Seleccione");
        for (String m : this.MODALIDADES) {
            this.frmCarrera.getCmbModalidad().addItem(m);
        }
    }
}

