/*
 * Decompiled with CFR 0.152.
 */
package controlador.asistenciaAlumnos;

import controlador.Libraries.Middlewares;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import modelo.asistencia.AsistenciaMD;
import modelo.asistencia.FechasClase;
import modelo.asistencia.GenerarFechas;
import modelo.asistencia.NEWAsistenciaBD;
import modelo.curso.CursoMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoMD;
import utils.CONS;
import utils.M;
import vista.asistenciaAlumnos.NEWFrmAsistencia;

public class NEWFrmAsistenciaCTR
extends DCTR {
    private final NEWFrmAsistencia VTN = new NEWFrmAsistencia();
    private final NEWAsistenciaBD ABD = NEWAsistenciaBD.single();
    private List<PeriodoLectivoMD> pls;
    private List<CursoMD> cs;
    private List<FechasClase> fechas;
    private List<FechasClase> fechasSelec;
    private List<AsistenciaMD> as;
    private DefaultTableModel mdTbl;
    private int maxFaltas = 0;
    private int numAlum;

    public NEWFrmAsistenciaCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
    }

    public void iniciar() {
        this.iniciarCMBPeriodo();
        this.iniciarTablas();
        this.iniciarBuscarCmbFechas();
        this.ctrPrin.agregarVtn(this.VTN);
        this.iniciarAcciones();
        this.vtnCargada = true;
    }

    private void iniciarTablas() {
        String[] titulo = new String[]{"id", "#", "Alumno", "Faltas"};
        this.mdTbl = this.iniciarTblConEditar(this.VTN.getTblAlumnos(), titulo, 3);
        TblEstilo.ocualtarID(this.VTN.getTblAlumnos());
        TblEstilo.columnaMedida(this.VTN.getTblAlumnos(), 1, 30);
        TblEstilo.columnaMedida(this.VTN.getTblAlumnos(), 3, 50);
        this.VTN.getTblAlumnos().setRowHeight(25);
        this.VTN.getTblAlumnos().setModel(this.mdTbl);
    }

    private void iniciarAcciones() {
        this.VTN.getCmbMateria().addActionListener(e -> this.clickCmbCurso());
        this.VTN.getCmbPeriodo().addActionListener(e -> this.clickCmbPeriodo());
        this.VTN.getBtnCargarLista().addActionListener(e -> this.cargarLista());
        this.VTN.getBtnGuardar().addActionListener(e -> this.guardar());
        this.VTN.getBtnImprimir().addActionListener(e -> {
            int posPrd = this.VTN.getCmbPeriodo().getSelectedIndex();
            int posMateria = this.VTN.getCmbMateria().getSelectedIndex();
            int posFecha = this.VTN.getCmbFechas().getSelectedIndex();
            if (posPrd > 0 && posMateria > 0) {
                this.imprimirReporte();
            } else {
                M.errorMsg("Debe selecionar un periodo, una materia y la fecha para poder imprimir un reporte.");
            }
        });
        this.iniciarAccionesTbl();
    }

    private void iniciarAccionesTbl() {
        this.mdTbl.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    NEWFrmAsistenciaCTR.this.actualizarFalta();
                    this.active = false;
                }
            }
        });
    }

    private void actualizarFalta() {
        int colum = this.VTN.getTblAlumnos().getSelectedColumn();
        int row = this.VTN.getTblAlumnos().getSelectedRow();
        String estado = this.VTN.getTblAlumnos().getValueAt(row, colum).toString();
        if (estado.matches("[0-9]")) {
            int faltas = Integer.parseInt(estado);
            if (faltas > this.maxFaltas) {
                JOptionPane.showMessageDialog(this.VTN, "Hoy solo tenemos " + this.maxFaltas + " horas de clase.");
                this.VTN.getTblAlumnos().setValueAt(this.maxFaltas, row, colum);
            } else {
                this.VTN.getTblAlumnos().setValueAt(faltas, row, colum);
            }
        } else {
            this.VTN.getTblAlumnos().setValueAt(0, row, colum);
        }
    }

    private void iniciarCMBPeriodo() {
        this.pls = this.ABD.getPeriodosDocente(CONS.USUARIO.getPersona().getIdentificacion());
        this.VTN.getCmbPeriodo().removeAllItems();
        this.VTN.getCmbPeriodo().addItem("Seleccione");
        this.pls.forEach(p -> this.VTN.getCmbPeriodo().addItem(p.getNombre()));
    }

    private void clickCmbPeriodo() {
        int posPrd = this.VTN.getCmbPeriodo().getSelectedIndex();
        if (posPrd > 0) {
            this.cs = this.ABD.getCursosPeriodoDocente(this.pls.get(posPrd - 1).getID(), CONS.USUARIO.getPersona().getIdentificacion());
            this.VTN.getCmbMateria().removeAllItems();
            this.VTN.getCmbMateria().addItem("Seleccione");
            this.cs.forEach(c -> this.VTN.getCmbMateria().addItem(c.getNombre() + " | " + c.getMateria().getNombre()));
            this.vtnCargada = true;
        }
    }

    private void clickCmbCurso() {
        int posCurso = this.VTN.getCmbMateria().getSelectedIndex();
        if (posCurso > 0) {
            GenerarFechas gf = new GenerarFechas();
            this.fechas = gf.getFechasClaseCurso(this.cs.get(posCurso - 1).getId());
            this.fechasSelec = this.fechas;
            this.VTN.getCmbFechas().removeAllItems();
            this.VTN.getCmbFechas().addItem("");
            LocalDate ld = LocalDate.now();
            String fechaActual = (ld.getDayOfMonth() > 9 ? Integer.valueOf(ld.getDayOfMonth()) : "0" + ld.getDayOfMonth()) + "/" + (ld.getMonthValue() > 9 ? Integer.valueOf(ld.getMonthValue()) : "0" + ld.getMonthValue()) + "/" + ld.getYear();
            this.fechas.forEach(f -> {
                this.VTN.getCmbFechas().addItem(f.getFecha());
                if (f.getFecha().equals(fechaActual)) {
                    this.VTN.getCmbFechas().setSelectedItem(fechaActual);
                }
            });
        }
    }

    private void iniciarBuscarCmbFechas() {
        this.listenerCmbBuscador(this.VTN.getCmbFechas(), this.buscarFun());
    }

    private Function<String, Void> buscarFun() {
        return t -> {
            this.buscarCmbFechas((String)t);
            return null;
        };
    }

    private void buscarCmbFechas(String aguja) {
        this.VTN.getCmbFechas().removeAllItems();
        this.VTN.getCmbFechas().addItem(aguja);
        this.fechasSelec = new ArrayList<FechasClase>();
        this.fechas.forEach(f -> {
            if (f.getFecha().contains(aguja)) {
                this.VTN.getCmbFechas().addItem(f.getFecha());
                this.fechasSelec.add((FechasClase)f);
            }
        });
    }

    private void cargarLista() {
        String fecha = this.VTN.getCmbFechas().getSelectedItem().toString();
        int posCurso = this.VTN.getCmbMateria().getSelectedIndex();
        int posFecha = this.VTN.getCmbFechas().getSelectedIndex();
        if (!fecha.equals("") && posCurso > 0 && posFecha > 0) {
            this.as = this.ABD.getAlumnosCursoFicha(this.cs.get(posCurso - 1).getId(), fecha);
            this.maxFaltas = this.fechasSelec.get(posFecha - 1).getHoras();
            this.VTN.getLblInfo().setText(this.maxFaltas + " numero de horas clase.");
            if (this.as.size() > 0) {
                this.llenarTbl(this.as);
            } else {
                this.ABD.iniciarAsistenciaCursoFecha(this.cs.get(posCurso - 1).getId(), fecha);
                this.cargarLista();
            }
        } else {
            JOptionPane.showMessageDialog(this.VTN, "Debe seleccionar un curso y la fecha.");
        }
    }

    private void llenarTbl(List<AsistenciaMD> as) {
        this.mdTbl.setRowCount(0);
        this.numAlum = 0;
        as.forEach(a -> {
            ++this.numAlum;
            Object[] r = new Object[]{a.getId(), this.numAlum, a.getAlumnoCurso().getAlumno().getApellidosNombres(), a.getNumeroFaltas()};
            this.mdTbl.addRow(r);
        });
    }

    private void guardar() {
        String sql = "";
        for (int i = 0; i < this.VTN.getTblAlumnos().getRowCount(); ++i) {
            sql = sql + this.ABD.getSqlActualizar(Integer.parseInt(this.VTN.getTblAlumnos().getValueAt(i, 0).toString()), Integer.parseInt(this.VTN.getTblAlumnos().getValueAt(i, 3).toString()));
        }
        if (this.ABD.actualizarFaltas(sql)) {
            JOptionPane.showMessageDialog(this.VTN, "Guardamos correctamente las faltas.");
        } else {
            M.errorMsg("Error al guardar las faltas.");
        }
    }

    private void imprimirReporte() {
        int r = JOptionPane.showOptionDialog(this.VTN, "Reporte individual\n\u00bfElegir el tipo de Reporte?", "REPORTE UBE", 1, 1, null, new Object[]{"Reporte Asistencia", "Reporte Asistencia UBE", "Reporte Asistencia por D\u00eda"}, "Cancelar");
        switch (r) {
            case 0: {
                this.generarReporteAsistencia();
                break;
            }
            case 1: {
                this.generarReporteAsistenciaUBE();
                break;
            }
            case 2: {
                int posFecha = this.VTN.getCmbFechas().getSelectedIndex();
                if (posFecha > 0) {
                    this.generarReporteAsistenciaPorDia();
                    break;
                }
                M.errorMsg("Debe seleccionar una fecha para su reporte por dia.");
                break;
            }
        }
    }

    private void generarReporteAsistencia() {
        int posCurso = this.VTN.getCmbMateria().getSelectedIndex();
        String nombrePeriodo = this.VTN.getCmbPeriodo().getSelectedItem().toString().trim();
        String path = "/vista/asistenciaAlumnos/reporteAsistencia/reporteAsistencia.jasper";
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("id_curso", this.cs.get(posCurso - 1).getId());
        parametros.put("prd_lectivo_nombre", String.valueOf(nombrePeriodo));
        Middlewares.generarReporte(this.getClass().getResource(path), "Reporte Asistencia", parametros);
    }

    private void generarReporteAsistenciaUBE() {
        int posCurso = this.VTN.getCmbMateria().getSelectedIndex();
        String nombrePeriodo = this.VTN.getCmbPeriodo().getSelectedItem().toString().trim();
        String path = "/vista/asistenciaAlumnos/reporteAsistencia/reporteAsistenciaUBE.jasper";
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("id_curso", this.cs.get(posCurso - 1).getId());
        parametros.put("prd_lectivo_nombre", String.valueOf(nombrePeriodo));
        Middlewares.generarReporte(this.getClass().getResource(path), "Reporte Asistencia UBE", parametros);
    }

    private void generarReporteAsistenciaPorDia() {
        int posCurso = this.VTN.getCmbMateria().getSelectedIndex();
        String nombrePeriodo = this.VTN.getCmbPeriodo().getSelectedItem().toString().trim();
        String path = "/vista/asistenciaAlumnos/reporteAsistencia/reporteAsistenciaPorDia.jasper";
        HashMap<String, Object> parametros = new HashMap<String, Object>();
        parametros.put("id_curso", this.cs.get(posCurso - 1).getId());
        parametros.put("prd_lectivo_nombre", String.valueOf(nombrePeriodo));
        parametros.put("fecha_asistencia", this.VTN.getCmbFechas().getSelectedItem().toString());
        System.out.println(parametros);
        Middlewares.generarReporte(this.getClass().getResource(path), "Reporte Asistencia por D\u00eda", parametros);
    }
}

