/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCursoRetiradoBD;
import modelo.alumno.AlumnoCursoRetiradoMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.alumno.VtnMatriculasAnuladas;

public class VtnMatriculasAnuladasCTR
extends DVtnCTR {
    private final VtnMatriculasAnuladas vtnAR;
    private final AlumnoCursoRetiradoBD ACRBD = AlumnoCursoRetiradoBD.single();
    private ArrayList<AlumnoCursoRetiradoMD> almsCursosRetirados;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private int posPrd;

    public VtnMatriculasAnuladasCTR(VtnPrincipalCTR ctrPrin, VtnMatriculasAnuladas vtnAR) {
        super(ctrPrin);
        this.vtnAR = vtnAR;
    }

    public void iniciar() {
        this.iniciarDependencias();
        this.iniciarTblACR();
        this.iniciarBuscador();
        this.iniciarAcciones();
        this.formatoTbl();
        this.cargarAnulados();
        this.ctrPrin.agregarVtn(this.vtnAR);
        this.InitPermisos();
    }

    private void clickEliminar() {
        int r;
        this.posFila = this.vtnAR.getTblAlumnosClase().getSelectedRow();
        if (this.posFila >= 0 && (r = JOptionPane.showConfirmDialog(this.vtnAR, "Se eliminara la anulacion de \n" + this.almsCursosRetirados.get(this.posFila).getAlumnoCurso().getCurso().getMateria().getNombre() + "\n\u00bfSeguro que quiere continuar?")) == 0 && this.ACRBD.eliminar(this.almsCursosRetirados.get(this.posFila).getId())) {
            this.cargarAnulados();
        }
    }

    private void iniciarDependencias() {
        this.periodos = this.PLBD.cargarPrdParaCmbFrm();
        this.llenarCmbPrd(this.periodos);
        this.vtnAR.getLblResultados().setText("0 Resultados obtenidos.");
    }

    private void formatoTbl() {
        TblEstilo.formatoTbl(this.vtnAR.getTblAlumnosClase());
        this.vtnAR.getTblAlumnosClase().setModel(this.mdTbl);
    }

    private void iniciarAcciones() {
        this.vtnAR.getCmbPrdLectivos().addActionListener(e -> this.clickPrd());
        this.vtnAR.getCbxEliminados().addActionListener(e -> this.clickCbxEliminados());
        this.vtnAR.getBtnEliminar().addActionListener(e -> this.clickEliminar());
        this.vtnAR.getBtnBuscar().addActionListener(e -> this.buscar());
        this.vtnAR.getBtnImprimir().addActionListener(l -> this.llamaReporteAnulaciones());
    }

    private void clickCbxEliminados() {
        this.vtnAR.getTxtBuscar().setText("");
        if (this.vtnAR.getCbxEliminados().isSelected()) {
            this.vtnAR.getBtnEliminar().setEnabled(false);
            this.cargarEliminados();
        } else {
            this.vtnAR.getBtnEliminar().setEnabled(true);
            this.cargarAnulados();
        }
    }

    private void cargarEliminados() {
        this.almsCursosRetirados = this.ACRBD.cargarRetiradosEliminados();
        this.llenarTblAlmRetirado(this.almsCursosRetirados);
    }

    private void cargarAnulados() {
        this.almsCursosRetirados = this.ACRBD.cargarRetirados();
        this.llenarTblAlmRetirado(this.almsCursosRetirados);
    }

    private void iniciarBuscador() {
        this.vtnAR.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VtnMatriculasAnuladasCTR.this.buscar();
                } else if (VtnMatriculasAnuladasCTR.this.vtnAR.getTxtBuscar().getText().length() == 0) {
                    VtnMatriculasAnuladasCTR.this.mdTbl.setRowCount(0);
                }
            }
        });
    }

    private void buscar() {
        String b = this.vtnAR.getTxtBuscar().getText().trim();
        if (Validar.esLetrasYNumeros(b)) {
            if (this.vtnAR.getCbxEliminados().isSelected()) {
                this.buscarACRE(b);
            } else {
                this.buscarACR(b);
            }
        }
    }

    private void buscarACR(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.almsCursosRetirados = this.ACRBD.buscarRetirados(b);
            this.llenarTblAlmRetirado(this.almsCursosRetirados);
        }
    }

    private void buscarACRE(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.almsCursosRetirados = this.ACRBD.buscarRetiradosEliminados(b);
            this.llenarTblAlmRetirado(this.almsCursosRetirados);
        }
    }

    private void clickPrd() {
        this.posPrd = this.vtnAR.getCmbPrdLectivos().getSelectedIndex();
        if (this.posPrd > 0) {
            if (this.vtnAR.getCbxEliminados().isSelected()) {
                this.almsCursosRetirados = this.ACRBD.cargarRetiradosPorPrdEliminados(this.periodos.get(this.posPrd - 1).getID());
                this.llenarTblAlmRetirado(this.almsCursosRetirados);
            } else {
                this.almsCursosRetirados = this.ACRBD.cargarRetiradosPorPrd(this.periodos.get(this.posPrd - 1).getID());
                this.llenarTblAlmRetirado(this.almsCursosRetirados);
            }
        }
    }

    private void iniciarTblACR() {
        String[] t = new String[]{"Periodo", "Alumno", "Materia", "Fecha", "Observacion"};
        String[][] d = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(d, t);
    }

    private void cargarCmbACR() {
        this.periodos = this.PLBD.cargarPrdParaCmbVtn();
        this.llenarCmbPrd(this.periodos);
    }

    private void llenarTblAlmRetirado(ArrayList<AlumnoCursoRetiradoMD> almns) {
        this.vtnAR.getTblAlumnosClase().setModel(this.mdTbl);
        this.mdTbl.setRowCount(0);
        if (almns != null) {
            almns.forEach(a -> {
                Object[] v = new Object[]{a.getAlumnoCurso().getCurso().getPeriodo().getNombre(), a.getAlumnoCurso().getAlumno().getNombreCorto(), a.getAlumnoCurso().getCurso().getMateria().getNombre(), a.getFecha(), a.getObservacion()};
                this.mdTbl.addRow(v);
            });
            this.vtnAR.getLblResultados().setText(almns.size() + " Resultados obtendios.");
        } else {
            this.mdTbl.setRowCount(0);
        }
    }

    private void llenarCmbPrd(ArrayList<PeriodoLectivoMD> periodos) {
        this.vtnAR.getCmbPrdLectivos().removeAllItems();
        this.vtnAR.getCmbPrdLectivos().addItem("Seleccione");
        if (periodos != null) {
            periodos.forEach(p -> this.vtnAR.getCmbPrdLectivos().addItem(p.getNombre()));
            this.vtnAR.getCmbPrdLectivos().setSelectedIndex(0);
        }
    }

    private void InitPermisos() {
        this.vtnAR.getBtnEliminar().getAccessibleContext().setAccessibleName("Matriculas-Anuladas-Eliminar");
        this.vtnAR.getCbxEliminados().getAccessibleContext().setAccessibleName("Matriculas-Anuladas-Ver Eliminados");
        CONS.activarBtns(this.vtnAR.getBtnEliminar(), this.vtnAR.getCbxEliminados());
    }

    public void llamaReporteAnulaciones() {
        int filas = this.vtnAR.getTblAlumnosClase().getRowCount();
        if (filas > 0) {
            this.posFila = this.vtnAR.getCmbPrdLectivos().getSelectedIndex();
            if (this.posFila > 0) {
                try {
                    JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repAlumnosAnuladosCarrera.jasper"));
                    HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                    parametro.put("PeriodoLectivo", this.periodos.get(this.posFila - 1).getID());
                    CON.mostrarReporte(jr, parametro, "Reporte de Anulaciones");
                }
                catch (JRException ex) {
                    JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
                }
            } else {
                JOptionPane.showMessageDialog(null, "Selecione un periodo lectivo.");
            }
        } else {
            JOptionPane.showMessageDialog(null, "No se encuentran materias anuladas en este per\u00edodo.");
        }
    }
}

