/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.JDAnularMatriculaCTR;
import controlador.alumno.JDEditarMatriculaCTR;
import controlador.alumno.JDReporteTipoMatriculaCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.alumno.MatriculaBD;
import modelo.alumno.MatriculaMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.alumno.VtnMatricula;

public class VtnMatriculaCTR
extends DVtnCTR {
    private final VtnMatricula vtnMatri;
    private final MatriculaBD MTBD = MatriculaBD.single();
    private ArrayList<MatriculaMD> matriculas;
    private ArrayList<PeriodoLectivoMD> periodos;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private int posPrd;

    public VtnMatriculaCTR(VtnPrincipalCTR ctrPrin, VtnMatricula vtnMatri) {
        super(ctrPrin);
        this.vtnMatri = vtnMatri;
    }

    public void iniciar() {
        String[] t = new String[]{"Periodo", "Cedula", "Alumno", "Fecha"};
        this.mdTbl = this.iniciarTbl(this.vtnMatri.getTblMatricula(), t);
        TblEstilo.columnaMedida(this.vtnMatri.getTblMatricula(), 1, 100);
        this.llenarCmbPrd();
        this.cargarMatriculas();
        this.iniciarAcciones();
        this.formatoBuscador(this.vtnMatri.getTxtBuscar(), this.vtnMatri.getBtnBuscar());
        this.iniciarBuscador();
        this.ctrPrin.agregarVtn(this.vtnMatri);
        this.InitPermisos();
    }

    private boolean validarFecha() {
        LocalDate fi = this.PLBD.buscarFechaInicioPrd(this.matriculas.get(this.posFila).getPeriodo().getID());
        LocalDate fa = LocalDate.now();
        return fa.isBefore(fi.plusMonths(1L));
    }

    private void clickAnular() {
        this.posFila = this.vtnMatri.getTblMatricula().getSelectedRow();
        if (this.posFila >= 0) {
            if (this.validarFecha()) {
                JDAnularMatriculaCTR ctr = new JDAnularMatriculaCTR(this.ctrPrin, this.matriculas.get(this.posFila));
                ctr.iniciar();
            } else {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Ya pasaron mas de 30 dias ya no se puede anular la matricula.");
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una fila primero.");
        }
    }

    private void clickEditar() {
        this.posFila = this.vtnMatri.getTblMatricula().getSelectedRow();
        if (this.posFila >= 0) {
            JDEditarMatriculaCTR ctr = new JDEditarMatriculaCTR(this.ctrPrin, this.matriculas.get(this.posFila));
            ctr.iniciar();
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una fila primero.");
        }
    }

    private void iniciarBuscador() {
        this.vtnMatri.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VtnMatriculaCTR.this.buscar(VtnMatriculaCTR.this.vtnMatri.getTxtBuscar().getText().trim());
                } else if (VtnMatriculaCTR.this.vtnMatri.getTxtBuscar().getText().length() == 0) {
                    VtnMatriculaCTR.this.cargarMatriculas();
                }
            }
        });
    }

    private void buscar(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.matriculas = this.MTBD.buscarMatriculas(aguja);
            this.llenarTbl(this.matriculas);
        }
    }

    private void iniciarAcciones() {
        this.vtnMatri.getCmbPeriodos().addActionListener(e -> this.clickPrd());
        this.vtnMatri.getBtnImprimirFicha().addActionListener(e -> this.clickImprimirFicha());
        this.vtnMatri.getBtnHistoria().addActionListener(e -> this.llamaReporteMatriculaPeriodo());
        this.vtnMatri.getBtnIngresar().addActionListener(e -> this.abrirFrm());
        this.vtnMatri.getBtnEditar().addActionListener(e -> this.clickEditar());
        this.vtnMatri.getBtnAnular().addActionListener(e -> this.clickAnular());
        this.vtnMatri.getBtnCartaCompromiso().addActionListener(e -> this.clickCartaCompromiso());
        this.vtnMatri.getBtnNumMatricula().addActionListener(e -> this.clickNumMatricula());
        this.vtnMatri.getBtnReporteTipoMatricula().addActionListener(e -> this.abrirJDReporteTipoMatricula());
    }

    private void abrirJDReporteTipoMatricula() {
        JDReporteTipoMatriculaCTR ctr = new JDReporteTipoMatriculaCTR(this.ctrPrin, this.periodos);
        ctr.iniciar();
    }

    private void cargarMatriculas() {
        this.matriculas = this.MTBD.cargarMatriculas();
        this.llenarTbl(this.matriculas);
    }

    private void clickPrd() {
        this.posPrd = this.vtnMatri.getCmbPeriodos().getSelectedIndex();
        if (this.posPrd > 0) {
            this.matriculas = this.MTBD.cargarMatriculasPorPrd(this.periodos.get(this.posPrd - 1).getID());
            this.llenarTbl(this.matriculas);
        } else {
            this.cargarMatriculas();
        }
    }

    private void llenarCmbPrd() {
        this.periodos = this.PLBD.cargarPrdParaCmbVtn();
        this.vtnMatri.getCmbPeriodos().removeAllItems();
        if (this.periodos != null) {
            this.vtnMatri.getCmbPeriodos().addItem("Seleccione");
            this.periodos.forEach(p -> this.vtnMatri.getCmbPeriodos().addItem(p.getNombre()));
        }
    }

    private void llenarTbl(ArrayList<MatriculaMD> matriculas) {
        this.mdTbl.setRowCount(0);
        if (matriculas != null) {
            matriculas.forEach(m -> {
                Object[] v = new Object[]{m.getPeriodo().getNombre(), m.getAlumno().getIdentificacion(), m.getAlumno().getNombreCompleto(), m.getSoloFecha(), m.getSoloHora()};
                this.mdTbl.addRow(v);
            });
            this.vtnMatri.getLblNumResultados().setText(matriculas.size() + " Resultados obtenidos.");
        } else {
            this.vtnMatri.getLblNumResultados().setText("0 Resultados obtenidos.");
        }
    }

    private void abrirFrm() {
        this.ctrPrin.abrirFrmMatricula();
    }

    private void clickImprimirFicha() {
        this.posFila = this.vtnMatri.getTblMatricula().getSelectedRow();
        if (this.posFila >= 0) {
            int s = JOptionPane.showOptionDialog(this.vtnMatri, "Reporte de matricula\n\u00bfElegir el tipo de reporte?", "Ficha matricula", 1, 1, null, new Object[]{"Con Foto", "Sin Foto", "Cancelar"}, "Con Foto");
            switch (s) {
                case 0: {
                    this.llamaReporteMatricula();
                    break;
                }
                case 1: {
                    this.llamaReporteMatriculaSinFoto();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una persona antes.");
        }
    }

    private void clickCartaCompromiso() {
        this.posFila = this.vtnMatri.getTblMatricula().getSelectedRow();
        if (this.posFila >= 0) {
            int s = JOptionPane.showOptionDialog(this.vtnMatri, "Reporte de matricula\n\u00bfElegir el tipo de carta compromiso?", "Cartas compromiso", 1, 1, null, new Object[]{"Acta", "Segunda Matricula", "Tercera Matricula", "Cancelar"}, "Acta");
            switch (s) {
                case 0: {
                    this.llamaReporteActa();
                    break;
                }
                case 1: {
                    this.llamaReporteCartaNumMatricula(2, "SEGUNDA MATR\u00cdCULA");
                    break;
                }
                case 2: {
                    this.llamaReporteCartaNumMatricula(3, "TERCERA MATR\u00cdCULA");
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una persona antes.");
        }
    }

    private void clickNumMatricula() {
        this.posPrd = this.vtnMatri.getCmbPeriodos().getSelectedIndex();
        if (this.posPrd > 0) {
            int s = JOptionPane.showOptionDialog(this.vtnMatri, "Reporte de  numero de matricula\nElija el numero de matricula", "Numero de matricula", 1, 1, null, new Object[]{"Primera Matricula", "Segunda Matricula", "Tercera Matricula", "Completo", "Cancelar"}, "Completo");
            switch (s) {
                case 0: {
                    this.llamarReporteNumMatricula(1);
                    break;
                }
                case 1: {
                    this.llamarReporteNumMatricula(2);
                    break;
                }
                case 2: {
                    this.llamarReporteNumMatricula(3);
                    break;
                }
                case 3: {
                    this.llamarReporteMatriculados(this.posPrd);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar un periodo lectivo.");
        }
    }

    private String selecCurso() {
        ArrayList<String> cursos = this.MTBD.cursosMatriculado(this.matriculas.get(this.posFila).getAlumno().getId_Alumno(), this.matriculas.get(this.posFila).getPeriodo().getID());
        Object np = JOptionPane.showInputDialog(null, "Cursos en los que se matriculo: ", "Matricula", 3, null, cursos.toArray(), "Seleccione");
        if (np == null) {
            JOptionPane.showMessageDialog(null, "Debe seleccionar un curso");
            this.selecCurso();
            return null;
        }
        return np.toString();
    }

    private void llamaReporteMatricula() {
        try {
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repImpresionMatricula.jasper"));
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("cedula", this.matriculas.get(this.posFila).getAlumno().getIdentificacion());
            parametro.put("idPeriodo", this.matriculas.get(this.posFila).getPeriodo().getID());
            parametro.put("usuario", CONS.USUARIO.getUsername());
            CON.mostrarReporte(jr, parametro, "Reporte de Matricula");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    private void llamaReporteMatriculaSinFoto() {
        try {
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repMatriculaSinFoto.jasper"));
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("cedula", this.matriculas.get(this.posFila).getAlumno().getIdentificacion());
            parametro.put("idPeriodo", this.matriculas.get(this.posFila).getPeriodo().getID());
            parametro.put("usuario", CONS.USUARIO.getUsername());
            CON.mostrarReporte(jr, parametro, "Reporte de Matricula | Sin foto");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    private void llamaReporteMatriculaPeriodo() {
        int posCombo = this.vtnMatri.getCmbPeriodos().getSelectedIndex();
        if (posCombo > 0) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repMatriculadosPeriodo.jasper"));
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("periodo", this.periodos.get(posCombo - 1).getID());
                parametro.put("periodo_titulo", this.periodos.get(this.posPrd - 1).getNombre());
                CON.mostrarReporte(jr, parametro, "Reporte Historial de Matr\u00edcula por Periodo");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(null, "Seleccione un periodo lectivo, del combo.");
        }
    }

    private void llamaReporteActa() {
        String curso = this.selecCurso();
        if (curso != null) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/cartaCompromiso.jasper"));
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("idAlumno", this.matriculas.get(this.posFila).getAlumno().getId_Alumno());
                parametro.put("idPeriodo", this.matriculas.get(this.posFila).getPeriodo().getID());
                parametro.put("curso", curso);
                CON.mostrarReporte(jr, parametro, "Reporte de Matricula");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(null, "No selecciono un curso.");
        }
    }

    private void llamaReporteCartaNumMatricula(int numMatricula, String matricula) {
        String curso = this.selecCurso();
        if (curso != null) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/cartaNumMatricula.jasper"));
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("idAlumno", this.matriculas.get(this.posFila).getAlumno().getId_Alumno());
                parametro.put("idPeriodo", this.matriculas.get(this.posFila).getPeriodo().getID());
                parametro.put("curso", curso);
                parametro.put("numMatricula", numMatricula);
                parametro.put("matricula", matricula);
                System.out.println("Parametros: " + parametro);
                CON.mostrarReporte(jr, parametro, "Reporte de Matricula");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(null, "No selecciono un curso.");
        }
    }

    private void InitPermisos() {
        this.vtnMatri.getBtnIngresar().getAccessibleContext().setAccessibleName("Matricula-Ingresar");
        this.vtnMatri.getBtnAnular().getAccessibleContext().setAccessibleName("Matricula-Anular");
        this.vtnMatri.getBtnEditar().getAccessibleContext().setAccessibleName("Matricula-Editar");
        this.vtnMatri.getBtnCartaCompromiso().getAccessibleContext().setAccessibleName("Matricula-Reporte-Carta");
        this.vtnMatri.getBtnHistoria().getAccessibleContext().setAccessibleName("Matricula-Reporte-Historial");
        this.vtnMatri.getBtnImprimirFicha().getAccessibleContext().setAccessibleName("Matricula-Imprimir");
        CONS.activarBtns(this.vtnMatri.getBtnIngresar(), this.vtnMatri.getBtnAnular(), this.vtnMatri.getBtnEditar(), this.vtnMatri.getBtnCartaCompromiso(), this.vtnMatri.getBtnHistoria(), this.vtnMatri.getBtnImprimirFicha());
    }

    private void llamarReporteNumMatricula(int numMatricula) {
        this.posPrd = this.vtnMatri.getCmbPeriodos().getSelectedIndex();
        if (this.posPrd > 0) {
            try {
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repNumMatriculaPeriodo.jasper"));
                HashMap<String, Integer> parametro = new HashMap<String, Integer>();
                parametro.put("matricula", numMatricula);
                parametro.put("periodo", this.periodos.get(this.posPrd - 1).getID());
                System.out.println("Parametros: " + parametro);
                CON.mostrarReporte(jr, parametro, "Reporte de Matricula");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage());
            }
        } else {
            JOptionPane.showMessageDialog(null, "Debe seleccionar un periodo lectivo.");
        }
    }

    private void llamarReporteMatriculados(int posPrd) {
        try {
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repMatriculasPeriodo.jasper"));
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("periodo", this.periodos.get(posPrd - 1).getID());
            parametro.put("periodo_titulo", this.periodos.get(posPrd - 1).getNombre());
            System.out.println("Parametros: " + ((Object)parametro).toString());
            CON.mostrarReporte(jr, parametro, "Reporte de Matricula");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "Error: " + ex.getMessage());
        }
    }
}

