/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.FrmMallaActualizarCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Cursor;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCarreraBD;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.MaestroNotas;
import modelo.alumno.MaestroNotasBD;
import modelo.alumno.MallaAlumnoBD;
import modelo.alumno.MallaAlumnoMD;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import utils.ToExcel;
import vista.alumno.VtnMallaAlumno;

public class VtnMallaAlumnoCTR
extends DVtnCTR {
    private final VtnMallaAlumno vtnMallaAlm;
    private final MallaAlumnoBD MABD = MallaAlumnoBD.single();
    private final MaestroNotasBD MNOTASBD = MaestroNotasBD.single();
    private final String[] cmbEstado = new String[]{"Seleccione", "Cursado", "Matriculado", "Pendiente", "Reprobado", "Anulado/Retirado"};
    private ArrayList<MallaAlumnoMD> mallas = new ArrayList();
    private final AlumnoCarreraBD ACRBD = AlumnoCarreraBD.single();
    private ArrayList<AlumnoCarreraMD> alumnos;
    private final CarreraBD CRBD = CarreraBD.single();
    private ArrayList<CarreraMD> carreras = new ArrayList();
    private DefaultTableModel mdlTbl;
    private ArrayList<Integer> ciclos;
    private final MateriaBD MTBD = MateriaBD.single();
    private boolean cargados = false;
    private static double suma;

    public VtnMallaAlumnoCTR(VtnMallaAlumno vtnMallaAlm, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnMallaAlm = vtnMallaAlm;
    }

    public void iniciar() {
        String[] titulo = new String[]{"id", "Alumno", "Materia", "Estado", "Ciclo", "Matr\u00edcula", "Nota 1", "Nota 2", "Nota 3"};
        String[][] datos = new String[][]{};
        this.mdlTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        TblEstilo.formatoTbl(this.vtnMallaAlm.getTblMallaAlumno());
        this.vtnMallaAlm.getTblMallaAlumno().setModel(this.mdlTbl);
        TblEstilo.columnaMedida(this.vtnMallaAlm.getTblMallaAlumno(), 4, 60);
        TblEstilo.columnaMedida(this.vtnMallaAlm.getTblMallaAlumno(), 5, 60);
        TblEstilo.columnaMedida(this.vtnMallaAlm.getTblMallaAlumno(), 6, 60);
        TblEstilo.columnaMedida(this.vtnMallaAlm.getTblMallaAlumno(), 7, 60);
        TblEstilo.columnaMedida(this.vtnMallaAlm.getTblMallaAlumno(), 8, 60);
        this.cargarCmbCarrera();
        this.vtnMallaAlm.getCmbAlumnos().setEnabled(false);
        this.vtnMallaAlm.getCmbEstado().setEnabled(false);
        this.vtnMallaAlm.getCmbCarreras().addActionListener(e -> this.clickCombo());
        this.vtnMallaAlm.getCmbAlumnos().addActionListener(e -> this.clickCombo());
        this.vtnMallaAlm.getCmbEstado().addActionListener(e -> this.clickCombo());
        this.vtnMallaAlm.getCmbCiclo().addActionListener(e -> this.clickCombo());
        this.vtnMallaAlm.getBtnActualizarNota().addActionListener(e -> this.actualizarNotas());
        this.vtnMallaAlm.getBtnIngNota().addActionListener(e -> this.ingresarNota());
        this.vtnMallaAlm.getBtnReporteCarrera().addActionListener(e -> this.reportePorCarrera());
        this.vtnMallaAlm.getBtnBuscar().addActionListener(e -> this.buscarMalla(this.vtnMallaAlm.getTxtBuscar().getText().trim()));
        this.vtnMallaAlm.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnMallaAlm.getTxtBuscar()));
        this.vtnMallaAlm.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnMallaAlumnoCTR.this.vtnMallaAlm.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnMallaAlumnoCTR.this.buscarMalla(b);
                } else if (b.length() == 0) {
                    VtnMallaAlumnoCTR.this.mdlTbl.setRowCount(0);
                }
            }
        });
        this.vtnMallaAlm.getBtnReporteMallaAlumno().addActionListener(e -> this.llamaReporteMallaALumno());
        this.vtnMallaAlm.getBtnExportarExcel().addActionListener(e -> this.clickReporteExcel());
        this.vtnMallaAlm.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnMallaAlm.getTxtBuscar(), this.vtnMallaAlm.getBtnBuscar()));
        this.vtnMallaAlm.getCmbAlumnos().setEditable(true);
        this.vtnMallaAlm.getCmbAlumnos().getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String a = VtnMallaAlumnoCTR.this.vtnMallaAlm.getCmbAlumnos().getEditor().getItem().toString().trim();
                if (e.getKeyCode() != 38 && e.getKeyCode() != 40 && e.getKeyCode() != 37 && e.getKeyCode() != 39 && e.getKeyCode() != 13 && e.getKeyCode() == 10) {
                    VtnMallaAlumnoCTR.this.buscarAlumno(a);
                }
            }
        });
        this.vtnMallaAlm.getTblMallaAlumno().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
        this.InitPermisosTester();
        this.ctrPrin.agregarVtn(this.vtnMallaAlm);
        this.InitPermisos();
        this.vtnMallaAlm.getBtnImportarSiga().addActionListener(l -> this.MigraSiga());
    }

    private void MigraSiga() {
        String mallaEstado = "";
        ArrayList<MaestroNotas> maestro = this.MNOTASBD.recorreMaestroNotas();
        if (maestro != null) {
            maestro.forEach(m -> {
                try {
                    String idMateria;
                    boolean encontreMateria = false;
                    String cedula = m.getIdentificacion();
                    String carrera = m.getIdCarrera();
                    String sqldatos = "select id_almn_carrera as alumno_carrera,C.id_carrera as id_carrera\nfrom \"AlumnosCarrera\"\njoin \"Alumnos\" A on A.id_alumno = \"AlumnosCarrera\".id_alumno\njoin \"Carreras\" C on \"AlumnosCarrera\".id_carrera = C.id_carrera\nwhere alumno_codigo='" + cedula + "' and carrera_codigo='" + carrera + "'";
                    System.out.println(sqldatos);
                    ResultSet estudiante = CON.ejecutarQuery(sqldatos);
                    String idAlumnoCarrera = "";
                    String idCarrera = "";
                    if (estudiante.next()) {
                        idAlumnoCarrera = estudiante.getString("alumno_carrera");
                        idCarrera = estudiante.getString("id_carrera");
                        System.out.println("IDCARRERA==>" + idCarrera + "<==IDCARRERA");
                    } else {
                        idAlumnoCarrera = sqldatos;
                        idCarrera = "0";
                        System.out.println("IDCARRERA==>NO SE ECUENTRA ESTUDIANTE EN LA CARRERA CON ESTA MATERIA<==IDCARRERA");
                    }
                    CON.close(estudiante);
                    String codigoSiga = m.getIdAsignatura();
                    String sqldatos2 = "select id_materia from \"Materias\" where codigo_siga='" + codigoSiga + "' and id_carrera=" + idCarrera;
                    System.out.println(sqldatos2);
                    ResultSet materia = CON.ejecutarQuery(sqldatos2);
                    if (materia.next()) {
                        idMateria = materia.getString("id_materia");
                        encontreMateria = true;
                    } else {
                        encontreMateria = false;
                        idMateria = "NO SE ECUENTRA MATERIA" + codigoSiga;
                    }
                    CON.close(materia);
                    String estado = "P";
                    if (m.getEstado().equals("APROBADO")) {
                        estado = "C";
                    }
                    if (m.getEstado().equals("REPROBADO")) {
                        estado = "R";
                    }
                    if (m.getEstado().equals("RETIRADO")) {
                        estado = "R";
                    }
                    if (m.getEstado().equals("DESERTOR")) {
                        estado = "R";
                    }
                    double notaFinal = m.getNotaFinal() * 10.0;
                    int numeroMatricula = m.getNumMatricula();
                    String sqlUpdate = "";
                    sqlUpdate = sqlUpdate + "UPDATE \"MallaAlumno\" ";
                    sqlUpdate = sqlUpdate + "set malla_almn_estado='" + estado + "',";
                    sqlUpdate = sqlUpdate + " malla_alm_observacion='SIGA 2025-1P',";
                    if (numeroMatricula == 1) {
                        sqlUpdate = sqlUpdate + "malla_almn_nota1=" + notaFinal + "";
                    }
                    if (numeroMatricula == 2) {
                        sqlUpdate = sqlUpdate + "malla_almn_nota2=" + notaFinal + "";
                    }
                    if (numeroMatricula == 3) {
                        sqlUpdate = sqlUpdate + "malla_almn_nota3=" + notaFinal + "";
                    }
                    sqlUpdate = sqlUpdate + " where id_almn_carrera=" + idAlumnoCarrera + " and id_materia=" + idMateria + "";
                    System.out.println(sqlUpdate);
                    if (encontreMateria) {
                        SQLException resUpdate = CON.ejecutar(sqlUpdate);
                        if (resUpdate == null) {
                            System.out.println("====>OK<=======");
                            System.out.println("Se Actualizo correctamente en Malla Alumno.");
                            System.out.println("Cedula: " + cedula + "\n Carrera: " + carrera + " \n Cod_siga:" + codigoSiga + "\n Carrera:" + m.getCarrera() + "\n Asignatura:" + m.getAsignatura() + "\n Id_alumnoCarrera: " + idAlumnoCarrera + "\n IdCarrera: " + idCarrera + "\n IdMateria: " + idMateria + "\n Estado: " + estado + "\n NotaFinalX100: " + notaFinal + "\n Nota Final SIGA" + m.getNotaFinal());
                        } else {
                            System.err.println("Error al realizar la actualizaci\u00f3n: " + resUpdate.getMessage());
                        }
                    } else {
                        System.out.println("====>NO SE ENCUENTRA MATERIA<=======");
                    }
                }
                catch (SQLException ex) {
                    Logger.getLogger(VtnMallaAlumnoCTR.class.getName()).log(Level.SEVERE, null, ex);
                }
            });
            System.out.println("TERMINADO!!!!");
        } else {
            this.vtnMallaAlm.getLblResultados().setText("0 Resultados obtenidos.");
        }
    }

    private void InitPermisosTester() {
        if (CONS.ROL.getNombre().equalsIgnoreCase("TESTER")) {
            this.vtnMallaAlm.getBtnIngNota().setEnabled(false);
            this.vtnMallaAlm.getBtnActualizarNota().setEnabled(false);
            this.vtnMallaAlm.getTxtBuscar().setEnabled(false);
        }
    }

    public void actualizarVtn(MallaAlumnoMD m) {
        this.mallas = this.MABD.cargarMallasPorEstudiante(m.getAlumnoCarrera().getId());
        this.llenarTbl(this.mallas);
        this.vtnMallaAlm.setVisible(true);
    }

    private void actualizarNotas() {
        this.posFila = this.vtnMallaAlm.getTblMallaAlumno().getSelectedRow();
        if (this.posFila >= 0) {
            FrmMallaActualizarCTR ctrFrm = new FrmMallaActualizarCTR(this.ctrPrin, this.mallas.get(this.posFila), this.MABD, this);
            ctrFrm.iniciar();
            this.vtnMallaAlm.setVisible(false);
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleecionar una fila antes.");
        }
    }

    private void buscarAlumno(String aguja) {
        int posCar = this.vtnMallaAlm.getCmbCarreras().getSelectedIndex();
        if (Validar.esLetrasYNumeros(aguja)) {
            this.alumnos = this.ACRBD.buscarAlumnoCarrera(this.carreras.get(posCar - 1).getId(), aguja);
            this.llenarCmbAlumno(this.alumnos);
            this.vtnMallaAlm.getCmbAlumnos().showPopup();
        }
    }

    private void buscarMalla(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.mallas = this.MABD.buscarMallaAlumno(aguja);
            this.llenarTbl(this.mallas);
        }
    }

    private void cargarPorAlumno() {
        int posAlm = this.vtnMallaAlm.getCmbAlumnos().getSelectedIndex();
        if (posAlm > 0) {
            this.mallas = this.MABD.cargarMallasPorEstudiante(this.alumnos.get(posAlm - 1).getId());
            this.vtnMallaAlm.getCmbEstado().setEnabled(true);
            this.posFila = this.vtnMallaAlm.getCmbAlumnos().getSelectedIndex() - 1;
            if (this.posFila >= 0) {
                this.vtnMallaAlm.getBtnReporteMallaAlumno().setEnabled(true);
            }
            this.llenarTbl(this.mallas);
        } else {
            this.mdlTbl.setRowCount(0);
            this.vtnMallaAlm.getCmbEstado().removeAllItems();
        }
    }

    private void ingresarNota() {
        int pos = this.vtnMallaAlm.getTblMallaAlumno().getSelectedRow();
        if (pos >= 0) {
            MallaAlumnoMD malla = this.mallas.get(pos);
            if (malla.getMallaNumMatricula() > 0) {
                if (malla.getEstado().equals("C")) {
                    JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Ya curs\u00f3 \u00e9sta materia, no se puede ingresar  una nota.");
                } else {
                    String nota = JOptionPane.showInputDialog("Ingrese la nota de \n" + malla.getMateria().getNombre() + "\nN\u00famero de matr\u00edcula: " + malla.getMallaNumMatricula());
                    if (Validar.esNota(nota)) {
                        this.MABD.ingresarNota(malla.getId(), malla.getMallaNumMatricula(), Double.parseDouble(nota));
                    } else {
                        JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Ingrese una nota v\u00e1lida.");
                        this.ingresarNota();
                    }
                }
            } else {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "No se encuentra matr\u00edcula en esta \nmateria, no puede ingresar su nota.");
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una fila para poder ingresar una nota.");
        }
    }

    private void clickCombo() {
        int posCar = this.vtnMallaAlm.getCmbCarreras().getSelectedIndex();
        int ciclo = this.vtnMallaAlm.getCmbCiclo().getSelectedIndex();
        int posEst = this.vtnMallaAlm.getCmbEstado().getSelectedIndex();
        int posAlm = this.vtnMallaAlm.getCmbAlumnos().getSelectedIndex();
        if (posAlm < 1) {
            if (posCar > 0 && ciclo > 0 && posEst > 0) {
                this.mallas = this.MABD.cargarMallaPorCarreraCicloEstado(this.carreras.get(posCar - 1).getId(), ciclo, this.cmbEstado[posEst]);
                this.llenarTbl(this.mallas);
            } else if (posCar > 0 && ciclo > 0 && posEst == 0) {
                this.mallas = this.MABD.cargarMallaPorCarreraCiclo(this.carreras.get(posCar - 1).getId(), ciclo);
                this.llenarTbl(this.mallas);
            } else if (posCar > 0 && posEst > 0 && ciclo == 0) {
                this.mallas = this.MABD.cargarMallaPorCarreraEstado(this.carreras.get(posCar - 1).getId(), this.cmbEstado[posEst]);
                this.llenarTbl(this.mallas);
            } else if (posCar > 0) {
                this.vtnMallaAlm.getCmbAlumnos().setEnabled(true);
                this.vtnMallaAlm.getCmbEstado().setEnabled(true);
                if (!this.cargados) {
                    this.cargados = true;
                    this.cargarCmbEstado();
                    this.ciclos = this.MTBD.cargarCiclosCarrera(this.carreras.get(posCar - 1).getId());
                    this.cargarCmbCiclos(this.ciclos);
                }
            } else {
                this.cargados = false;
                this.vtnMallaAlm.getCmbAlumnos().removeAllItems();
                this.vtnMallaAlm.getCmbAlumnos().setEnabled(false);
                this.vtnMallaAlm.getCmbEstado().setEnabled(false);
                this.vtnMallaAlm.getCmbCiclo().removeAllItems();
                this.vtnMallaAlm.getCmbEstado().removeAllItems();
            }
        } else if (posEst > 0 && ciclo > 0) {
            this.mallas = this.MABD.cargarMallaAlumnoPorEstadoCiclo(this.alumnos.get(posAlm - 1).getId(), ciclo, this.cmbEstado[posEst]);
            this.llenarTbl(this.mallas);
        } else if (posEst > 0 && ciclo == 0) {
            this.mallas = this.MABD.cargarMallaAlumnoPorEstado(this.alumnos.get(posAlm - 1).getId(), this.cmbEstado[posEst]);
            this.llenarTbl(this.mallas);
        } else if (ciclo > 0 && posEst == 0) {
            this.mallas = this.MABD.cargarMallaAlumnoPorCiclo(this.alumnos.get(posAlm - 1).getId(), ciclo);
            this.llenarTbl(this.mallas);
        } else {
            this.cargarPorAlumno();
        }
    }

    private void llenarTbl(ArrayList<MallaAlumnoMD> mallas) {
        suma = 0.0;
        this.mdlTbl.setRowCount(0);
        if (mallas != null) {
            mallas.forEach(m -> {
                Object[] valores = new Object[]{m.getId(), m.getAlumnoCarrera().getAlumno().getPrimerNombre() + " " + m.getAlumnoCarrera().getAlumno().getSegundoNombre() + " " + m.getAlumnoCarrera().getAlumno().getPrimerApellido() + " " + m.getAlumnoCarrera().getAlumno().getSegundoApellido(), m.getMateria().getNombre(), m.getEstado(), m.getMallaCiclo(), m.getMallaNumMatricula(), m.getNota1(), m.getNota2(), m.getNota3()};
                this.mdlTbl.addRow(valores);
                switch (m.getMallaNumMatricula()) {
                    case 1: {
                        suma += m.getNota1();
                        break;
                    }
                    case 2: {
                        suma += m.getNota2();
                        break;
                    }
                    case 3: {
                        suma += m.getNota3();
                    }
                }
            });
            double promedio = suma / (double)mallas.size();
            this.vtnMallaAlm.getTxtPromedio().setText(String.format("%.2f", promedio));
            this.vtnMallaAlm.getLblResultados().setText(mallas.size() + " Resultados obtenidos.");
        } else {
            this.vtnMallaAlm.getLblResultados().setText("0 Resultados obtenidos.");
        }
    }

    private void cargarCmbCarrera() {
        this.carreras = this.CRBD.cargarCarrerasCmb();
        this.vtnMallaAlm.getCmbCarreras().removeAllItems();
        if (this.carreras != null) {
            this.vtnMallaAlm.getCmbCarreras().addItem("Seleccione");
            if (!CONS.ROL.getNombre().equalsIgnoreCase("TESTER")) {
                this.carreras.forEach(c -> this.vtnMallaAlm.getCmbCarreras().addItem(c.getCodigo()));
            } else {
                this.vtnMallaAlm.getCmbCarreras().addItem("TAS");
            }
        }
    }

    private void cargarCmbCiclos(ArrayList<Integer> ciclos) {
        this.vtnMallaAlm.getCmbCiclo().removeAllItems();
        this.vtnMallaAlm.getCmbCiclo().addItem("Todos");
        ciclos.forEach(c -> this.vtnMallaAlm.getCmbCiclo().addItem(c + ""));
        this.vtnMallaAlm.getCmbCiclo().setSelectedIndex(0);
    }

    private void llenarCmbAlumno(ArrayList<AlumnoCarreraMD> alumnos) {
        this.vtnMallaAlm.getCmbAlumnos().removeAllItems();
        if (alumnos != null) {
            this.vtnMallaAlm.getCmbAlumnos().addItem("");
            alumnos.forEach(a -> this.vtnMallaAlm.getCmbAlumnos().addItem(a.getAlumno().getPrimerApellido() + " " + a.getAlumno().getSegundoApellido() + " " + a.getAlumno().getPrimerNombre() + " " + a.getAlumno().getSegundoNombre()));
        }
    }

    private void cargarCmbEstado() {
        this.vtnMallaAlm.getCmbEstado().removeAllItems();
        for (String e : this.cmbEstado) {
            this.vtnMallaAlm.getCmbEstado().addItem(e);
        }
        this.vtnMallaAlm.getCmbEstado().setSelectedIndex(0);
    }

    private void InitPermisos() {
        this.vtnMallaAlm.getBtnActualizarNota().getAccessibleContext().setAccessibleName("Malla-Alumnos-Actualizar Nota");
        this.vtnMallaAlm.getBtnIngNota().getAccessibleContext().setAccessibleName("Malla-Alumnos-Ingresar Nota");
        this.vtnMallaAlm.getBtnReporteMallaAlumno().getAccessibleContext().setAccessibleName("Malla-Alumno-Reporte-Malla de Alumno");
        CONS.activarBtns(this.vtnMallaAlm.getBtnActualizarNota(), this.vtnMallaAlm.getBtnIngNota(), this.vtnMallaAlm.getBtnReporteMallaAlumno());
        if (CONS.ROL.getNombre().equalsIgnoreCase("Coordinador") || CONS.ROL.getNombre().equalsIgnoreCase("Dev") || CONS.ROL.getNombre().equalsIgnoreCase("Secretaria") || CONS.ROL.getNombre().equalsIgnoreCase("Secretario") || CONS.ROL.getNombre().equalsIgnoreCase("Coordinada/o")) {
            this.vtnMallaAlm.getBtnExportarExcel().setEnabled(true);
        } else {
            this.vtnMallaAlm.getBtnExportarExcel().setEnabled(false);
        }
    }

    private void reportePorCarrera() {
        int pos = this.vtnMallaAlm.getCmbCarreras().getSelectedIndex();
        if (pos > 0) {
            this.MABD.cargarMallaPorCarrera(this.carreras.get(pos - 1).getId());
            this.vtnMallaAlm.setCursor(new Cursor(3));
            this.reporteGrande();
        } else {
            JOptionPane.showMessageDialog(this.vtnMallaAlm, "Seleccione una carrera.");
        }
    }

    public void llamaReporteMallaALumno() {
        int posCar = this.vtnMallaAlm.getCmbCarreras().getSelectedIndex();
        if (this.MABD.getSql().length() > 0 && posCar > 0) {
            if (this.vtnMallaAlm.getCmbAlumnos().getSelectedIndex() > 0 || this.mallas.size() < 50) {
                String path = "/vista/reportes/repMalaAlumno_3.jasper";
                try {
                    HashMap<String, Object> parametro = new HashMap<String, Object>();
                    parametro.put("consulta", this.MABD.getSql());
                    parametro.put("idCarreras", this.carreras.get(posCar - 1).getId());
                    JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                    CON.mostrarReporte(jr, parametro, "Reporte de Malla de Alumno");
                }
                catch (JRException ex) {
                    JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
                }
            } else {
                this.reporteGrande();
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar la carrera y un alumno.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reporteGrande() {
        String path = "/vista/reportes/repMallas_1.jasper";
        try {
            HashMap<String, String> parametro = new HashMap<String, String>();
            parametro.put("consulta", this.MABD.getSql());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte de Malla de Alumno");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
        finally {
            this.vtnMallaAlm.setCursor(new Cursor(0));
        }
    }

    private void clickReporteExcel() {
        if (this.mallas.size() > 0 || this.vtnMallaAlm.getCmbCarreras().getSelectedIndex() > 0) {
            int as = this.vtnMallaAlm.getCmbAlumnos().getSelectedIndex();
            int cs = this.vtnMallaAlm.getCmbCarreras().getSelectedIndex();
            if (as > 0) {
                String nombre = this.mallas.get(0).getAlumnoCarrera().getAlumno().getIdentificacion();
                this.reportePorAlumnoCarrera(this.alumnos.get(as - 1).getId(), nombre);
            } else if (cs > 0) {
                String nombre = this.vtnMallaAlm.getCmbCarreras().getSelectedItem().toString();
                this.reportePorCarrera(this.carreras.get(cs - 1).getId(), nombre);
            } else {
                String nombre = this.mallas.get(0).getAlumnoCarrera().getAlumno().getIdentificacion();
                this.reportePorAlumnoCarrera(this.mallas.get(0).getAlumnoCarrera().getId(), nombre);
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnMallaAlm, "Debe buscar un alumno o seleccionar una carrera para poder exportar el reporte.");
        }
    }

    private void reportePorAlumnoCarrera(int idAlmCarrera, String nombre) {
        nombre = nombre + "-" + LocalDate.now().toString().replace(":", "|").replace(".", "");
        List<List<String>> lista = this.MABD.getPorAlumnoCarrera(idAlmCarrera);
        this.generaReporte(lista, nombre);
    }

    private void reportePorCarrera(int idCarrera, String nombre) {
        nombre = nombre + "-" + LocalDate.now().toString().replace(":", "|").replace(".", "");
        List<List<String>> lista = this.MABD.getPorCarrera(idCarrera);
        this.generaReporte(lista, nombre);
    }

    private void generaReporte(List<List<String>> lista, String nombre) {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("Cedula/Identificacion");
        cols.add("Apellidos");
        cols.add("Nombres");
        cols.add("Materia");
        cols.add("Estado");
        cols.add("Ciclo");
        cols.add("Numero de matricula");
        cols.add("Nota 1");
        cols.add("Nota 2");
        cols.add("Nota 3");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, lista, nombre);
    }
}

