/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.JDRetirarAlumnoCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.Retirado;
import modelo.alumno.RetiradoBD;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import vista.alumno.VtnAlumnoRetirados;

public class VtnAlumnoRetiradosCTR
extends DCTR {
    private final VtnAlumnoRetirados vtn;
    private static final String[] TITULO = new String[]{"Carrera", "C\u00e9dula", "Alumno", "Fecha retiro", "Motivo"};
    private DefaultTableModel mdTbl;
    private final RetiradoBD RBD = RetiradoBD.single();
    private List<Retirado> todosRetirados;
    private List<Retirado> retiradosBuscado;
    private final CarreraBD carr = CarreraBD.single();
    private ArrayList<CarreraMD> carreras;
    private final JDRetirarAlumnoCTR RCTR;

    public VtnAlumnoRetiradosCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtn = new VtnAlumnoRetirados();
        this.RCTR = new JDRetirarAlumnoCTR(ctrPrin);
    }

    public void iniciar() {
        this.cargarCmbCarreras();
        this.iniciarVtn();
        this.cargarAlmnsRetirados();
        this.vtnCargada = true;
        this.ctrPrin.agregarVtn(this.vtn);
    }

    private void iniciarVtn() {
        this.mdTbl = TblEstilo.modelTblSinEditar(TITULO);
        this.vtn.getTblRetirados().setModel(this.mdTbl);
        this.vtn.getBtnEditar().addActionListener(e -> this.clickEditar());
        this.vtn.getBtnEliminar().addActionListener(e -> this.clickEliminar());
        this.vtn.getBtnRepRetirados().addActionListener(e -> this.clickReportePorPeriodo());
        this.vtn.getCmbCarrera().addActionListener(e -> this.clickPeriodo());
        this.vtn.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnAlumnoRetiradosCTR.this.buscar(VtnAlumnoRetiradosCTR.this.vtn.getTxtBuscar().getText().trim());
            }
        });
        this.vtn.getBtnBuscar().addActionListener(e -> this.buscar(this.vtn.getTxtBuscar().getText().trim()));
    }

    private void buscar(String aguja) {
        this.retiradosBuscado = new ArrayList<Retirado>();
        this.todosRetirados.forEach(r -> {
            if (r.getAlmnCarrera().getAlumno().getNombreCompleto().toLowerCase().trim().contains(aguja) || r.getMotivo().toLowerCase().contains(aguja) || r.getPeriodo().getNombre().toLowerCase().contains(aguja)) {
                this.retiradosBuscado.add((Retirado)r);
            }
        });
        this.llenarTblAlmnRetirado(this.retiradosBuscado);
    }

    private void clickPeriodo() {
        if (this.vtnCargada) {
            this.cargarAlmnsRetirados();
        }
    }

    private void clickEditar() {
        int posFila = this.vtn.getTblRetirados().getSelectedRow();
        if (posFila >= 0) {
            this.RCTR.editar(this.retiradosBuscado.get(posFila));
        } else {
            this.errorNoSeleccionoFila();
        }
    }

    private void clickEliminar() {
        int posFila = this.vtn.getTblRetirados().getSelectedRow();
        if (posFila >= 0) {
            if (this.RBD.eliminar(this.retiradosBuscado.get(posFila).getId())) {
                JOptionPane.showMessageDialog(this.vtn, "Eliminamos correctamente.");
                this.mdTbl.removeRow(posFila);
            }
        } else {
            this.errorNoSeleccionoFila();
        }
    }

    private void cargarAlmnsRetirados() {
        int posCar = this.vtn.getCmbCarrera().getSelectedIndex();
        this.todosRetirados = posCar > 0 ? this.RBD.getByCarrera(this.carreras.get(posCar - 1).getId()) : this.RBD.getAllTbl();
        this.retiradosBuscado = this.todosRetirados;
        this.llenarTblAlmnRetirado(this.todosRetirados);
    }

    private void llenarTblAlmnRetirado(List<Retirado> retirados) {
        this.mdTbl.setRowCount(0);
        if (retirados != null) {
            retirados.forEach(r -> {
                Object[] valores = new Object[]{r.getAlmnCarrera().getCarrera().getCodigo(), r.getAlmnCarrera().getAlumno().getIdentificacion(), r.getAlmnCarrera().getAlumno().getPrimerApellido() + " " + r.getAlmnCarrera().getAlumno().getSegundoApellido() + " " + r.getAlmnCarrera().getAlumno().getPrimerNombre() + " " + r.getAlmnCarrera().getAlumno().getSegundoNombre(), r.getFechaRetiro().toString(), r.getMotivo()};
                this.mdTbl.addRow(valores);
            });
            this.vtn.getLblResultados().setText(retirados.size() + " Resultados obtenidos.");
        }
    }

    private void cargarCmbCarreras() {
        this.carreras = this.carr.cargarCarrerasCmb();
        if (this.carreras != null) {
            this.vtn.getCmbCarrera().removeAllItems();
            this.vtn.getCmbCarrera().addItem("Todos");
            this.carreras.forEach(c -> this.vtn.getCmbCarrera().addItem(c.getCodigo()));
        }
    }

    private void clickReportePorPeriodo() {
    }
}

