/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import modelo.alumno.AlumnoMatriculaBD;
import modelo.alumno.AlumnoMatriculaMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.Validar;
import vista.alumno.VtnAlumnoMatricula;

public class VtnAlumnoMatriculaCTR
extends DVtnCTR {
    private final VtnAlumnoMatricula vtnMatri;
    private final AlumnoMatriculaBD almMatri = AlumnoMatriculaBD.single();
    private ArrayList<AlumnoMatriculaMD> almnMatricula;
    private ArrayList<PeriodoLectivoMD> periodos;
    private final PeriodoLectivoBD prd = PeriodoLectivoBD.single();
    private int posPrd;

    public VtnAlumnoMatriculaCTR(VtnPrincipalCTR ctrPrin, VtnAlumnoMatricula vtnMatri) {
        super(ctrPrin);
        this.vtnMatri = vtnMatri;
    }

    public void iniciar() {
        String[] t = new String[]{"Periodo", "Cedula", "Nombres", "Apellidos", "Correo", "Celular", "Telefono", "Carrera", "Cursos"};
        this.mdTbl = this.iniciarTbl(this.vtnMatri.getTblMatricula(), t);
        this.llenarCmbPrd();
        this.formatoBuscador(this.vtnMatri.getTxtBuscar(), this.vtnMatri.getBtnBuscar());
        this.iniciarBuscador();
        this.vtnMatri.getCmbPeriodos().addActionListener(e -> this.clickPrd());
        this.ctrPrin.agregarVtn(this.vtnMatri);
    }

    private void iniciarBuscador() {
        this.vtnMatri.getBtnBuscar().addActionListener(e -> this.buscar(this.vtnMatri.getTxtBuscar().getText().trim()));
        this.vtnMatri.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    VtnAlumnoMatriculaCTR.this.buscar(VtnAlumnoMatriculaCTR.this.vtnMatri.getTxtBuscar().getText().trim());
                } else if (VtnAlumnoMatriculaCTR.this.vtnMatri.getTxtBuscar().getText().length() == 0) {
                    VtnAlumnoMatriculaCTR.this.cargarAlumnosMatriculas();
                }
            }
        });
    }

    private void buscar(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.almnMatricula = this.almMatri.buscarPor(aguja);
            this.llenarTbl(this.almnMatricula);
        }
    }

    private void cargarAlumnosMatriculas() {
        new Thread(() -> {
            this.almnMatricula = this.almMatri.getTodos();
            this.llenarTbl(this.almnMatricula);
        }).start();
    }

    private void llenarTbl(ArrayList<AlumnoMatriculaMD> alumnosMatriculas) {
        this.mdTbl.setRowCount(0);
        if (alumnosMatriculas != null) {
            alumnosMatriculas.forEach(am -> {
                Object[] v = new Object[]{am.getPeriodo().getNombre(), am.getAlumno().getIdentificacion(), am.getAlumno().getSoloNombres(), am.getAlumno().getSoloApellidos(), am.getAlumno().getCorreo(), am.getAlumno().getCelular(), am.getAlumno().getTelefono(), am.getPeriodo().getCarrera().getCodigo(), am.getCursos()};
                this.mdTbl.addRow(v);
            });
            this.vtnMatri.getLblNumResultados().setText(alumnosMatriculas.size() + " Resultados obtenidos.");
        } else {
            this.vtnMatri.getLblNumResultados().setText("0 Resultados obtenidos.");
        }
    }

    private void clickPrd() {
        this.posPrd = this.vtnMatri.getCmbPeriodos().getSelectedIndex();
        if (this.posPrd > 0) {
            this.almnMatricula = this.almMatri.getPorPeriodo(this.periodos.get(this.posPrd - 1).getID());
            this.llenarTbl(this.almnMatricula);
        } else {
            this.cargarAlumnosMatriculas();
        }
    }

    private void llenarCmbPrd() {
        this.periodos = this.prd.cargarPrdParaCmbVtn();
        this.vtnMatri.getCmbPeriodos().removeAllItems();
        if (this.periodos != null) {
            this.vtnMatri.getCmbPeriodos().addItem("Seleccione");
            this.periodos.forEach(p -> this.vtnMatri.getCmbPeriodos().addItem(p.getNombre()));
        }
    }
}

