/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.AVtnAlumnoEgresadoCTR;
import controlador.alumno.IAlumnoEgresadoVTNCTR;
import controlador.alumno.JDEgresarAlumnoCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import modelo.alumno.Egresado;

public class VtnAlumnoGraduadoCTR
extends AVtnAlumnoEgresadoCTR
implements IAlumnoEgresadoVTNCTR {
    private static final String[] TITULO = new String[]{"Carrera", "Periodo", "C\u00e9dula", "Alumno", "Fecha Graduacion"};
    private final JDEgresarAlumnoCTR ECTR;

    public VtnAlumnoGraduadoCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.ECTR = new JDEgresarAlumnoCTR(ctrPrin);
    }

    public void iniciar() {
        this.iniciarVtn(TITULO, this);
        this.cargarDatos();
        this.iniciarBuscador();
        this.iniciarAcciones();
        this.vtn.setTitle("Alumnos Graduados");
        this.ctrPrin.agregarVtn(this.vtn);
        this.vtnCargada = true;
    }

    private void cargarDatos() {
        this.todosEgresados = this.EBD.getAllGraduados();
        this.egresados = this.todosEgresados;
        this.llenarTbl(this.egresados);
    }

    private void iniciarBuscador() {
        this.vtn.getBtnBuscar().addActionListener(e -> this.buscar(this.vtn.getTxtBuscar().getText().trim()));
        this.vtn.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnAlumnoGraduadoCTR.this.buscar(VtnAlumnoGraduadoCTR.this.vtn.getTxtBuscar().getText().trim());
            }
        });
    }

    private void buscar(String aguja) {
        this.egresados = new ArrayList();
        this.todosEgresados.forEach(e -> {
            if (e.getAlmnCarrera().getAlumno().getNombreCompleto().toLowerCase().contains(aguja.toLowerCase())) {
                this.egresados.add(e);
            }
        });
        this.llenarTbl(this.egresados);
    }

    @Override
    public void llenarTbl(List<Egresado> egresados) {
        this.mdTbl.setRowCount(0);
        if (egresados != null) {
            egresados.forEach(r -> {
                Object[] valores = new Object[]{r.getAlmnCarrera().getCarrera().getCodigo(), r.getPeriodo().getNombre(), r.getAlmnCarrera().getAlumno().getIdentificacion(), r.getAlmnCarrera().getAlumno().getPrimerApellido() + " " + r.getAlmnCarrera().getAlumno().getSegundoApellido() + " " + r.getAlmnCarrera().getAlumno().getPrimerNombre() + " " + r.getAlmnCarrera().getAlumno().getSegundoNombre(), r.getFechaGraduacion().toString()};
                this.mdTbl.addRow(valores);
            });
            this.vtn.getLblResultados().setText(egresados.size() + " Resultados obtenidos.");
        }
    }
}

