/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.AVtnAlumnoEgresadoCTR;
import controlador.alumno.IAlumnoEgresadoVTNCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.Egresado;
import modelo.periodolectivo.PeriodoLectivoMD;
import utils.ToExcel;

public class VtnAlumnoEgresadosCTR
extends AVtnAlumnoEgresadoCTR
implements IAlumnoEgresadoVTNCTR {
    private static final String[] TITULO = new String[]{"Carrera", "Periodo", "C\u00e9dula", "Alumno", "Fecha egreso", "Graduado"};

    public VtnAlumnoEgresadosCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
    }

    public void iniciar() {
        this.iniciarVtn(TITULO, this);
        this.cargarDatos();
        this.iniciarBuscador();
        this.iniciarAcciones();
        this.iniciarClicks();
        this.vtn.setTitle("Alumnos Egresados");
        this.ctrPrin.agregarVtn(this.vtn);
        this.vtn.getBtnNotasAlumno().setVisible(true);
        this.vtn.getBtnNotasPeriodo().setVisible(true);
        this.vtnCargada = true;
    }

    private void iniciarClicks() {
        this.vtn.getBtnRepPeriodo().addActionListener(e -> this.clickReportePorPeriodo());
        this.vtn.getBtnNotasAlumno().addActionListener(e -> this.clickReporteNotasAlumno());
        this.vtn.getBtnNotasPeriodo().addActionListener(e -> this.clickReporteNotasPeriodo());
    }

    private void cargarDatos() {
        this.todosEgresados = this.EBD.getAllEgresados();
        this.egresados = this.todosEgresados;
        this.llenarTbl(this.egresados);
    }

    private void iniciarBuscador() {
        this.vtn.getBtnBuscar().addActionListener(e -> this.buscar(this.vtn.getTxtBuscar().getText().trim()));
        this.vtn.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                VtnAlumnoEgresadosCTR.this.buscar(VtnAlumnoEgresadosCTR.this.vtn.getTxtBuscar().getText().trim());
            }
        });
    }

    private void buscar(String aguja) {
        this.egresados = new ArrayList();
        this.todosEgresados.forEach(e -> {
            if (e.getAlmnCarrera().getAlumno().getNombreCompleto().toLowerCase().contains(aguja.toLowerCase())) {
                this.egresados.add(e);
            }
        });
        this.llenarTbl(this.egresados);
    }

    @Override
    public void llenarTbl(List<Egresado> egresados) {
        this.mdTbl.setRowCount(0);
        if (egresados != null) {
            egresados.forEach(r -> {
                Object[] valores = new Object[]{r.getAlmnCarrera().getCarrera().getCodigo(), r.getPeriodo().getNombre(), r.getAlmnCarrera().getAlumno().getIdentificacion(), r.getAlmnCarrera().getAlumno().getPrimerApellido() + " " + r.getAlmnCarrera().getAlumno().getSegundoApellido() + " " + r.getAlmnCarrera().getAlumno().getPrimerNombre() + " " + r.getAlmnCarrera().getAlumno().getSegundoNombre(), r.getFechaEgreso().toString(), r.isGraduado() ? "Si" : "No"};
                this.mdTbl.addRow(valores);
            });
            this.vtn.getLblResultados().setText(egresados.size() + " Resultados obtenidos.");
        }
    }

    private void clickReportePorPeriodo() {
        int posPeriodo = this.vtn.getCmbPeriodo().getSelectedIndex();
        if (posPeriodo > 0) {
            String nombre = this.vtn.getCmbPeriodo().getSelectedItem().toString().replace(" ", "").replace("/", "-") + "  Egresados";
            List<List<String>> alumnos = this.EBD.getReportesEgresadosExcel(((PeriodoLectivoMD)this.periodos.get(posPeriodo - 1)).getID() + "");
            ArrayList<String> cols = new ArrayList<String>();
            cols.add("C\u00d3DIGO DEL IST");
            cols.add("NOMBRE DEL INSTITUTO");
            cols.add("PROVINCIA");
            cols.add("C\u00d3DIGO DE LA CARRERA");
            cols.add("CARRERA");
            cols.add("MODALIDAD DE ESTUDIOS");
            cols.add("TIPO DE IDENTIFICACI\u00d3N");
            cols.add("NRO. DE IDENTIFICACI\u00d3N");
            cols.add("APELLIDOS Y NOMBRES");
            cols.add("NACIONALIDAD");
            cols.add("TRABAJO DE TITULACI\u00d3N FINALIZADO S/N");
            ToExcel excel = new ToExcel();
            excel.exportarExcel(cols, alumnos, nombre);
        } else {
            JOptionPane.showMessageDialog(this.vtn, "No selecciono un periodo lectivo para el reporte.");
        }
    }

    private void clickReporteNotasPeriodo() {
        int posPeriodo = this.vtn.getCmbPeriodo().getSelectedIndex();
        if (posPeriodo > 0) {
            int s = JOptionPane.showOptionDialog(this.vtn, "Reporte de notas por periodo\n\u00bfElegir el tipo de carrera?", "Notas Finales", 1, 1, null, new Object[]{"Tradicional", "Dual", "Cancelar"}, "Tradicional");
            switch (s) {
                case 0: {
                    this.reporteNotasPeriodo(posPeriodo);
                    break;
                }
                case 1: {
                    this.reporteNotasPeriodoDual(posPeriodo);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.vtn, "No selecciono un periodo lectivo para el reporte.");
        }
    }

    private void clickReporteNotasAlumno() {
        int posEgresado = this.vtn.getTblEgresados().getSelectedRow();
        if (posEgresado >= 0) {
            int s = JOptionPane.showOptionDialog(this.vtn, "Reporte de notas por alumno\n\u00bfElegir el tipo de carrera?", "Notas Finales", 1, 1, null, new Object[]{"Tradicional", "Dual", "Cancelar"}, "Tradicional");
            switch (s) {
                case 0: {
                    this.reporteNotasAlumno(posEgresado);
                    break;
                }
                case 1: {
                    this.reporteNotasAlumnoDual(posEgresado);
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.vtn, "No selecciono un alumno.");
        }
    }

    private void reporteNotasPeriodoDual(int posPeriodo) {
        String nombre = this.vtn.getCmbPeriodo().getSelectedItem().toString().replace(" ", "").replace("/", "-") + " Notas Egresados" + ((PeriodoLectivoMD)this.periodos.get(posPeriodo - 1)).getID();
        List<List<String>> alumnos = this.EBD.getNotasPromedioPorPeriodoDual(((PeriodoLectivoMD)this.periodos.get(posPeriodo - 1)).getID());
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("IDENTIFICACI\u00d3N");
        cols.add("PRIMER NOMBRE");
        cols.add("SEGUNDO NOMBRE");
        cols.add("PRIMER APELLIDO");
        cols.add("SEGUNDO APELLIDO");
        cols.add("FASE TEORICA");
        cols.add("PTI");
        cols.add("FASE PRACTICA");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, nombre);
    }

    private void reporteNotasPeriodo(int posPeriodo) {
        String nombre = this.vtn.getCmbPeriodo().getSelectedItem().toString().replace(" ", "").replace("/", "-") + " Notas Egresados" + ((PeriodoLectivoMD)this.periodos.get(posPeriodo - 1)).getID();
        List<List<String>> alumnos = this.EBD.getNotasPromedioPorPeriodo(((PeriodoLectivoMD)this.periodos.get(posPeriodo - 1)).getID());
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("IDENTIFICACI\u00d3N");
        cols.add("PRIMER NOMBRE");
        cols.add("SEGUNDO NOMBRE");
        cols.add("PRIMER APELLIDO");
        cols.add("SEGUNDO APELLIDO");
        cols.add("PROMEDIO FINAL");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, nombre);
    }

    private void reporteNotasAlumnoDual(int posEgresado) {
        String nombre = this.vtn.getCmbPeriodo().getSelectedItem().toString().replace(" ", "").replace("/", "-") + " Notas Alumno Egresados" + ((Egresado)this.egresados.get(posEgresado)).getId();
        List<List<String>> alumnos = this.EBD.getNotasPromedioPorEstudianteDual(((Egresado)this.egresados.get(posEgresado)).getId());
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("IDENTIFICACI\u00d3N");
        cols.add("PRIMER NOMBRE");
        cols.add("SEGUNDO NOMBRE");
        cols.add("PRIMER APELLIDO");
        cols.add("SEGUNDO APELLIDO");
        cols.add("CICLO");
        cols.add("# MATERIAS");
        cols.add("FASE TEORICA");
        cols.add("FASE PRACTICA");
        cols.add("PTI");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, nombre);
    }

    private void reporteNotasAlumno(int posEgresado) {
        String nombre = this.vtn.getCmbPeriodo().getSelectedItem().toString().replace(" ", "").replace("/", "-") + " Notas Alumno Egresados" + ((Egresado)this.egresados.get(posEgresado)).getId();
        List<List<String>> alumnos = this.EBD.getNotasPromedioPorEstudiante(((Egresado)this.egresados.get(posEgresado)).getId());
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("IDENTIFICACI\u00d3N");
        cols.add("PRIMER NOMBRE");
        cols.add("SEGUNDO NOMBRE");
        cols.add("PRIMER APELLIDO");
        cols.add("SEGUNDO APELLIDO");
        cols.add("CICLO");
        cols.add("# MATERIAS");
        cols.add("PROMEDIO FINAL");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, nombre);
    }
}

