/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.Libraries.Effects;
import controlador.alumno.JDMateriasCursoCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCursoBD;
import modelo.alumno.AlumnoCursoMD;
import modelo.curso.CursoBD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.alumno.VtnAlumnoCurso;

public class VtnAlumnoCursoCTR
extends DVtnCTR {
    private final VtnAlumnoCurso vtnAlmnCurso;
    private int posPrd;
    private int posCur;
    private int posCiclo;
    private ArrayList<AlumnoCursoMD> almns;
    private final AlumnoCursoBD ALCBR = AlumnoCursoBD.single();
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private final CursoBD CBD = CursoBD.single();
    private ArrayList<String> cursos;
    private ArrayList<Integer> ciclos;
    private final MateriaBD MTBD = MateriaBD.single();

    public VtnAlumnoCursoCTR(VtnAlumnoCurso vtnAlmnCurso, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnAlmnCurso = vtnAlmnCurso;
    }

    public void iniciar() {
        String[] titulo = new String[]{"C\u00e9dula", "Alumno", "Curso"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        TblEstilo.formatoTbl(this.vtnAlmnCurso.getTblAlumnoCurso());
        this.vtnAlmnCurso.getTblAlumnoCurso().setModel(this.mdTbl);
        this.cargarAlumnosCurso();
        this.cargarCmbPrds();
        this.vtnAlmnCurso.getTxtbuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnAlumnoCursoCTR.this.vtnAlmnCurso.getTxtbuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnAlumnoCursoCTR.this.buscar(b);
                } else if (b.length() == 0) {
                    VtnAlumnoCursoCTR.this.cargarAlumnosCurso();
                }
            }
        });
        this.vtnAlmnCurso.getBtnbuscar().addActionListener(e -> this.buscar(this.vtnAlmnCurso.getTxtbuscar().getText().trim()));
        this.vtnAlmnCurso.getTxtbuscar().addKeyListener(new TxtVBuscador(this.vtnAlmnCurso.getTxtbuscar(), this.vtnAlmnCurso.getBtnbuscar()));
        this.vtnAlmnCurso.getCmbPrdLectivos().addActionListener(e -> this.clickCmbPrd());
        this.vtnAlmnCurso.getCmbCursos().addActionListener(e -> this.clickCmbCurso());
        this.vtnAlmnCurso.getCmbCiclo().addActionListener(e -> this.clickCmbCiclo());
        this.vtnAlmnCurso.getBtnMaterias().addActionListener(e -> this.materiasCurso());
        this.vtnAlmnCurso.getBtnRepAlum().addActionListener(e -> this.validaComboReporte());
        this.vtnAlmnCurso.getBtnListaCiclo().addActionListener(e -> this.validaComboReporteCiclo());
        this.vtnAlmnCurso.getBtnListaPeriodo().addActionListener(e -> this.ListaAlumnosPeriodo());
        this.vtnAlmnCurso.getBtnRepUBE().addActionListener(e -> this.btnUBE(e));
        this.ctrPrin.agregarVtn(this.vtnAlmnCurso);
        this.InitPermisos();
    }

    private void buscar(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.almns = this.ALCBR.buscarAlumnosCursosTbl(b);
            this.llenatTbl(this.almns);
        }
    }

    public void abrirFrmCurso() {
        this.ctrPrin.abrirFrmMatricula();
        this.vtnAlmnCurso.dispose();
        this.ctrPrin.cerradoJIF();
    }

    private void cargarAlumnosCurso() {
        this.almns = this.ALCBR.cargarAlumnosCursosTbl();
        this.llenatTbl(this.almns);
    }

    private void cargarTblPorPrd() {
        if (this.posPrd > 0) {
            this.almns = this.ALCBR.cargarAlumnosCursosPorPrdTbl(this.periodos.get(this.posPrd - 1).getID());
            this.llenatTbl(this.almns);
        }
    }

    private void cargarTblPorCiclo() {
        if (this.posCiclo > 0) {
            this.almns = this.ALCBR.cargarAlumnosCursosPorCicloTbl(this.ciclos.get(this.posCiclo - 1), this.periodos.get(this.posPrd - 1).getID());
            this.llenatTbl(this.almns);
        }
    }

    private void cargarTblPorCurso() {
        if (this.posCur > 0) {
            this.almns = this.ALCBR.cargarAlumnosCursosPorCursoTbl(this.cursos.get(this.posCur - 1), this.periodos.get(this.posPrd - 1).getID());
            this.llenatTbl(this.almns);
        }
    }

    private void llenatTbl(ArrayList<AlumnoCursoMD> almns) {
        this.mdTbl.setRowCount(0);
        if (almns != null) {
            almns.forEach(a -> {
                Object[] valores = new Object[]{a.getAlumno().getIdentificacion(), a.getAlumno().getPrimerNombre() + " " + a.getAlumno().getPrimerApellido(), a.getCurso().getNombre()};
                this.mdTbl.addRow(valores);
            });
            this.vtnAlmnCurso.getLblResultados().setText(almns.size() + " Resultados obtenidos.");
        }
    }

    private void cargarCmbPrds() {
        this.periodos = this.PLBD.cargarPrdParaCmbVtn();
        this.vtnAlmnCurso.getCmbPrdLectivos().removeAllItems();
        if (!this.periodos.isEmpty()) {
            this.vtnAlmnCurso.getCmbPrdLectivos().addItem("Todos");
            this.periodos.forEach(p -> this.vtnAlmnCurso.getCmbPrdLectivos().addItem(p.getNombre()));
        }
    }

    private void cargarCmbCiclo() {
        this.ciclos = this.MTBD.cargarCiclosCarrera(this.periodos.get(this.posPrd - 1).getCarrera().getId());
        if (this.ciclos != null) {
            this.vtnAlmnCurso.getCmbCiclo().removeAllItems();
            this.vtnAlmnCurso.getCmbCiclo().addItem("Todos");
            this.ciclos.forEach(c -> this.vtnAlmnCurso.getCmbCiclo().addItem(c + ""));
        }
    }

    private void clickCmbCiclo() {
        this.posCiclo = this.vtnAlmnCurso.getCmbCiclo().getSelectedIndex();
        this.cargarTblPorCiclo();
    }

    private void clickCmbPrd() {
        this.posPrd = this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedIndex();
        this.cargarCmbCiclo();
        this.cargarCursoPorPrd();
        this.cargarTblPorPrd();
    }

    private void clickCmbCurso() {
        this.posCur = this.vtnAlmnCurso.getCmbCursos().getSelectedIndex();
        this.cargarTblPorCurso();
    }

    private void cargarCursoPorPrd() {
        if (this.posPrd > 0) {
            this.cursos = this.CBD.cargarNombreCursosPorPeriodo(this.periodos.get(this.posPrd - 1).getID());
            this.vtnAlmnCurso.getCmbCursos().removeAllItems();
            if (this.cursos != null) {
                this.vtnAlmnCurso.getCmbCursos().addItem("Todos");
                this.cursos.forEach(c -> this.vtnAlmnCurso.getCmbCursos().addItem(c));
            }
        } else {
            this.vtnAlmnCurso.getCmbCursos().removeAllItems();
        }
    }

    private void materiasCurso() {
        this.posFila = this.vtnAlmnCurso.getTblAlumnoCurso().getSelectedRow();
        if (this.posFila >= 0) {
            JDMateriasCursoCTR ctrM = new JDMateriasCursoCTR(this.almns.get(this.posFila), this.ctrPrin);
            ctrM.iniciar();
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar un alumno primero.");
        }
    }

    public void reporteAlumno() {
        String path = "/vista/reportes/repAlumTodoCurso.jasper";
        try {
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("periodo", this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedItem());
            parametro.put("curso", this.vtnAlmnCurso.getCmbCursos().getSelectedItem());
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte de Malla de Alumno");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    public void validaComboReporte() {
        int pos1 = this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedIndex();
        int pos2 = this.vtnAlmnCurso.getCmbCursos().getSelectedIndex();
        if (pos1 <= 0 || pos2 <= 0) {
            JOptionPane.showMessageDialog(null, "Seleccione un periodo y curso");
        } else {
            this.reporteAlumno();
        }
    }

    public void reporte() {
        String path = "/vista/reportes/repListaAlumCiclo.jasper";
        try {
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("periodo", this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedItem());
            parametro.put("ciclo", Integer.parseInt(this.vtnAlmnCurso.getCmbCiclo().getSelectedItem().toString()));
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
            CON.mostrarReporte(jr, parametro, "Reporte Lista de Alumnos");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    public void ListaAlumnosPeriodo() {
        String path = "/vista/reportes/repListaAlumPeriodo.jasper";
        int posCMB = this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedIndex();
        if (posCMB <= 0) {
            JOptionPane.showMessageDialog(null, "Seleccione un periodo");
        } else {
            try {
                HashMap<String, Object> parametro = new HashMap<String, Object>();
                parametro.put("periodo", this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedItem());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte Lista de Alumnos");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        }
    }

    public void validaComboReporteCiclo() {
        int pos1 = this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedIndex();
        int pos2 = this.vtnAlmnCurso.getCmbCiclo().getSelectedIndex();
        if (pos1 <= 0 || pos2 <= 0) {
            JOptionPane.showMessageDialog(null, "Seleccione un periodo y un ciclo");
        } else {
            this.reporte();
        }
    }

    private void InitPermisos() {
        this.vtnAlmnCurso.getBtnMaterias().getAccessibleContext().setAccessibleName("Lista-Alumnos-Materias");
        this.vtnAlmnCurso.getBtnRepUBE().getAccessibleContext().setAccessibleName("Lista-Alumnos-Reporte-UBE");
        this.vtnAlmnCurso.getBtnListaCiclo().getAccessibleContext().setAccessibleName("Lista-Alumnos-Reporte-Lista Ciclo");
        this.vtnAlmnCurso.getBtnRepAlum().getAccessibleContext().setAccessibleName("Lista-Alumnos-Reporte-Lista Curso");
        CONS.activarBtns(this.vtnAlmnCurso.getBtnMaterias(), this.vtnAlmnCurso.getBtnRepUBE(), this.vtnAlmnCurso.getBtnListaCiclo(), this.vtnAlmnCurso.getBtnRepAlum());
    }

    private void btnUBE(ActionEvent e) {
        new Thread(() -> {
            int r = JOptionPane.showOptionDialog(this.vtnAlmnCurso, "Reporte individual\n\u00bfElegir el tipo de Reporte?", "REPORTE UBE", 1, 1, null, new Object[]{"menos de 70 hasta interciclo", "menos de 70 final de ciclo", "Nota final"}, "Cancelar");
            Effects.setLoadCursor(this.vtnAlmnCurso);
            switch (r) {
                case 0: {
                    this.llamaReporteUBEmenos70hastainterciclo();
                    break;
                }
                case 1: {
                    this.llamaReporteUBEmenos70despuesinterciclo();
                    break;
                }
                case 2: {
                    this.llamaReporteUBEcompleto();
                    break;
                }
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException ex) {
                System.out.println(ex.getMessage());
            }
            Effects.setDefaultCursor(this.vtnAlmnCurso);
        }).start();
    }

    public void llamaReporteUBEmenos70hastainterciclo() {
        String path = "/vista/reportes/repUBNotasAporte1.jasper";
        this.posFila = this.vtnAlmnCurso.getTblAlumnoCurso().getSelectedRow();
        if (this.posFila >= 0) {
            try {
                HashMap<String, String> parametro = new HashMap<String, String>();
                parametro.put("cedulaalumno", this.almns.get(this.posFila).getAlumno().getIdentificacion());
                parametro.put("periodolectivo", this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedItem().toString());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte UBE");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnAlmnCurso, "Seleecione una fila primero.");
        }
    }

    public void llamaReporteUBEmenos70despuesinterciclo() {
        String path = "/vista/reportes/repUBNotasAporte2.jasper";
        this.posFila = this.vtnAlmnCurso.getTblAlumnoCurso().getSelectedRow();
        if (this.posFila >= 0) {
            try {
                HashMap<String, String> parametro = new HashMap<String, String>();
                parametro.put("cedulaalumno", this.almns.get(this.posFila).getAlumno().getIdentificacion());
                parametro.put("periodolectivo", this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedItem().toString());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte UBE");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnAlmnCurso, "Seleecione una fila primero.");
        }
    }

    public void llamaReporteUBEcompleto() {
        String path = "/vista/reportes/repUBcompleto.jasper";
        this.posFila = this.vtnAlmnCurso.getTblAlumnoCurso().getSelectedRow();
        if (this.posFila >= 0) {
            try {
                HashMap<String, String> parametro = new HashMap<String, String>();
                parametro.put("cedulaalumno", this.almns.get(this.posFila).getAlumno().getIdentificacion());
                parametro.put("periodolectivo", this.vtnAlmnCurso.getCmbPrdLectivos().getSelectedItem().toString());
                JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource(path));
                CON.mostrarReporte(jr, parametro, "Reporte UBE");
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
            }
        } else {
            JOptionPane.showMessageDialog(this.vtnAlmnCurso, "Seleecione una fila primero.");
        }
    }
}

