/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.JDEgresarAlumnoCTR;
import controlador.alumno.JDRetirarAlumnoCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCarreraBD;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.Retirado;
import modelo.alumno.RetiradoBD;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import utils.CONS;
import vista.alumno.VtnAlumnoCarrera;

public class VtnAlumnoCarreraCTR
extends DCTR {
    private final VtnAlumnoCarrera vtnAlmCar;
    private final AlumnoCarreraBD ACRBD = AlumnoCarreraBD.single();
    private ArrayList<AlumnoCarreraMD> almnsCarr;
    private final JDRetirarAlumnoCTR RCTR;
    private final JDEgresarAlumnoCTR ECTR;
    private final RetiradoBD RBD = RetiradoBD.single();
    private List<Retirado> retirados;
    private DefaultTableModel mdTbl;
    private final CarreraBD CRBD = CarreraBD.single();
    private ArrayList<CarreraMD> carreras;

    public VtnAlumnoCarreraCTR(VtnAlumnoCarrera vtnAlmCar, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtnAlmCar = vtnAlmCar;
        this.RCTR = new JDRetirarAlumnoCTR(ctrPrin);
        this.ECTR = new JDEgresarAlumnoCTR(ctrPrin);
    }

    public void iniciar() {
        this.cargarCmbCarreras();
        String[] titulo = new String[]{"Carrera", "Alumno", "C\u00e9dula", "Fecha inscripci\u00f3n"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        TblEstilo.formatoTbl(this.vtnAlmCar.getTblAlmnCarrera());
        TblEstilo.columnaMedida(this.vtnAlmCar.getTblAlmnCarrera(), 0, 70);
        TblEstilo.columnaMedida(this.vtnAlmCar.getTblAlmnCarrera(), 2, 120);
        this.vtnAlmCar.getTblAlmnCarrera().setModel(this.mdTbl);
        this.cargarAlmnsCarrera();
        this.vtnAlmCar.getCmbCarrera().addActionListener(e -> this.clickCmbCarreras());
        this.vtnAlmCar.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String b = VtnAlumnoCarreraCTR.this.vtnAlmCar.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    VtnAlumnoCarreraCTR.this.buscar(b);
                } else if (b.length() == 0) {
                    VtnAlumnoCarreraCTR.this.cargarAlmnsCarrera();
                }
            }
        });
        this.vtnAlmCar.getBtnBuscar().addActionListener(e -> this.buscar(this.vtnAlmCar.getTxtBuscar().getText().trim()));
        this.vtnAlmCar.getBtnIngresar().addActionListener(e -> this.abrirFrmAlumnoCarrera());
        this.vtnAlmCar.getCbxEliminados().addActionListener(e -> this.verEliminados());
        this.vtnAlmCar.getTxtBuscar().addKeyListener(new TxtVBuscador(this.vtnAlmCar.getTxtBuscar(), this.vtnAlmCar.getBtnBuscar()));
        this.ctrPrin.agregarVtn(this.vtnAlmCar);
        this.vtnAlmCar.getBtnRetirar().addActionListener(e -> this.abrirFRMRetirado());
        this.vtnAlmCar.getBtnEgresar().addActionListener(e -> this.abrirFrmEgresado());
        this.InitPermisos();
    }

    private void abrirFRMRetirado() {
        int posFila = this.vtnAlmCar.getTblAlmnCarrera().getSelectedRow();
        if (posFila >= 0) {
            this.RCTR.ingresar(this.almnsCarr.get(posFila));
        } else {
            this.errorNoSeleccionoFila();
        }
    }

    private void abrirFrmEgresado() {
        int posFila = this.vtnAlmCar.getTblAlmnCarrera().getSelectedRow();
        if (posFila >= 0) {
            this.ECTR.ingresar(this.almnsCarr.get(posFila).getId());
        } else {
            this.errorNoSeleccionoFila();
        }
    }

    private void abrirFrmAlumnoCarrera() {
        this.ctrPrin.abrirFrmInscripcion();
        this.vtnAlmCar.dispose();
        this.ctrPrin.cerradoJIF();
    }

    private void buscar(String b) {
        if (Validar.esLetrasYNumeros(b)) {
            this.almnsCarr = this.ACRBD.buscar(b);
            this.llenarTblAlmnCarreras(this.almnsCarr);
        }
    }

    private void cargarAlmnsCarrera() {
        int posCar = this.vtnAlmCar.getCmbCarrera().getSelectedIndex();
        this.almnsCarr = posCar > 0 ? this.ACRBD.cargarAlumnoCarreraPorCarrera(this.carreras.get(posCar - 1).getId()) : this.ACRBD.cargarAlumnoCarrera();
        this.llenarTblAlmnCarreras(this.almnsCarr);
    }

    private void llenarTblAlmnCarreras(ArrayList<AlumnoCarreraMD> almns) {
        this.mdTbl.setRowCount(0);
        if (almns != null) {
            almns.forEach(a -> {
                Object[] valores = new Object[]{a.getCarrera().getCodigo(), a.getAlumno().getPrimerApellido() + " " + a.getAlumno().getSegundoApellido() + " " + a.getAlumno().getPrimerNombre() + " " + a.getAlumno().getSegundoNombre(), a.getAlumno().getIdentificacion(), a.getFechaRegistro().getDayOfMonth() + "/" + a.getFechaRegistro().getMonth() + "/" + a.getFechaRegistro().getYear()};
                this.mdTbl.addRow(valores);
            });
            this.vtnAlmCar.getLblResultados().setText(almns.size() + " Resultados obtenidos.");
        }
    }

    private void cargarCmbCarreras() {
        this.carreras = this.CRBD.cargarCarrerasCmb();
        if (this.carreras != null) {
            this.vtnAlmCar.getCmbCarrera().removeAllItems();
            this.vtnAlmCar.getCmbCarrera().addItem("Todos");
            this.carreras.forEach(c -> this.vtnAlmCar.getCmbCarrera().addItem(c.getCodigo()));
        }
    }

    private void clickCmbCarreras() {
        int posCar = this.vtnAlmCar.getCmbCarrera().getSelectedIndex();
        if (posCar > 0) {
            this.almnsCarr = this.ACRBD.cargarAlumnoCarreraPorCarrera(this.carreras.get(posCar - 1).getId());
            this.llenarTblAlmnCarreras(this.almnsCarr);
        } else {
            this.cargarAlmnsCarrera();
        }
    }

    private void verEliminados() {
        if (this.vtnAlmCar.getCbxEliminados().isSelected()) {
            this.almnsCarr = this.ACRBD.cargarAlumnoCarreraEliminados();
            this.llenarTblAlmnCarreras(this.almnsCarr);
            this.vtnAlmCar.getCmbCarrera().setEnabled(false);
        } else {
            this.almnsCarr = this.ACRBD.cargarAlumnoCarrera();
            this.llenarTblAlmnCarreras(this.almnsCarr);
            this.vtnAlmCar.getCmbCarrera().setEnabled(true);
        }
    }

    private void InitPermisos() {
        this.vtnAlmCar.getBtnIngresar().getAccessibleContext().setAccessibleName("Inscripcion-Ingresar");
        this.vtnAlmCar.getCbxEliminados().getAccessibleContext().setAccessibleName("Inscripcion-Ver Elimandos");
        CONS.activarBtns(this.vtnAlmCar.getBtnIngresar(), this.vtnAlmCar.getCbxEliminados());
    }
}

