/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import com.toedter.calendar.JDateChooser;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.Retirado;
import modelo.alumno.RetiradoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.periodolectivo.RetiradoPeriodoLectivoBD;
import vista.alumno.JDRetirarAlumno;

public class JDRetirarAlumnoCTR
extends DCTR {
    private AlumnoCarreraMD ac;
    private final JDRetirarAlumno FRM;
    private Retirado r;
    private final RetiradoBD RBD = RetiradoBD.single();
    private boolean editar = false;
    private final RetiradoPeriodoLectivoBD RPBD = RetiradoPeriodoLectivoBD.single();
    private List<PeriodoLectivoMD> ps;

    public JDRetirarAlumnoCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.FRM = new JDRetirarAlumno((Frame)ctrPrin.getVtnPrin(), false);
    }

    public void ingresar(AlumnoCarreraMD ac) {
        this.ac = ac;
        this.r = new Retirado();
        this.r.setAlmnCarrera(ac);
        this.iniciarVtn();
        this.FRM.getJdcFechaRetiro().setDate(this.getDateFromLocalDate(LocalDate.now()));
    }

    public void editar(Retirado r) {
        this.editar = true;
        this.ac = null;
        this.r = r;
        this.iniciarVtn();
        this.FRM.getJdcFechaRetiro().setDate(this.getDateFromLocalDate(r.getFechaRetiro()));
        this.FRM.getCmbPeriodo().setSelectedIndex(this.getPosPeriodoById(r.getPeriodo().getID()));
        this.FRM.getTxtMotivo().setText(r.getMotivo());
        this.editar = true;
    }

    public void informacion(Retirado r) {
        this.ac = null;
        this.r = r;
        this.iniciarVtn();
        this.FRM.getJdcFechaRetiro().setDate(this.getDateFromLocalDate(r.getFechaRetiro()));
        this.FRM.getTxtMotivo().setText(r.getMotivo());
        this.FRM.getCmbPeriodo().setSelectedIndex(this.getPosPeriodoById(r.getPeriodo().getID()));
        this.FRM.getBtnGuardar().setVisible(false);
    }

    private int getPosPeriodoById(int idPeriodo) {
        int pos = 0;
        for (int i = 0; i < this.ps.size(); ++i) {
            if (idPeriodo != this.ps.get(i).getID()) continue;
            pos = i + 1;
            break;
        }
        return pos;
    }

    private void iniciarVtn() {
        this.cargarCmbPeriodo();
        this.FRM.getJdcFechaRetiro().setDateFormatString("dd/MM/yyyy");
        this.FRM.getBtnGuardar().addActionListener(e -> this.guardar());
        this.abrirJD(this.FRM);
    }

    private Date getDateFromLocalDate(LocalDate fecha) {
        return Date.from(fecha.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    private void guardar() {
        int posPrd = this.FRM.getCmbPeriodo().getSelectedIndex();
        LocalDate fecha = this.getFechaJDC(this.FRM.getJdcFechaRetiro());
        if (posPrd > 0 && fecha != null) {
            this.r.setPeriodo(this.ps.get(posPrd - 1));
            this.r.setMotivo(this.FRM.getTxtMotivo().getText());
            this.r.setFechaRetiro(fecha);
            if (this.editar) {
                this.editar = false;
                if (this.RBD.editar(this.r) > 0) {
                    JOptionPane.showMessageDialog(this.FRM, "Editamos correctamente.");
                }
            } else if (this.RBD.guardar(this.r) > 0) {
                JOptionPane.showMessageDialog(this.FRM, "Guardamos correctamente.");
            }
            this.FRM.setVisible(false);
        }
    }

    private void cargarCmbPeriodo() {
        this.ps = this.ac != null ? this.RPBD.getForAlmnCarrera(this.ac.getId()) : this.RPBD.getForAlmnCarrera(this.r.getAlmnCarrera().getId());
        this.FRM.getCmbPeriodo().removeAllItems();
        this.FRM.getCmbPeriodo().addItem("Seleccione");
        this.ps.forEach(p -> this.FRM.getCmbPeriodo().addItem(p.getNombre()));
    }

    private LocalDate getFechaJDC(JDateChooser jdc) {
        LocalDate fecha = null;
        if (jdc.getDate() != null) {
            fecha = jdc.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        return fecha;
    }
}

