/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoMatriculaBD;
import modelo.alumno.EgresadoBD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoMD;
import utils.ToExcel;
import vista.alumno.JDReporteExcel;

public class JDReporteTipoMatriculaCTR
extends DCTR {
    private final List<PeriodoLectivoMD> periodos;
    private final DefaultTableModel mdTbl = TblEstilo.modelTblSinEditar(new String[]{"Periodo"});
    private final JDReporteExcel vtn;
    private final String[] TIPO_MATRICULAS = new String[]{"TODAS", "ORDINARIA", "EXTRAORDINARIA", "ESPECIAL"};
    private final AlumnoMatriculaBD AMBD = AlumnoMatriculaBD.single();
    private final EgresadoBD EBD = EgresadoBD.single();

    public JDReporteTipoMatriculaCTR(VtnPrincipalCTR ctrPrin, List<PeriodoLectivoMD> periodos) {
        super(ctrPrin);
        this.periodos = periodos;
        this.vtn = new JDReporteExcel((Frame)ctrPrin.getVtnPrin(), false);
    }

    public void iniciar() {
        this.iniciarTbl();
        this.vtn.getBtnReporte().addActionListener(e -> this.seleccioneTipoMatricula());
        this.vtn.getBtnEgresados().addActionListener(e -> this.clickReporteEgresados());
        this.vtn.getBtnNumAlumnos().addActionListener(e -> this.clickReporteNumeroAlumnos());
        this.vtn.getBtnNumAlmnJornada().addActionListener(e -> this.clickReporteNumeroAlumnosJornada());
        this.vtn.setLocationRelativeTo(this.ctrPrin.getVtnPrin());
        this.vtn.setVisible(true);
        this.ctrPrin.eventoJDCerrar(this.vtn);
    }

    private void iniciarTbl() {
        this.vtn.getTblPeriodos().setModel(this.mdTbl);
        this.periodos.forEach(p -> this.mdTbl.addRow(new Object[]{p.getNombre()}));
    }

    private void seleccioneTipoMatricula() {
        Object np = JOptionPane.showInputDialog(null, "Seleccione el tipo de matricula", "Tipos de matricula", 3, null, this.TIPO_MATRICULAS, "TODAS");
        if (np != null) {
            if (np.equals("Seleccione")) {
                this.reporteJSON("");
            } else {
                this.reporteJSON(np.toString());
            }
        }
    }

    private void reporteJSON(String tipo) {
        String ids = this.getIDSelect();
        String nombre = tipo + LocalDate.now().toString().replace(":", "|").replace(".", "");
        List<List<String>> alumnos = this.AMBD.getPorTipoMatricula(ids, tipo);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("Cedula/Identificacion");
        cols.add("Primer Nombre");
        cols.add("Seguno Nombre");
        cols.add("Primer Apellido");
        cols.add("Segundo Apellido");
        cols.add("Fecha Matricula");
        cols.add("Tipo Matricula");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, nombre);
    }

    private void clickReporteEgresados() {
        String ids = this.getIDSelect();
        List<List<String>> alumnos = this.EBD.getReportesEgresadosExcel(ids);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("C\u00d3DIGO DEL IST");
        cols.add("NOMBRE DEL INSTITUTO");
        cols.add("PROVINCIA");
        cols.add("C\u00d3DIGO DE LA CARRERA");
        cols.add("CARRERA");
        cols.add("MODALIDAD DE ESTUDIOS");
        cols.add("TIPO DE IDENTIFICACI\u00d3N");
        cols.add("NRO. DE IDENTIFICACI\u00d3N");
        cols.add("APELLIDOS Y NOMBRES");
        cols.add("NACIONALIDAD");
        cols.add("TRABAJO DE TITULACI\u00d3N FINALIZADO S/N");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, "Alumnos Egresados " + ids);
    }

    private void clickReporteNumeroAlumnos() {
        String ids = this.getIDSelect();
        List<List<String>> alumnos = this.AMBD.getNumeroAlumnos(ids);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("CARRERA");
        cols.add("PERIODO");
        cols.add("HOMBRES");
        cols.add("MUJERES");
        cols.add("TOTAL");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, "N\u00famero Alumnos " + ids);
    }

    private void clickReporteNumeroAlumnosJornada() {
        String ids = this.getIDSelect();
        List<List<String>> alumnos = this.AMBD.getNumeroAlumnosPorJornada(ids);
        ArrayList<String> cols = new ArrayList<String>();
        cols.add("CARRERA");
        cols.add("PERIODO");
        cols.add("CURSOS MATUTINA");
        cols.add("HOMBRES MATUTINA");
        cols.add("MUJERES MATUTINA");
        cols.add("ALUMNOS MATUTINA");
        cols.add("CURSOS VESPERTINA");
        cols.add("HOMBRES VESPERTINA");
        cols.add("MUJERES VESPERTINA");
        cols.add("ALUMNOS VESPERTINA");
        cols.add("CURSOS NOCTURNA");
        cols.add("HOMBRES NOCTURNA");
        cols.add("MUJERES NOCTURNA");
        cols.add("ALUMNOS NOCTURNA");
        ToExcel excel = new ToExcel();
        excel.exportarExcel(cols, alumnos, "N\u00famero Alumnos Jornada " + ids);
    }

    private String getIDSelect() {
        int[] ss = this.vtn.getTblPeriodos().getSelectedRows();
        String ids = "";
        for (int s : ss) {
            ids = ids + this.periodos.get(s).getID() + ",";
        }
        ids = ids.substring(0, ids.length() - 1);
        return ids;
    }
}

