/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.MallaAlumnoBD;
import modelo.alumno.MallaAlumnoMD;
import modelo.estilo.TblEstilo;
import vista.alumno.JDMateriasInformacion;

public class JDMateriasInformacionCTR
extends DCTR {
    private final AlumnoCarreraMD alumno;
    private final MallaAlumnoBD mallaAlm;
    private final JDMateriasInformacion jd;
    private final String estado;
    private ArrayList<MallaAlumnoMD> materiasAlmn;
    private DefaultTableModel mdTbl;

    public JDMateriasInformacionCTR(AlumnoCarreraMD alumno, MallaAlumnoBD mallaAlm, String estado, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.alumno = alumno;
        this.mallaAlm = mallaAlm;
        this.estado = estado;
        this.jd = new JDMateriasInformacion((Frame)ctrPrin.getVtnPrin(), false);
        this.jd.setLocationRelativeTo(ctrPrin.getVtnPrin());
        this.jd.setVisible(true);
    }

    public void iniciar() {
        String[] titulo = new String[]{"Materia"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.jd.getTblMaterias().setModel(this.mdTbl);
        TblEstilo.formatoTblConColor(this.jd.getTblMaterias());
        this.jd.getLblAlumno().setText(this.alumno.getAlumno().getPrimerNombre() + " " + this.alumno.getAlumno().getPrimerApellido());
        this.jd.getTblMaterias().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JDMateriasInformacionCTR.this.clickTbl();
            }
        });
        this.ctrPrin.eventoJDCerrar(this.jd);
    }

    public void cargarTercerasMatriculas() {
        this.materiasAlmn = this.mallaAlm.cargarMallaAlumnoPorEstado(this.alumno.getId(), "R");
        ArrayList terceras = new ArrayList();
        this.materiasAlmn.forEach(m -> {
            if (m.getMallaNumMatricula() == 2) {
                terceras.add(m);
            }
        });
        this.materiasAlmn = terceras;
        this.llenarTbl(this.materiasAlmn);
    }

    public void cargarMateriasEstado() {
        this.materiasAlmn = this.mallaAlm.cargarMallaAlumnoPorEstado(this.alumno.getId(), this.estado);
        this.llenarTbl(this.materiasAlmn);
    }

    private void llenarTbl(ArrayList<MallaAlumnoMD> materiasAlmn) {
        this.mdTbl.setRowCount(0);
        if (materiasAlmn != null) {
            materiasAlmn.forEach(m -> {
                Object[] valores = new Object[]{m.getMateria().getNombre()};
                this.mdTbl.addRow(valores);
            });
        }
    }

    private void clickTbl() {
        int pos = this.jd.getTblMaterias().getSelectedRow();
        if (pos >= 0) {
            this.jd.getLblCiclo().setText(this.materiasAlmn.get(pos).getMallaCiclo() + "");
            this.jd.getLblNota1().setText(this.materiasAlmn.get(pos).getNota1() + "");
            this.jd.getLblNota2().setText(this.materiasAlmn.get(pos).getNota2() + "");
            this.jd.getLblNota3().setText(this.materiasAlmn.get(pos).getNota3() + "");
            this.jd.getLblNumMatricula().setText(this.materiasAlmn.get(pos).getMallaNumMatricula() + "");
        }
    }
}

