/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCursoMD;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.estilo.TblEstilo;
import vista.alumno.JDMateriasCurso;

public class JDMateriasCursoCTR
extends DCTR {
    private final JDMateriasCurso jdMat;
    private final CursoBD CRBD = CursoBD.single();
    private final AlumnoCursoMD almCurso;
    private ArrayList<CursoMD> cursos;
    private DefaultTableModel mdTbl;

    public JDMateriasCursoCTR(AlumnoCursoMD almCurso, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.almCurso = almCurso;
        this.jdMat = new JDMateriasCurso((Frame)ctrPrin.getVtnPrin(), false);
    }

    public void iniciar() {
        this.jdMat.setLocationRelativeTo(this.ctrPrin.getVtnPrin());
        this.jdMat.setVisible(true);
        String[] titulo = new String[]{"Materia", "Docente"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.jdMat.getTblMaterias().setModel(this.mdTbl);
        TblEstilo.formatoTblConColor(this.jdMat.getTblMaterias());
        this.buscar();
        this.ctrPrin.eventoJDCerrar(this.jdMat);
    }

    private void buscar() {
        this.cursos = this.CRBD.buscarCursosPorAlumno(this.almCurso.getAlumno().getIdentificacion(), this.almCurso.getCurso().getNombre());
        this.llenarTbl(this.cursos);
    }

    private void llenarTbl(ArrayList<CursoMD> cursos) {
        this.mdTbl.setRowCount(0);
        if (!cursos.isEmpty()) {
            cursos.forEach(c -> {
                Object[] v = new Object[]{c.getMateria().getNombre(), c.getDocente().getPrimerNombre() + " " + c.getDocente().getPrimerApellido()};
                this.mdTbl.addRow(v);
            });
        }
    }
}

