/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import com.toedter.calendar.JDateChooser;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.Egresado;
import modelo.alumno.EgresadoBD;
import modelo.alumno.MallaAlumnoBD;
import modelo.alumno.MallaAlumnoMD;
import modelo.alumno.MatriculaBD;
import modelo.alumno.UtilEgresadoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import vista.alumno.JDEgresarAlumno;

public class JDEgresarAlumnoCTR
extends DCTR {
    private final JDEgresarAlumno FRM;
    private final EgresadoBD EBD = EgresadoBD.single();
    private List<PeriodoLectivoMD> ps;
    private Egresado egresado = new Egresado();
    private int idAlmnCarrera = 0;
    private boolean editar = false;
    private final MallaAlumnoBD MABD = MallaAlumnoBD.single();
    private List<MallaAlumnoMD> mallaAlumno;
    private final MatriculaBD MTBD = MatriculaBD.single();
    private final UtilEgresadoBD UEBD = UtilEgresadoBD.single();

    public JDEgresarAlumnoCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.FRM = new JDEgresarAlumno((Frame)ctrPrin.getVtnPrin(), false);
    }

    public void ingresar(int idAlmnCarrera) {
        this.idAlmnCarrera = idAlmnCarrera;
        AlumnoCarreraMD ac = new AlumnoCarreraMD();
        ac.setId(idAlmnCarrera);
        this.egresado.setAlmnCarrera(ac);
        this.iniciarVtn();
        String msg = "";
        this.mallaAlumno = this.UEBD.getMateriasNoCursadas(idAlmnCarrera);
        if (this.mallaAlumno.isEmpty()) {
            String matriculasPagar;
            this.mallaAlumno = this.UEBD.getMateriasNoPagadas(idAlmnCarrera);
            msg = this.mallaAlumno.stream().map(ma -> "Ciclo: " + ma.getMateria().getCiclo() + "  # Matricula: " + ma.getMallaNumMatricula() + "  Materia: " + ma.getMateria().getNombre() + " \n").reduce(msg, String::concat);
            if (msg.length() > 0) {
                msg = "Matricula que tiene pendiente su pago:\n" + msg;
            }
            if ((matriculasPagar = this.MTBD.getMatriculasAPagar(idAlmnCarrera)).length() > 0) {
                msg = msg + "\nMatriculas a pagar: \n" + matriculasPagar;
            }
        } else {
            msg = this.mallaAlumno.stream().map(ma -> "Ciclo: " + ma.getMateria().getCiclo() + "  # Matricula: " + ma.getMallaNumMatricula() + "  Materia: " + ma.getMateria().getNombre() + " \n").reduce(msg, String::concat);
            msg = "Materias que aun no cursa.\n" + msg;
            this.FRM.getBtnGuardar().setEnabled(false);
        }
        if (msg.length() > 0) {
            JOptionPane.showMessageDialog(this.FRM, msg);
        }
    }

    public void editar(Egresado e) {
        this.idAlmnCarrera = e.getAlmnCarrera().getId();
        this.egresado = e;
        this.iniciarVtn();
        if (e.getFechaEgreso() != null) {
            this.FRM.getJdcFechaEgreso().setDate(this.getDateFromLocalDate(e.getFechaEgreso()));
        }
        this.FRM.getCbxTrabajoTitulacion().setSelected(e.isTrabajoTitulacion());
        if (e.isGraduado() && e.getFechaGraduacion() != null) {
            this.FRM.getCbxGraduado().setSelected(true);
            this.FRM.getJdcFechaGraduacion().setDate(this.getDateFromLocalDate(e.getFechaGraduacion()));
        }
        this.editar = true;
    }

    private void iniciarVtn() {
        this.cargarCmbPeriodo();
        this.FRM.getJdcFechaEgreso().setDateFormatString("dd/MM/yyyy");
        this.FRM.getJdcFechaGraduacion().setDateFormatString("dd/MM/yyyy");
        this.FRM.getBtnGuardar().addActionListener(ev -> this.guardar());
        this.abrirJD(this.FRM);
    }

    private void guardar() {
        if (this.valido()) {
            String msg;
            int idGenerado;
            int posPeriodo = this.FRM.getCmbPeriodo().getSelectedIndex();
            this.egresado.setPeriodo(this.ps.get(posPeriodo));
            this.egresado.setFechaEgreso(this.getFechaJDC(this.FRM.getJdcFechaEgreso()));
            this.egresado.setGraduado(this.FRM.getCbxGraduado().isSelected());
            this.egresado.setTrabajoTitulacion(this.FRM.getCbxTrabajoTitulacion().isSelected());
            this.egresado.setFechaGraduacion(this.getFechaJDC(this.FRM.getJdcFechaGraduacion()));
            if (this.editar) {
                idGenerado = this.egresado.isGraduado() ? this.EBD.editarConGraduacion(this.egresado) : this.EBD.editarSinGraduacion(this.egresado);
                msg = "Editamos correctamente.";
                this.editar = false;
            } else {
                idGenerado = this.egresado.isGraduado() ? this.EBD.guardarConGraduacion(this.egresado) : this.EBD.guardarSinGraduacion(this.egresado);
                msg = "Guardamos correctamente.";
            }
            if (idGenerado > 0) {
                JOptionPane.showMessageDialog(this.FRM, msg);
                this.FRM.setVisible(false);
            } else {
                JOptionPane.showMessageDialog(this.FRM, "No pudimos realizar la accion.");
            }
        }
    }

    private boolean valido() {
        boolean valido = true;
        String msg = "";
        if (this.FRM.getJdcFechaEgreso().getDate() == null) {
            msg = msg + "No indico en que fecha egreso el alumno.\n";
            valido = false;
        }
        if (this.FRM.getCbxGraduado().isSelected() && this.FRM.getJdcFechaGraduacion().getDate() == null) {
            msg = msg + "No indico en que fecha se graduo el alumno.\n";
            valido = false;
        }
        if (!valido) {
            JOptionPane.showMessageDialog(this.FRM, msg, "Error en el formulario", 0);
        }
        return valido;
    }

    private void cargarCmbPeriodo() {
        this.ps = this.EBD.getPeriodoByIdAlmnCarrera(this.idAlmnCarrera);
        this.FRM.getCmbPeriodo().removeAllItems();
        this.ps.forEach(p -> this.FRM.getCmbPeriodo().addItem(p.getNombre()));
    }

    private LocalDate getFechaJDC(JDateChooser jdc) {
        LocalDate fecha = null;
        if (jdc.getDate() != null) {
            fecha = jdc.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        }
        return fecha;
    }

    private Date getDateFromLocalDate(LocalDate fecha) {
        return Date.from(fecha.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }
}

