/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.estilo.TblRenderMatricula;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCursoBD;
import modelo.alumno.AlumnoCursoMD;
import modelo.alumno.MatriculaMD;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.estilo.TblEstilo;
import modelo.validaciones.Validar;
import vista.alumno.JDEditarMatricula;

public class JDEditarMatriculaCTR
extends DVtnCTR {
    private final JDEditarMatricula jd;
    private final MatriculaMD matricula;
    private final CursoBD CRBD = CursoBD.single();
    private final AlumnoCursoBD ACRBD = AlumnoCursoBD.single();
    private String nombreCurso;
    private ArrayList<String> nomCursos;
    private ArrayList<AlumnoCursoMD> almnsCurso;
    private ArrayList<AlumnoCursoMD> cursosNuevos = new ArrayList();
    private ArrayList<CursoMD> cursos;
    private DefaultTableModel mdTblA;
    private DefaultTableModel mdTblN;
    private String nombreCursosN = "";
    private int numMat;

    public JDEditarMatriculaCTR(VtnPrincipalCTR ctrPrin, MatriculaMD matricula) {
        super(ctrPrin);
        this.matricula = matricula;
        this.jd = new JDEditarMatricula((Frame)ctrPrin.getVtnPrin(), false);
    }

    public void iniciar() {
        this.iniciarTbls();
        this.inicarInformacion();
        this.inicarAcciones();
        this.iniciarJD();
    }

    private void clickRemover() {
        int[] selecs = this.jd.getTblClasesNuevas().getSelectedRows();
        this.posFila = this.jd.getTblClasesNuevas().getSelectedRow();
        if (this.posFila >= 0) {
            ArrayList<AlumnoCursoMD> acx = new ArrayList<AlumnoCursoMD>();
            for (int i = 0; i < this.cursosNuevos.size(); ++i) {
                boolean mantener = true;
                for (int s : selecs) {
                    if (i != s) continue;
                    mantener = false;
                    break;
                }
                if (!mantener) continue;
                acx.add(this.cursosNuevos.get(i));
            }
            this.cursosNuevos = acx;
            this.llenarTblMN(this.cursosNuevos);
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una fila o mas filas.");
        }
    }

    private void clickGuardar() {
        if (this.cursosNuevos != null) {
            this.ACRBD.borrarActualizarMatricula();
            this.nombreCursosN = "";
            this.numMat = 1;
            this.cursosNuevos.forEach(ac -> {
                if (ac.getCurso().getCapaciadActual() > 0) {
                    this.ACRBD.agregarUpdate(ac.getId(), ac.getCurso().getId());
                    this.nombreCursosN = this.nombreCursosN + this.numMat + ": " + ac.getCurso().getMateria().getNombre() + "   Curso: " + ac.getCurso().getNombre() + "   \n";
                    ++this.numMat;
                }
            });
            int r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Se editara la matricula de: " + this.matricula.getAlumno().getNombreCompleto() + "   \nEstos son sus nuevos cursos: \n" + this.nombreCursosN);
            if (r == 0 && this.ACRBD.actualizarMatricula()) {
                this.ctrPrin.getVtnPrin().setEnabled(true);
                this.jd.dispose();
                this.ACRBD.borrarActualizarMatricula();
            }
        }
    }

    private void cambiarACurso(String curso) {
        int[] selecs;
        this.cursos = this.CRBD.buscarCursosPorNombreYPrdLectivo(curso, this.matricula.getPeriodo().getID());
        block0: for (int s : selecs = this.jd.getTblClasesActuales().getSelectedRows()) {
            for (int i = 0; i < this.cursos.size(); ++i) {
                if (this.almnsCurso.get(s).getCurso().getMateria().getId() != this.cursos.get(i).getMateria().getId()) continue;
                this.borrarSiExisteCurso(this.cursos.get(i));
                AlumnoCursoMD ac = new AlumnoCursoMD();
                ac.setId(this.almnsCurso.get(s).getId());
                ac.setCurso(this.cursos.get(i));
                this.cursosNuevos.add(ac);
                this.llenarTblMN(this.cursosNuevos);
                continue block0;
            }
        }
    }

    private void borrarSiExisteCurso(CursoMD curso) {
        for (int i = 0; i < this.cursosNuevos.size(); ++i) {
            if (curso.getMateria().getId() != this.cursosNuevos.get(i).getCurso().getMateria().getId()) continue;
            this.cursosNuevos.remove(i);
            break;
        }
    }

    private void llenarCursosDisponibles(int ciclo) {
        this.nomCursos = this.CRBD.cargarNombreCursosPorPeriodoCiclo(this.matricula.getPeriodo().getID(), ciclo);
        ArrayList<String> nomAux = new ArrayList<String>();
        nomAux.add("Seleccione");
        this.nomCursos.forEach(c -> {
            if (!c.equals(this.nombreCurso)) {
                nomAux.add((String)c);
            }
        });
        this.nomCursos = nomAux;
        Object np = JOptionPane.showInputDialog(this.ctrPrin.getVtnPrin(), "Lista de cursos disponibles", "Cursos", 3, null, this.nomCursos.toArray(), "Seleccione");
        if (np != null) {
            if (np.toString().equals("Seleccione")) {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar un curso.");
                this.llenarCursosDisponibles(ciclo);
            } else {
                this.cambiarACurso(np.toString());
            }
        }
    }

    private void clickCambiar() {
        boolean mismoCiclo = true;
        this.posFila = this.jd.getTblClasesActuales().getSelectedRow();
        if (this.posFila >= 0) {
            int[] selecs;
            int ciclo = this.almnsCurso.get(this.posFila).getCurso().getCiclo();
            this.nombreCurso = this.almnsCurso.get(this.posFila).getCurso().getNombre();
            for (int s : selecs = this.jd.getTblClasesActuales().getSelectedRows()) {
                if (this.almnsCurso.get(s).getCurso().getCiclo() == ciclo && this.almnsCurso.get(s).getCurso().getNombre().equals(this.nombreCurso)) continue;
                mismoCiclo = false;
                break;
            }
            if (mismoCiclo) {
                this.llenarCursosDisponibles(ciclo);
            } else {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar clases del mismo ciclo o la misma jornada.");
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar una o mas filas.");
        }
    }

    private void inicarAcciones() {
        this.jd.getBtnCambiar().addActionListener(e -> this.clickCambiar());
        this.jd.getBtnGuardar().addActionListener(e -> this.clickGuardar());
        this.jd.getBtnRemover().addActionListener(e -> this.clickRemover());
        this.jd.getBtnEditarNumMatricula().addActionListener(e -> this.editarNumMatricula());
    }

    private void llenarTblMA(ArrayList<AlumnoCursoMD> almnsCurso) {
        if (almnsCurso != null) {
            almnsCurso.forEach(ac -> {
                Object[] v = new Object[]{ac.getCurso().getMateria().getNombre(), ac.getCurso().getNombre()};
                this.mdTblA.addRow(v);
            });
        }
    }

    private void llenarTblMN(ArrayList<AlumnoCursoMD> cursosNuevos) {
        this.mdTblN.setRowCount(0);
        if (cursosNuevos != null) {
            cursosNuevos.forEach(ac -> {
                Object[] v = new Object[]{ac.getCurso().getMateria().getNombre(), ac.getCurso().getCapaciadActual(), ac.getCurso().getNombre()};
                this.mdTblN.addRow(v);
            });
        }
    }

    private void iniciarTbls() {
        String[] t = new String[]{"Materia", "Curso"};
        String[] t2 = new String[]{"Materia", "M", "C"};
        String[][] datos = new String[][]{};
        this.mdTblA = TblEstilo.modelTblSinEditar(datos, t);
        this.jd.getTblClasesActuales().setModel(this.mdTblA);
        TblEstilo.formatoTblMultipleSelec(this.jd.getTblClasesActuales());
        TblEstilo.columnaMedida(this.jd.getTblClasesActuales(), 1, 50);
        this.mdTblN = TblEstilo.modelTblSinEditar(datos, t2);
        TblEstilo.formatoTblMultipleSelec(this.jd.getTblClasesNuevas());
        this.jd.getTblClasesNuevas().setModel(this.mdTblN);
        TblEstilo.columnaMedida(this.jd.getTblClasesNuevas(), 1, 50);
        TblEstilo.columnaMedida(this.jd.getTblClasesNuevas(), 2, 50);
        this.jd.getTblClasesNuevas().getColumnModel().getColumn(1).setCellRenderer(new TblRenderMatricula(1));
        this.jd.getTblClasesNuevas().getColumnModel().getColumn(2).setCellRenderer(new TblRenderMatricula(2));
    }

    private void inicarInformacion() {
        this.jd.getLblAlumno().setText(this.matricula.getAlumno().getNombreCompleto());
        this.jd.getLblPeriodo().setText(this.matricula.getPeriodo().getNombre());
        this.jd.getLblFecha().setText(this.matricula.getSoloFecha());
        this.almnsCurso = this.ACRBD.buscarCursosAlmPeriodo(this.matricula.getAlumno().getId_Alumno(), this.matricula.getPeriodo().getID());
        this.llenarTblMA(this.almnsCurso);
    }

    private void iniciarJD() {
        this.jd.setVisible(true);
        this.jd.setLocationRelativeTo(this.ctrPrin.getVtnPrin());
        this.jd.setTitle("Editar matricula");
        this.ctrPrin.eventoJDCerrar(this.jd);
    }

    private void editarNumMatricula() {
        this.posFila = this.jd.getTblClasesActuales().getSelectedRow();
        if (this.posFila >= 0) {
            int id = this.almnsCurso.get(this.posFila).getId();
            String e = JOptionPane.showInputDialog(this.jd, (Object)("Modificara el n\u00famero de matricula de: \n" + this.almnsCurso.get(this.posFila).getCurso().getMateria().getNombre()));
            if (Validar.esNumeros(e.toString())) {
                int num = Integer.parseInt(e.toString());
                if (num > 0 && num < 4) {
                    this.ACRBD.editarNumMatricula(id, num);
                } else {
                    JOptionPane.showMessageDialog(this.jd, "El numero de matricula no puede ser \nmenor a 1 ni mayor a 3.");
                    this.editarNumMatricula();
                }
            } else {
                JOptionPane.showMessageDialog(this.jd, "Solo debe ingresar numeros.");
            }
        }
    }
}

