/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import modelo.alumno.AlumnoCursoBD;
import modelo.alumno.AlumnoCursoMD;
import modelo.alumno.AlumnoCursoRetiradoBD;
import modelo.alumno.AlumnoCursoRetiradoMD;
import modelo.alumno.MatriculaMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaRequisitoBD;
import modelo.materia.MateriaRequisitoMD;
import modelo.validaciones.Validar;
import vista.alumno.JDAnularMatricula;

public class JDAnularMatriculaCTR
extends DVtnCTR {
    private final JDAnularMatricula jd;
    private final MatriculaMD matricula;
    private final AlumnoCursoBD ALCBD = AlumnoCursoBD.single();
    private ArrayList<AlumnoCursoMD> almnsCurso;
    private ArrayList<AlumnoCursoMD> almnsCursoAnular;
    private final AlumnoCursoRetiradoBD ALCRBD = AlumnoCursoRetiradoBD.single();
    private ArrayList<MateriaRequisitoMD> corequisitos;
    private final MateriaRequisitoBD MRBD = MateriaRequisitoBD.single();
    private String materiaAnular = "";

    public JDAnularMatriculaCTR(VtnPrincipalCTR ctrPrin, MatriculaMD matricula) {
        super(ctrPrin);
        this.matricula = matricula;
        this.jd = new JDAnularMatricula((Frame)ctrPrin.getVtnPrin(), false);
    }

    public void iniciar() {
        this.inicarInformacion();
        this.iniciarTbls();
        this.inicarAcciones();
        this.iniciarJD();
    }

    private void inicarAcciones() {
        this.jd.getBtnAnular().addActionListener(e -> this.clickAnular());
    }

    private void anunarMatricula(ArrayList<AlumnoCursoMD> almnsCursoAnular) {
        String observacion = JOptionPane.showInputDialog("Ingrese la razon de porque \n" + this.matricula.getAlumno().getNombreCompleto() + " anula la matricula de: \n" + this.materiaAnular);
        if (observacion != null) {
            if (Validar.esLetras(observacion)) {
                almnsCursoAnular.forEach(ac -> {
                    AlumnoCursoRetiradoMD acr = new AlumnoCursoRetiradoMD();
                    acr.setAlumnoCurso((AlumnoCursoMD)ac);
                    acr.setObservacion(observacion);
                    this.ALCRBD.guardar(acr);
                });
                this.llenarTbl();
            } else {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Unicamente puede ingresar letras.");
                this.anunarMatricula(almnsCursoAnular);
            }
        }
    }

    private void clickAnular() {
        this.posFila = this.jd.getTblCursos().getSelectedRow();
        this.almnsCursoAnular = new ArrayList();
        this.materiaAnular = "";
        if (this.posFila >= 0) {
            this.materiaAnular = this.materiaAnular + this.almnsCurso.get(this.posFila).getCurso().getMateria().getNombre() + "\n";
            this.corequisitos = this.MRBD.buscarDeQueEsCorequisito(this.almnsCurso.get(this.posFila).getCurso().getMateria().getId());
            if (this.corequisitos.size() > 0) {
                this.materiaAnular = this.materiaAnular + "Con sus corequisitos: \n";
            }
            this.corequisitos.forEach(c -> {
                this.materiaAnular = this.materiaAnular + c.getMateria().getNombre() + "\n";
            });
            int r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Se anulara la matricula de: \n" + this.materiaAnular);
            if (r == 0) {
                this.almnsCurso.forEach(ac -> {
                    for (int i = 0; i < this.corequisitos.size(); ++i) {
                        if (ac.getCurso().getMateria().getId() != this.corequisitos.get(i).getMateria().getId()) continue;
                        this.almnsCursoAnular.add((AlumnoCursoMD)ac);
                        break;
                    }
                });
                this.almnsCursoAnular.add(this.almnsCurso.get(this.posFila));
                this.anunarMatricula(this.almnsCursoAnular);
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Seleccione una fila primero.");
        }
    }

    private void iniciarTbls() {
        String[] t = new String[]{"Materia", "Curso"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, t);
        this.jd.getTblCursos().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.jd.getTblCursos());
        TblEstilo.columnaMedida(this.jd.getTblCursos(), 1, 50);
        this.llenarTbl();
    }

    private void llenarTbl() {
        this.mdTbl.setRowCount(0);
        this.almnsCurso = this.ALCBD.buscarCursosAlmPeriodo(this.matricula.getAlumno().getId_Alumno(), this.matricula.getPeriodo().getID());
        this.almnsCurso.forEach(ac -> {
            Object[] v = new Object[]{ac.getCurso().getMateria().getNombre(), ac.getCurso().getNombre()};
            this.mdTbl.addRow(v);
        });
    }

    private void inicarInformacion() {
        this.jd.getLblAlumno().setText(this.matricula.getAlumno().getNombreCompleto());
        this.jd.getLblPeriodo().setText(this.matricula.getPeriodo().getNombre());
        this.jd.getLblFecha().setText(this.matricula.getSoloFecha());
    }

    private void iniciarJD() {
        this.jd.setVisible(true);
        this.jd.setLocationRelativeTo(this.ctrPrin.getVtnPrin());
        this.jd.setTitle("Anular matricula");
        this.ctrPrin.eventoJDCerrar(this.jd);
    }
}

