/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.VtnMallaAlumnoCTR;
import controlador.principal.DVtnCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JTextField;
import modelo.alumno.MallaAlumnoBD;
import modelo.alumno.MallaAlumnoMD;
import modelo.validaciones.TxtVNota;
import modelo.validaciones.Validar;
import vista.alumno.FrmMallaActualizar;

public class FrmMallaActualizarCTR
extends DVtnCTR {
    private final FrmMallaActualizar frmMalla;
    private final MallaAlumnoMD malla;
    private final MallaAlumnoBD bd;
    private final VtnMallaAlumnoCTR ctrMalla;
    private final int[] numMatriculas = new int[]{1, 2, 3};
    private int posMatricula = 0;
    private int numMatricula;
    private int posEstado;
    private double nota1;
    private double nota2;
    private double nota3;
    private String notaAux;
    private final String[] estados = new String[]{"Matriculado", "Cursado", "Reprobado", "Pendiente", "Anulado"};

    public FrmMallaActualizarCTR(VtnPrincipalCTR ctrPrin, MallaAlumnoMD malla, MallaAlumnoBD bd, VtnMallaAlumnoCTR ctrMalla) {
        super(ctrPrin);
        this.malla = malla;
        this.ctrMalla = ctrMalla;
        this.bd = bd;
        this.frmMalla = new FrmMallaActualizar((Frame)ctrPrin.getVtnPrin(), false);
        this.frmMalla.setLocationRelativeTo(ctrPrin.getVtnPrin());
        this.frmMalla.setVisible(true);
    }

    public void iniciar() {
        this.frmMalla.getTxtNota().setEnabled(false);
        this.llenarComboNumMatriculas();
        this.llenarCmb();
        this.cargarDatos();
        this.eventoActualizar(this.frmMalla.getTxtNota());
        this.iniciarAtajosTeclado();
        this.frmMalla.getTxtNota().addKeyListener(new TxtVNota(this.frmMalla.getTxtNota()));
        this.frmMalla.getCmbNumMatricula().addActionListener(e -> this.clickCmbNumMatricula());
        this.frmMalla.getCmbEstado().addActionListener(e -> this.clickEstados());
        this.frmMalla.getBtnGuardar().addActionListener(e -> this.guardar());
        this.ctrPrin.eventoJDCerrar(this.frmMalla);
        this.mostrarVtnMalla(this.frmMalla);
    }

    private void iniciarAtajosTeclado() {
        this.frmMalla.getTxtNota().addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FrmMallaActualizarCTR.this.guardar();
                }
            }
        });
    }

    private void guardar() {
        this.numMatricula = this.nota3 > 0.0 ? 3 : (this.nota1 > 0.0 && this.nota2 > 0.0 ? 2 : (this.nota1 > 0.0 ? 1 : 0));
        boolean guardar = true;
        if (!(Validar.esNota(this.nota1 + "") || Validar.esNota(this.nota2 + "") || Validar.esNota(this.nota3 + ""))) {
            guardar = false;
        }
        if (guardar && this.bd.actualizarNota(this.malla.getId(), this.nota1, this.nota2, this.nota3, this.numMatricula, this.frmMalla.getLblEstado().getText())) {
            this.ctrPrin.getVtnPrin().setEnabled(true);
            this.ctrMalla.actualizarVtn(this.malla);
            this.frmMalla.dispose();
        }
    }

    private void clickEstados() {
        this.posEstado = this.frmMalla.getCmbEstado().getSelectedIndex();
        if (this.posEstado > 0) {
            this.frmMalla.getLblEstado().setText(this.frmMalla.getCmbEstado().getItemAt(this.posEstado).charAt(0) + "");
        }
    }

    private void llenarCmb() {
        this.frmMalla.getCmbEstado().removeAllItems();
        this.frmMalla.getCmbEstado().addItem("Seleccione");
        for (String e : this.estados) {
            this.frmMalla.getCmbEstado().addItem(e);
        }
    }

    private void clickCmbNumMatricula() {
        this.posMatricula = this.frmMalla.getCmbNumMatricula().getSelectedIndex();
        if (this.posMatricula > 0) {
            this.frmMalla.getTxtNota().setEnabled(true);
        } else {
            this.frmMalla.getTxtNota().setEnabled(false);
        }
    }

    private void eventoActualizar(final JTextField txt) {
        txt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmMallaActualizarCTR.this.notaAux = txt.getText().trim();
                if (FrmMallaActualizarCTR.this.notaAux.length() == 0) {
                    FrmMallaActualizarCTR.this.notaAux = "0.0";
                }
                switch (FrmMallaActualizarCTR.this.posMatricula) {
                    case 1: {
                        FrmMallaActualizarCTR.this.frmMalla.getLblNota1().setText(FrmMallaActualizarCTR.this.notaAux);
                        break;
                    }
                    case 2: {
                        FrmMallaActualizarCTR.this.frmMalla.getLblNota2().setText(FrmMallaActualizarCTR.this.notaAux);
                        break;
                    }
                    case 3: {
                        FrmMallaActualizarCTR.this.frmMalla.getLblNota3().setText(FrmMallaActualizarCTR.this.notaAux);
                        break;
                    }
                }
                FrmMallaActualizarCTR.this.estado(FrmMallaActualizarCTR.this.frmMalla.getLblNota1().getText(), FrmMallaActualizarCTR.this.frmMalla.getLblNota2().getText(), FrmMallaActualizarCTR.this.frmMalla.getLblNota3().getText());
            }
        });
    }

    private void estado(String n1, String n2, String n3) {
        if (Validar.esNota(n1) && Validar.esNota(n2) && Validar.esNota(n3)) {
            this.nota1 = Double.parseDouble(n1);
            this.nota2 = Double.parseDouble(n2);
            this.nota3 = Double.parseDouble(n3);
            if (this.nota1 >= 70.0 || this.nota2 >= 70.0 || this.nota3 >= 70.0) {
                this.frmMalla.getLblEstado().setText("C");
                this.numMatricula = 3;
            } else {
                this.frmMalla.getLblEstado().setText("R");
            }
            if (this.nota1 == 0.0 && this.nota2 == 0.0 && this.nota3 == 0.0) {
                this.frmMalla.getLblEstado().setText("P");
            }
        }
    }

    private void cargarDatos() {
        this.nota1 = this.malla.getNota1();
        this.nota2 = this.malla.getNota2();
        this.nota3 = this.malla.getNota3();
        this.numMatricula = this.malla.getMallaNumMatricula();
        this.frmMalla.getLblNota1().setText(this.malla.getNota1() + "");
        this.frmMalla.getLblNota2().setText(this.malla.getNota2() + "");
        this.frmMalla.getLblNota3().setText(this.malla.getNota3() + "");
        this.frmMalla.getLblMateria().setText(this.malla.getMateria().getNombre());
        this.frmMalla.getLblNombre().setText(this.malla.getAlumnoCarrera().getAlumno().getNombreCompleto());
        this.frmMalla.getLblEstado().setText(this.malla.getEstado());
    }

    private void llenarComboNumMatriculas() {
        this.frmMalla.getCmbNumMatricula().removeAllItems();
        this.frmMalla.getCmbNumMatricula().addItem("--");
        for (int n : this.numMatriculas) {
            this.frmMalla.getCmbNumMatricula().addItem(n + "");
        }
    }

    private void mostrarVtnMalla(JDialog vtn) {
        vtn.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FrmMallaActualizarCTR.this.ctrMalla.actualizarVtn(FrmMallaActualizarCTR.this.malla);
                FrmMallaActualizarCTR.this.frmMalla.dispose();
            }
        });
    }
}

