/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCursoBD;
import modelo.alumno.MatriculaBD;
import modelo.alumno.MatriculaMD;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.persona.AlumnoBD;
import modelo.persona.AlumnoMD;
import modelo.validaciones.Validar;
import vista.alumno.FrmAlumnoCursoEspecial;

public class FrmAlumnoCursoEspecialCTR
extends DCTR {
    private DefaultTableModel mdTblMP;
    private DefaultTableModel mdTblMS;
    private DefaultTableModel mdTblAlm;
    private List<PeriodoLectivoMD> pls;
    private ArrayList<AlumnoMD> als;
    private ArrayList<String> ncs;
    private ArrayList<CursoMD> tcs;
    private ArrayList<CursoMD> csp;
    private ArrayList<CursoMD> css;
    private final AlumnoBD ALBD = AlumnoBD.single();
    private final CursoBD CRBD = CursoBD.single();
    private final AlumnoCursoBD ACBD = AlumnoCursoBD.single();
    private final MatriculaBD MTBD = MatriculaBD.single();
    private final FrmAlumnoCursoEspecial FRM = new FrmAlumnoCursoEspecial();
    private String materiasMatricula = "";
    private int numMateria = 0;

    public FrmAlumnoCursoEspecialCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.css = new ArrayList();
    }

    public void iniciar() {
        this.iniciarCmbPeriodo();
        this.iniciarTbls();
        this.iniciarBuscador();
        this.iniciarCmbCurso();
        this.iniciarAcciones();
        this.ctrPrin.agregarVtn(this.FRM);
        this.vtnCargada = true;
    }

    private void iniciarAcciones() {
        this.FRM.getBtnPasar1().addActionListener(e -> this.pasarUno());
        this.FRM.getBtnPasarTodos().addActionListener(e -> this.pasarTodos());
        this.FRM.getBtnRegresar1().addActionListener(e -> this.regresarUno());
        this.FRM.getBtnRegresarTodos().addActionListener(e -> this.regresarTodos());
        this.FRM.getBtnGuardar().addActionListener(e -> this.guardar());
    }

    private void iniciarCmbPeriodo() {
        this.FRM.getCmbPrdLectivo().removeAllItems();
        this.FRM.getCmbPrdLectivo().addItem("Seleccione");
        PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
        this.pls = PLBD.cargarPeriodoEspecial();
        this.pls.forEach(e -> this.FRM.getCmbPrdLectivo().addItem(e.getNombre()));
    }

    private void iniciarCmbCurso() {
        this.FRM.getCmbCurso().addActionListener(e -> {
            if (this.vtnCargada) {
                this.cargarMaterias();
            }
        });
    }

    private void cargarMaterias() {
        int posCurso = this.FRM.getCmbCurso().getSelectedIndex();
        if (posCurso > 0) {
            String nombre = this.FRM.getCmbCurso().getSelectedItem().toString();
            this.csp = new ArrayList();
            this.tcs.forEach(c -> {
                if (c.getNombre().equals(nombre)) {
                    this.csp.add((CursoMD)c);
                }
            });
            this.mdTblMP.setRowCount(0);
            this.csp.forEach(c -> {
                Object[] r = new Object[]{c.getMateria().getNombre(), "0.0"};
                this.mdTblMP.addRow(r);
            });
        }
    }

    private Function<String, Void> buscarAlumno() {
        return t -> {
            if (Validar.esLetrasYNumeros(t)) {
                this.buscarAlumno((String)t);
            }
            return null;
        };
    }

    private void buscarAlumno(String aguja) {
        this.als = this.ALBD.buscarAlumnos(aguja);
        this.mdTblAlm.setRowCount(0);
        this.als.forEach(a -> {
            Object[] r = new Object[]{a.getIdentificacion(), a.getApellidosNombres()};
            this.mdTblAlm.addRow(r);
        });
    }

    private void iniciarBuscador() {
        this.listenerTxtBuscar(this.FRM.getTxtBuscar(), this.FRM.getBtnBuscar(), this.buscarAlumno());
    }

    private void clickAlumno() {
        int posAlmn = this.FRM.getTblAlumnos().getSelectedRow();
        int posPrd = this.FRM.getCmbPrdLectivo().getSelectedIndex();
        if (posAlmn >= 0 && posPrd > 0) {
            this.ncs = this.CRBD.cargarNombreCursosPorPeriodo(this.pls.get(posPrd - 1).getID(), 0, 10);
            this.vtnCargada = false;
            this.FRM.getCmbCurso().removeAllItems();
            this.FRM.getCmbCurso().addItem("Seleccione");
            this.ncs.forEach(c -> this.FRM.getCmbCurso().addItem((String)c));
            this.vtnCargada = true;
            this.tcs = this.CRBD.buscarCursosPorPeriodoAlumno(this.pls.get(posPrd - 1).getID(), this.als.get(posAlmn).getId_Alumno());
        }
    }

    private void iniciarTbls() {
        String[] TM = new String[]{"Materia"};
        String[] TAL = new String[]{"Cedula", "Nombre"};
        this.mdTblMP = this.iniciarTbl(this.FRM.getTblMateriasPen(), TM);
        this.mdTblMS = this.iniciarTbl(this.FRM.getTblMateriasSelec(), TM);
        this.mdTblAlm = this.iniciarTbl(this.FRM.getTblAlumnos(), TAL);
        this.FRM.getTblAlumnos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FrmAlumnoCursoEspecialCTR.this.clickAlumno();
            }
        });
    }

    private void regresarTodos() {
        this.css = new ArrayList();
        this.mdTblMS.setRowCount(0);
    }

    private void regresarUno() {
        int pos = this.FRM.getTblMateriasSelec().getSelectedRow();
        if (pos >= 0) {
            this.css.remove(pos);
            this.mdTblMS.removeRow(pos);
        } else {
            JOptionPane.showMessageDialog(this.FRM, "Debe seleccionar una materia.");
        }
    }

    private void pasarUno() {
        int pos = this.FRM.getTblMateriasPen().getSelectedRow();
        if (pos >= 0) {
            this.css.add(this.csp.get(pos));
            this.csp.remove(pos);
            this.mdTblMP.removeRow(pos);
            this.llenarTblMS(this.css);
        } else {
            JOptionPane.showMessageDialog(this.FRM, "Debe seleccionar una materia.");
        }
    }

    private void pasarTodos() {
        if (!this.csp.isEmpty()) {
            this.mdTblMP.setRowCount(0);
            this.css = this.csp;
            this.llenarTblMS(this.css);
        } else {
            JOptionPane.showMessageDialog(this.FRM, "No hay materias que pasar.");
        }
    }

    private void llenarTblMS(ArrayList<CursoMD> cs) {
        this.mdTblMS.setRowCount(0);
        cs.forEach(c -> {
            Object[] r = new Object[]{c.getMateria().getNombre()};
            this.mdTblMS.addRow(r);
        });
    }

    private void guardar() {
        boolean guardar = !this.css.isEmpty();
        int posAlm = this.FRM.getTblAlumnos().getSelectedRow();
        int posPrd = this.FRM.getCmbPrdLectivo().getSelectedIndex();
        if (posAlm < 0 && posPrd < 1) {
            guardar = false;
        }
        if (guardar) {
            this.ACBD.borrarMatricula();
            this.materiasMatricula = "";
            this.numMateria = 1;
            this.css.forEach(c -> {
                this.ACBD.agregarMatricula(this.als.get(posAlm).getId_Alumno(), c.getId(), 1);
                this.materiasMatricula = this.materiasMatricula + this.numMateria + ":   Curso: " + c.getNombre() + "  Matricula: " + c.getNumMatricula() + "  Materia: " + c.getMateria().getNombre() + "    \n";
                ++this.numMateria;
            });
            int r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Se matricula a: \n" + this.als.get(posAlm).getNombreCorto() + "\nPeriodo: \n" + this.pls.get(posPrd - 1).getNombre() + "\nEn las siguientes materias: \n" + this.materiasMatricula);
            if (r == 0) {
                MatriculaMD m = this.MTBD.buscarMatriculaAlmnPrd(this.als.get(posAlm).getId_Alumno(), this.pls.get(posPrd - 1).getID());
                if (m == null) {
                    MatriculaMD matricula = new MatriculaMD();
                    matricula.setAlumno(this.als.get(posAlm));
                    matricula.setPeriodo(this.pls.get(posPrd - 1));
                    matricula.setTipo("ORDINARIA");
                    this.MTBD.ingresar(matricula);
                }
                if (this.ACBD.guardarAlmnCurso()) {
                    JOptionPane.showMessageDialog(this.FRM, "Guadamos correctamente.");
                    this.recetearFrm();
                } else {
                    JOptionPane.showMessageDialog(this.FRM, "No pudimos guardar.");
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.FRM, "El formulario contiene errores.");
        }
    }

    private void recetearFrm() {
        this.css = new ArrayList();
        this.csp = this.css;
        this.FRM.getTxtBuscar().setText("");
        this.mdTblAlm.setRowCount(0);
        this.mdTblMP.setRowCount(0);
        this.mdTblMS.setRowCount(0);
        this.FRM.getCmbCurso().removeAllItems();
    }
}

