/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.JDMateriasInformacionCTR;
import controlador.alumno.PnlHorarioAlmnCTR;
import controlador.curso.PnlHorarioCursoCTR;
import controlador.estilo.CambioPnlCTR;
import controlador.estilo.TblRenderNumMatricula;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import controlador.ventanas.VtnLblToolTip;
import java.awt.Frame;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCarreraBD;
import modelo.alumno.AlumnoCarreraMD;
import modelo.alumno.AlumnoCursoBD;
import modelo.alumno.MallaAlumnoBD;
import modelo.alumno.MallaAlumnoMD;
import modelo.alumno.MatriculaBD;
import modelo.alumno.MatriculaMD;
import modelo.alumno.UtilEgresadoBD;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.curso.CursoBD;
import modelo.curso.CursoMD;
import modelo.curso.SesionClaseBD;
import modelo.curso.SesionClaseMD;
import modelo.estilo.TblEstilo;
import modelo.materia.MateriaBD;
import modelo.materia.MateriaMD;
import modelo.materia.MateriaRequisitoBD;
import modelo.materia.MateriaRequisitoMD;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import modelo.validaciones.CmbValidar;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.util.JRLoader;
import utils.CONS;
import vista.alumno.FrmAlumnoCurso;
import vista.curso.JDInfoHorario;
import vista.curso.PnlHorarioClase;

public class FrmAlumnoCursoCTR
extends DCTR {
    private final FrmAlumnoCurso frmAlmCurso;
    private final AlumnoCursoBD ALCBD = AlumnoCursoBD.single();
    private int cicloCursado = 0;
    private int cicloReprobado = 0;
    private String materiasMatricula = "";
    DefaultTableModel mdMatPen;
    DefaultTableModel mdMatSelec;
    DefaultTableModel mdAlm;
    private final PeriodoLectivoBD PLBD = PeriodoLectivoBD.single();
    private ArrayList<PeriodoLectivoMD> periodos;
    private final AlumnoCarreraBD ALCRBD = AlumnoCarreraBD.single();
    private ArrayList<AlumnoCarreraMD> alumnosCarrera;
    private final CursoBD CBD = CursoBD.single();
    private ArrayList<CursoMD> cursosPen;
    private ArrayList<String> nombreCursos;
    private ArrayList<CursoMD> cursosSelec = new ArrayList();
    private final MallaAlumnoBD MABD = MallaAlumnoBD.single();
    private ArrayList<MallaAlumnoMD> mallaCompleta;
    private ArrayList<MallaAlumnoMD> mallaPerdidas;
    private ArrayList<MallaAlumnoMD> mallaMatriculadas;
    private ArrayList<MallaAlumnoMD> mallaCursadas;
    private ArrayList<MallaAlumnoMD> mallaAnuladas;
    private ArrayList<MallaAlumnoMD> mallaPendientes;
    private ArrayList<MateriaRequisitoMD> requisitos;
    private ArrayList<SesionClaseMD> horarioAlmn;
    private ArrayList<SesionClaseMD> horario;
    private ArrayList<SesionClaseMD> hcurso;
    private final SesionClaseBD SCBD = SesionClaseBD.single();
    private final MateriaRequisitoBD MRBD = MateriaRequisitoBD.single();
    private final MatriculaBD MTBD = MatriculaBD.single();
    private int numMateria = 0;
    private final MateriaBD MBD = MateriaBD.single();
    private ArrayList<MateriaMD> materias;
    private Boolean perdioNE;
    private Boolean tieneTerceraMatricula;
    private CarreraMD carrera;
    private final CarreraBD CRBD = CarreraBD.single();
    private List<MallaAlumnoMD> mallaAlmnNoPagadas;
    private final UtilEgresadoBD UEBD = UtilEgresadoBD.single();
    private boolean choque;
    private String choques = "";
    private String estadoMateria = "";

    public FrmAlumnoCursoCTR(FrmAlumnoCurso frmAlmCurso, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmAlmCurso = frmAlmCurso;
    }

    public void iniciar() {
        this.cargarCmbPrdLectivo();
        this.ocultarErrores();
        this.iniciarTbls();
        this.iniciarAcciones();
        this.buscadoresEstado(false);
        this.iniciarBuscador();
        this.frmAlmCurso.getBtnAnuladas().setVisible(false);
        this.inicarValidaciones();
        VtnLblToolTip.agregarTooltipsLblJI(this.frmAlmCurso);
        this.ctrPrin.agregarVtn(this.frmAlmCurso);
        this.frmAlmCurso.setTitle("Matriculado por: " + CONS.USUARIO.getUsername());
    }

    private void iniciarTbls() {
        String[] titulo1 = new String[]{"Materias no seleccionadas", "M", "#"};
        String[] titulo2 = new String[]{"Materias seleccionadas", "C"};
        String[] tituloAlmn = new String[]{"C\u00e9dula", "Alumnos"};
        String[][] datos1 = new String[][]{};
        this.mdMatPen = TblEstilo.modelTblSinEditar(datos1, titulo1);
        this.mdMatSelec = TblEstilo.modelTblSinEditar(datos1, titulo2);
        this.mdAlm = TblEstilo.modelTblSinEditar(datos1, tituloAlmn);
        this.frmAlmCurso.getTblMateriasPen().setModel(this.mdMatPen);
        this.frmAlmCurso.getTblMateriasSelec().setModel(this.mdMatSelec);
        this.frmAlmCurso.getTblAlumnos().setModel(this.mdAlm);
        TblEstilo.formatoTblMatricula(this.frmAlmCurso.getTblMateriasPen());
        TblEstilo.formatoTblMatricula(this.frmAlmCurso.getTblMateriasSelec());
        TblEstilo.formatoTbl(this.frmAlmCurso.getTblAlumnos());
        TblEstilo.columnaMedida(this.frmAlmCurso.getTblAlumnos(), 0, 100);
        TblEstilo.columnaMedida(this.frmAlmCurso.getTblMateriasSelec(), 1, 40);
        TblEstilo.columnaMedida(this.frmAlmCurso.getTblMateriasPen(), 1, 40);
        TblEstilo.columnaMedida(this.frmAlmCurso.getTblMateriasPen(), 2, 20);
        this.frmAlmCurso.getTblMateriasPen().getColumnModel().getColumn(2).setCellRenderer(new TblRenderNumMatricula(2));
    }

    private void iniciarAcciones() {
        this.frmAlmCurso.getTblAlumnos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FrmAlumnoCursoCTR.this.clickTblAlumnos();
            }
        });
        this.frmAlmCurso.getCmbPrdLectivo().addActionListener(e -> this.clickPrdLectivo());
        this.frmAlmCurso.getCmbCurso().addActionListener(e -> this.cargarMaterias());
        this.frmAlmCurso.getBtnPasar1().addActionListener(e -> this.pasarUnaMateria());
        this.frmAlmCurso.getBtnPasarTodos().addActionListener(e -> this.pasarTodasMaterias());
        this.frmAlmCurso.getBtnRegresar1().addActionListener(e -> this.regresarUnaMateria());
        this.frmAlmCurso.getBtnRegresarTodos().addActionListener(e -> this.regresarTodasMaterias());
        this.frmAlmCurso.getBtnReprobadas().addActionListener(e -> this.mostrarInformacion("R"));
        this.frmAlmCurso.getBtnHorarioCurso().addActionListener(e -> this.clickHorario());
        this.frmAlmCurso.getBtnBuscar().addActionListener(e -> this.buscarAlumnos(this.frmAlmCurso.getTxtBuscar().getText().trim()));
        this.frmAlmCurso.getBtnMtCursadas().addActionListener(e -> this.mostrarInformacion("C"));
        this.frmAlmCurso.getBtnAnuladas().addActionListener(e -> this.mostrarInformacion("A"));
        this.frmAlmCurso.getBtnPendientes().addActionListener(e -> this.mostrarInformacion("P"));
        this.frmAlmCurso.getBtnHorarioAlmn().addActionListener(e -> this.horarioAlmn());
        this.frmAlmCurso.getBtnGuardar().addActionListener(e -> this.guardar());
        this.frmAlmCurso.getBtnChoques().addActionListener(e -> this.mostrarChoque());
    }

    private void inicarValidaciones() {
        this.frmAlmCurso.getTxtBuscar().addKeyListener(new TxtVBuscador(this.frmAlmCurso.getTxtBuscar(), this.frmAlmCurso.getLblErrorBuscar(), this.frmAlmCurso.getBtnBuscar()));
        this.frmAlmCurso.getCmbPrdLectivo().addActionListener(new CmbValidar(this.frmAlmCurso.getCmbPrdLectivo(), this.frmAlmCurso.getLblErrorPrdLectivo()));
    }

    private void iniciarBuscador() {
        this.frmAlmCurso.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String aguja = FrmAlumnoCursoCTR.this.frmAlmCurso.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    FrmAlumnoCursoCTR.this.buscarAlumnos(aguja);
                } else if (aguja.length() == 0) {
                    FrmAlumnoCursoCTR.this.limpiarFrm();
                }
            }
        });
    }

    private void guardar() {
        int posTipo;
        int posPrd;
        int posAlm;
        boolean guardar = true;
        String error = "El formulario contiene errores.";
        if (this.cursosSelec.isEmpty()) {
            guardar = false;
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Debe seleccionar materias.");
        }
        if ((posAlm = this.frmAlmCurso.getTblAlumnos().getSelectedRow()) < 0) {
            guardar = false;
        }
        if ((posPrd = this.frmAlmCurso.getCmbPrdLectivo().getSelectedIndex()) < 1) {
            guardar = false;
        }
        if ((posTipo = this.frmAlmCurso.getCmbTipoMatricula().getSelectedIndex()) < 1) {
            guardar = false;
        }
        if (this.tieneTerceraMatricula.booleanValue() && !(guardar = this.validarTercerasMatriculas())) {
            error = "Debe matricularse en su tercera matricula.";
        }
        this.borrarChoques(this.cursosSelec);
        if (guardar) {
            guardar = this.validarCoRequisitos();
        }
        if (guardar) {
            this.ALCBD.borrarMatricula();
            this.materiasMatricula = "";
            this.numMateria = 1;
            this.cursosSelec.forEach(c -> {
                this.ALCBD.agregarMatricula(this.alumnosCarrera.get(posAlm).getAlumno().getId_Alumno(), c.getId(), c.getNumMatricula());
                this.materiasMatricula = this.materiasMatricula + this.numMateria + ":   Curso: " + c.getNombre() + "  Matricula: " + c.getNumMatricula() + "  Materia: " + c.getMateria().getNombre() + "    \n";
                ++this.numMateria;
            });
            int r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Se matricula a: \n" + this.alumnosCarrera.get(posAlm).getAlumno().getNombreCorto() + "\nPeriodo: \n" + this.periodos.get(posPrd - 1).getNombre() + "\nEn las siguientes materias: \n" + this.materiasMatricula);
            if (r == 0) {
                MatriculaMD m = this.MTBD.buscarMatriculaAlmnPrd(this.alumnosCarrera.get(posAlm).getAlumno().getId_Alumno(), this.periodos.get(posPrd - 1).getID());
                if (m == null) {
                    MatriculaMD matricula = new MatriculaMD();
                    matricula.setAlumno(this.alumnosCarrera.get(posAlm).getAlumno());
                    matricula.setPeriodo(this.periodos.get(posPrd - 1));
                    matricula.setTipo(this.frmAlmCurso.getCmbTipoMatricula().getSelectedItem().toString());
                    this.MTBD.ingresar(matricula);
                }
                if (this.ALCBD.guardarAlmnCurso()) {
                    this.limpiarFrm();
                    int c2 = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Desea imprimir la matricula.");
                    if (c2 == 0) {
                        this.llamaReporteMatricula(this.alumnosCarrera.get(posAlm).getAlumno().getIdentificacion(), this.periodos.get(posPrd - 1).getID());
                    }
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), error);
        }
    }

    private void limpiarFrm() {
        this.frmAlmCurso.getTxtBuscar().setText("");
        this.frmAlmCurso.getCmbCurso().removeAllItems();
        this.mdAlm.setRowCount(0);
        this.mdMatPen.setRowCount(0);
        this.mdMatSelec.setRowCount(0);
        this.cursosSelec = new ArrayList();
        this.horarioAlmn = new ArrayList();
        this.frmAlmCurso.getBtnReprobadas().setVisible(false);
        this.frmAlmCurso.getBtnAnuladas().setVisible(false);
        this.frmAlmCurso.getBtnPendientes().setEnabled(false);
        this.frmAlmCurso.getBtnMtCursadas().setEnabled(false);
    }

    private ArrayList<CursoMD> borrarChoques(ArrayList<CursoMD> cursos) {
        int i;
        int[] posElim = new int[cursos.size()];
        for (i = 0; i < cursos.size(); ++i) {
            if (cursos.get(i).getNombre().charAt(0) != 'C') continue;
            posElim[i] = i + 1;
        }
        for (i = 0; i < posElim.length; ++i) {
            if (posElim[i] <= 0) continue;
            cursos.remove(posElim[i] - 1);
            posElim = this.posElim(posElim);
        }
        return cursos;
    }

    private void ocultarErrores() {
        this.frmAlmCurso.getLblErrorBuscar().setVisible(false);
        this.frmAlmCurso.getLblErrorPrdLectivo().setVisible(false);
        this.frmAlmCurso.getBtnReprobadas().setVisible(false);
    }

    private void buscadoresEstado(boolean estado) {
        this.frmAlmCurso.getTxtBuscar().setEnabled(estado);
        this.frmAlmCurso.getBtnBuscar().setEnabled(estado);
        this.frmAlmCurso.getBtnMtCursadas().setEnabled(estado);
        this.frmAlmCurso.getBtnPendientes().setEnabled(estado);
    }

    private void cargarCmbPrdLectivo() {
        this.periodos = this.PLBD.cargarPrdParaCmbFrm();
        if (this.periodos != null) {
            this.frmAlmCurso.getCmbPrdLectivo().removeAllItems();
            this.frmAlmCurso.getCmbPrdLectivo().addItem("Seleccione");
            this.periodos.forEach(p -> this.frmAlmCurso.getCmbPrdLectivo().addItem(p.getNombre()));
        }
    }

    private void clickPrdLectivo() {
        int posPrd = this.frmAlmCurso.getCmbPrdLectivo().getSelectedIndex();
        if (posPrd > 0) {
            this.buscadoresEstado(true);
            this.frmAlmCurso.getLblNumMatriculas().setText(this.MTBD.numMaticulados(this.periodos.get(posPrd - 1).getID()) + "");
            this.frmAlmCurso.getLblNumMatriculasClases().setText(this.MTBD.numMaticuladosClases(this.periodos.get(posPrd - 1).getID()) + "");
            this.carrera = this.CRBD.buscarPorId(this.periodos.get(posPrd - 1).getCarrera().getId());
            this.mostrarInfoCarrera(this.carrera);
            this.limpiarFrm();
        } else {
            this.buscadoresEstado(false);
        }
    }

    private void mostrarInfoCarrera(CarreraMD carrera) {
        if (carrera != null) {
            this.frmAlmCurso.setTitle("Matricula | " + carrera.getNombre() + " - " + carrera.getModalidad());
        } else {
            this.frmAlmCurso.setTitle("Matricula ");
        }
    }

    private void buscarAlumnos(String aguja) {
        int posPrd = this.frmAlmCurso.getCmbPrdLectivo().getSelectedIndex();
        if (posPrd > 0 && Validar.esLetrasYNumeros(aguja)) {
            this.alumnosCarrera = this.ALCRBD.buscarAlumnoCarreraParaFrm(this.periodos.get(posPrd - 1).getCarrera().getId(), aguja);
            this.llenarTblAlumnos(this.alumnosCarrera);
        }
    }

    private void clickTblAlumnos() {
        int posAl = this.frmAlmCurso.getTblAlumnos().getSelectedRow();
        int posPrd = this.frmAlmCurso.getCmbPrdLectivo().getSelectedIndex();
        System.out.println("aqui estoy......");
        if (posAl >= 0) {
            String matriculasPagar;
            this.mdMatPen.setRowCount(0);
            this.mdMatSelec.setRowCount(0);
            this.cursosSelec = new ArrayList();
            this.horarioAlmn = new ArrayList();
            this.tieneTerceraMatricula = false;
            this.frmAlmCurso.getBtnPendientes().setEnabled(true);
            this.frmAlmCurso.getBtnMtCursadas().setEnabled(true);
            this.mallaCompleta = this.MABD.buscarMallaAlumnoParaEstado(this.alumnosCarrera.get(posAl).getId());
            this.mallaMatriculadas = this.filtrarMalla(this.mallaCompleta, "M");
            String msg = "";
            this.mallaAlmnNoPagadas = this.UEBD.getMateriasNoPagadas(this.alumnosCarrera.get(posAl).getId());
            msg = this.mallaAlmnNoPagadas.stream().map(ma -> "Ciclo: " + ma.getMateria().getCiclo() + "  # Matricula: " + ma.getMallaNumMatricula() + "  Materia: " + ma.getMateria().getNombre() + " \n").reduce(msg, String::concat);
            if (msg.length() > 0) {
                msg = "Matricula que tiene pendiente su pago:\n" + msg;
            }
            if ((matriculasPagar = this.MTBD.getMatriculasAPagar(this.alumnosCarrera.get(posAl).getId())).length() > 0) {
                msg = msg + "\nMatriculas a pagar: \n" + matriculasPagar;
            }
            if (msg.length() > 0) {
                JOptionPane.showMessageDialog(this.frmAlmCurso, msg);
            }
            if (!this.mallaMatriculadas.isEmpty()) {
                this.frmAlmCurso.getCmbCurso().removeAllItems();
                int s = JOptionPane.showOptionDialog(this.ctrPrin.getVtnPrin(), "Alumno matriculado en " + this.mallaMatriculadas.get(0).getMallaCiclo() + " ciclo. \n\u00bfVer materias en las que se encuentra matriculado?", "Alumno matriculado", 1, 1, null, new Object[]{"Ingresar otro alumno", "Ingresar en otro curso", "Ver materias", "Cancelar"}, "Ver materias");
                switch (s) {
                    case 0: {
                        this.frmAlmCurso.getTxtBuscar().setText("");
                        this.mdAlm.setRowCount(0);
                        break;
                    }
                    case 1: {
                        this.clasificarMateriasAlmn(posPrd);
                        break;
                    }
                    case 2: {
                        this.mostrarInformacion("M");
                        break;
                    }
                }
            } else {
                this.clasificarMateriasAlmn(posPrd);
            }
        }
    }

    private void clasificarMateriasAlmn(int posPrd) {
        ArrayList<MallaAlumnoMD> tm;
        this.perdioNE = false;
        this.ctrPrin.getVtnPrin().getLblEstado().setText("Clasificando cursos... ");
        this.cicloCursado = 0;
        this.mallaCursadas = this.filtrarMalla(this.mallaCompleta, "C");
        if (this.mallaCursadas != null) {
            for (int i = 0; i < this.mallaCursadas.size(); ++i) {
                if (this.mallaCursadas.get(i).getMallaCiclo() <= this.cicloCursado) continue;
                this.cicloCursado = this.mallaCursadas.get(i).getMallaCiclo();
            }
        }
        this.cicloReprobado = this.cicloCursado++;
        this.mallaPerdidas = this.filtrarMalla(this.mallaCompleta, "R");
        this.mallaMatriculadas = this.filtrarMalla(this.mallaCompleta, "M");
        this.mallaAnuladas = this.filtrarMalla(this.mallaCompleta, "A");
        this.mallaPendientes = this.filtrarMalla(this.mallaCompleta, "P");
        this.materias = this.MBD.cargarMateriaPorCarreraFrm(this.carrera.getId());
        if (this.cicloCursado == this.cicloReprobado) {
            ++this.cicloReprobado;
        }
        if (this.mallaPerdidas.size() > 0) {
            this.frmAlmCurso.getBtnReprobadas().setVisible(true);
            this.mallaPerdidas.forEach(m -> {
                if (this.carrera.getModalidad().equals("DUAL")) {
                    boolean p = this.perdioNucleoEstruncturante(m.getMateria().getId());
                    if (!this.perdioNE.booleanValue()) {
                        this.perdioNE = p;
                    }
                }
                if (m.getMallaCiclo() < this.cicloReprobado) {
                    this.cicloReprobado = m.getMallaCiclo();
                }
            });
        } else {
            this.frmAlmCurso.getBtnReprobadas().setVisible(false);
        }
        if (this.mallaAnuladas.size() > 0) {
            this.frmAlmCurso.getBtnAnuladas().setVisible(true);
            this.mallaAnuladas.forEach(m -> {
                if (m.getMallaCiclo() < this.cicloReprobado) {
                    this.cicloReprobado = m.getMallaCiclo();
                }
            });
        } else {
            this.frmAlmCurso.getBtnAnuladas().setVisible(false);
        }
        if (this.mallaPendientes.size() > 0) {
            this.frmAlmCurso.getBtnPendientes().setVisible(true);
            this.mallaPendientes.forEach(m -> {
                if (m.getMallaCiclo() < this.cicloReprobado) {
                    this.cicloReprobado = m.getMallaCiclo();
                }
            });
        } else {
            this.frmAlmCurso.getBtnPendientes().setVisible(false);
        }
        if (this.perdioNE.booleanValue()) {
            System.out.println("Ciclo en el que curso antes: " + this.cicloCursado + " /// Reprobo: " + this.cicloReprobado);
            System.out.println("Ciclo en el que curso: " + this.cicloCursado + " /// Reprobo: " + this.cicloReprobado);
        }
        if ((tm = this.filtrarTercerasMatriculas(this.mallaPerdidas)).size() > 0) {
            this.tieneTerceraMatricula = true;
            int s = JOptionPane.showOptionDialog(this.ctrPrin.getVtnPrin(), "El alumno tiene terceras matriculas \n\u00bfVer materias en las que debe realizar tercera matricula?", "Alumno con tercera matricula", 1, 1, null, new Object[]{"Permitir matricula", "Ver materias", "Cancelar"}, "Ver materias");
            switch (s) {
                case 0: {
                    tm.forEach(m -> {
                        if (m.getMallaCiclo() < this.cicloCursado) {
                            this.cicloCursado = m.getMallaCiclo();
                        }
                    });
                    --this.cicloCursado;
                    this.cargarCmbCursos(posPrd, this.cicloCursado, this.cicloReprobado);
                    break;
                }
                case 1: {
                    this.mostrarTercerasMatriculas();
                }
            }
        } else {
            this.cargarCmbCursos(posPrd, this.cicloCursado, this.cicloReprobado);
        }
    }

    private void mostrarInformacion(String estado) {
        int posAlm = this.frmAlmCurso.getTblAlumnos().getSelectedRow();
        if (posAlm >= 0) {
            JDMateriasInformacionCTR jdCtr = new JDMateriasInformacionCTR(this.alumnosCarrera.get(posAlm), this.MABD, estado, this.ctrPrin);
            jdCtr.iniciar();
            jdCtr.cargarMateriasEstado();
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Primero debe seleccionar un alumno.");
        }
    }

    private void mostrarTercerasMatriculas() {
        int posAlm = this.frmAlmCurso.getTblAlumnos().getSelectedRow();
        if (posAlm >= 0) {
            JDMateriasInformacionCTR jdCtr = new JDMateriasInformacionCTR(this.alumnosCarrera.get(posAlm), this.MABD, "R", this.ctrPrin);
            jdCtr.iniciar();
            jdCtr.cargarTercerasMatriculas();
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Primero debe seleccionar un alumno.");
        }
    }

    private void llenarTblAlumnos(ArrayList<AlumnoCarreraMD> alumnos) {
        this.mdAlm.setRowCount(0);
        if (alumnos != null) {
            alumnos.forEach(a -> {
                Object[] valores = new Object[]{a.getAlumno().getIdentificacion(), a.getAlumno().getPrimerApellido() + " " + a.getAlumno().getSegundoApellido() + " " + a.getAlumno().getPrimerNombre() + " " + a.getAlumno().getSegundoNombre()};
                this.mdAlm.addRow(valores);
            });
        }
    }

    private void cargarCmbCursos(int posPrd, int cicloCursado, int cicloReprobado) {
        this.frmAlmCurso.getCmbCurso().removeAllItems();
        this.nombreCursos = this.CBD.cargarNombreCursosPorPeriodo(this.periodos.get(posPrd - 1).getID(), cicloReprobado, cicloCursado);
        if (this.nombreCursos != null) {
            this.frmAlmCurso.getCmbCurso().addItem("Seleccione");
            this.nombreCursos.forEach(c -> this.frmAlmCurso.getCmbCurso().addItem((String)c));
            this.ctrPrin.getVtnPrin().getLblEstado().setText("Cursos clasificados correctamente.");
        } else {
            this.ctrPrin.getVtnPrin().getLblEstado().setText("No se pudieron clasificar los cursos, por favor vuelva a seleccionar un alumno.");
        }
    }

    private void cargarMaterias() {
        int posPrd = this.frmAlmCurso.getCmbPrdLectivo().getSelectedIndex();
        int posCurso = this.frmAlmCurso.getCmbCurso().getSelectedIndex();
        int posAlm = this.frmAlmCurso.getTblAlumnos().getSelectedRow();
        if (posPrd > 0 && posCurso > 0 && posAlm >= 0) {
            this.cursosPen = this.CBD.buscarCursosPorNombreYPrdLectivo(this.frmAlmCurso.getCmbCurso().getSelectedItem().toString(), this.periodos.get(posPrd - 1).getID(), this.alumnosCarrera.get(posAlm).getAlumno().getId_Alumno());
            System.out.println("Cursos Pendientes: " + this.cursosPen.size());
            this.requisitos = this.MRBD.buscarRequisitosPorCarrera(this.periodos.get(posPrd - 1).getCarrera().getId());
            this.hcurso = this.SCBD.cargarHorarioCurso(this.frmAlmCurso.getCmbCurso().getSelectedItem().toString(), this.periodos.get(posPrd - 1).getID());
            this.clasificarMateriasPendientes(this.cursosPen);
        } else {
            this.mdMatPen.setRowCount(0);
        }
    }

    private void clasificarMateriasPendientes(ArrayList<CursoMD> cursos) {
        this.mdMatPen.setRowCount(0);
        if (cursos != null) {
            int j;
            int i;
            block0: for (i = 0; i < this.cursosSelec.size(); ++i) {
                for (j = 0; j < cursos.size(); ++j) {
                    if (this.cursosSelec.get(i).getMateria().getId() != cursos.get(j).getMateria().getId()) continue;
                    cursos.remove(j);
                    continue block0;
                }
            }
            block2: for (i = 0; i < this.mallaMatriculadas.size(); ++i) {
                for (j = 0; j < cursos.size(); ++j) {
                    if (this.mallaMatriculadas.get(i).getMateria().getId() != cursos.get(j).getMateria().getId()) continue;
                    cursos.remove(j);
                    continue block2;
                }
            }
            if (!this.perdioNE.booleanValue()) {
                block4: for (i = 0; i < this.mallaCursadas.size(); ++i) {
                    for (j = 0; j < cursos.size(); ++j) {
                        if (this.mallaCursadas.get(i).getMateria().getId() != cursos.get(j).getMateria().getId()) continue;
                        cursos.remove(j);
                        continue block4;
                    }
                }
            } else {
                block6: for (i = 0; i < this.mallaCursadas.size(); ++i) {
                    for (j = 0; j < cursos.size(); ++j) {
                        if (this.mallaCursadas.get(i).getMateria().getId() != cursos.get(j).getMateria().getId() || this.perdioNucleoEstruncturante(this.mallaCursadas.get(i).getMateria().getId())) continue;
                        cursos.remove(j);
                        continue block6;
                    }
                }
            }
            if (!cursos.isEmpty()) {
                if (cursos.get(0).getCiclo() > 1) {
                    this.llenarTblConRequisitosPasados(cursos);
                } else {
                    this.llenarTblMateriasPendientes(cursos);
                }
            }
        }
    }

    private boolean perdioNucleoEstruncturante(int idMateria) {
        boolean perdio = false;
        if (this.materias != null) {
            for (int i = 0; i < this.materias.size(); ++i) {
                if (this.materias.get(i).getId() != idMateria || !this.materias.get(i).isMateriaNucleo()) continue;
                perdio = true;
                break;
            }
        }
        return perdio;
    }

    private void llenarTblConRequisitosPasados(ArrayList<CursoMD> cursos) {
        int i;
        int[] posElim = new int[cursos.size()];
        System.out.println("Cursos Pasados: " + cursos.size());
        for (i = 0; i < cursos.size(); ++i) {
            ArrayList<MateriaRequisitoMD> requisitosFiltrados = this.filtrarRequisitos(cursos.get(i).getMateria().getId(), "P");
            for (int j = 0; j < requisitosFiltrados.size(); ++j) {
                this.estadoMateria = this.estadoMateriaEnMalla(requisitosFiltrados.get(j).getMateriaRequisito().getId());
                if (this.estadoMateria == null || this.estadoMateria.equals("C")) continue;
                posElim[i] = i + 1;
            }
        }
        for (i = 0; i < posElim.length; ++i) {
            if (posElim[i] <= 0) continue;
            cursos.remove(posElim[i] - 1);
            posElim = this.posElim(posElim);
        }
        this.cursosPen = cursos;
        if (cursos.size() > 0) {
            this.llenarTblConCoRequisitos(cursos);
        }
    }

    public int[] posElim(int[] posElim) {
        int[] pos = new int[posElim.length];
        for (int i = 0; i < posElim.length; ++i) {
            pos[i] = posElim[i] - 1;
        }
        return pos;
    }

    private void llenarTblConCoRequisitos(ArrayList<CursoMD> cursos) {
        int i;
        int[] posElim = new int[cursos.size()];
        for (i = 0; i < cursos.size(); ++i) {
            ArrayList<MateriaRequisitoMD> requisitosFiltrados = this.filtrarRequisitos(cursos.get(i).getMateria().getId(), "C");
            boolean matricula = true;
            if (requisitosFiltrados.size() > 0) {
                matricula = false;
            }
            System.out.println("Requisitos Filtrados: " + requisitosFiltrados.size());
            block1: for (int j = 0; j < requisitosFiltrados.size(); ++j) {
                this.estadoMateria = this.estadoMateriaEnMalla(requisitosFiltrados.get(j).getMateriaRequisito().getId());
                if (this.estadoMateria == null) continue;
                if (!(this.estadoMateria.equals("C") || this.estadoMateria.equals("R") || this.estadoMateria.equals("M"))) {
                    int k;
                    for (k = 0; k < cursos.size(); ++k) {
                        if (!cursos.get(k).getMateria().getNombre().equals(requisitosFiltrados.get(j).getMateriaRequisito().getNombre())) continue;
                        matricula = true;
                        break;
                    }
                    for (k = 0; k < this.cursosSelec.size(); ++k) {
                        if (!this.cursosSelec.get(k).getMateria().getNombre().equals(requisitosFiltrados.get(j).getMateriaRequisito().getNombre())) continue;
                        matricula = true;
                        continue block1;
                    }
                    continue;
                }
                matricula = true;
            }
            if (matricula) continue;
            posElim[i] = i + 1;
        }
        for (i = 0; i < posElim.length; ++i) {
            if (posElim[i] <= 0) continue;
            cursos.remove(posElim[i] - 1);
            posElim = this.posElim(posElim);
        }
        this.llenarTblMateriasPendientes(cursos);
    }

    private boolean validarCoRequisitos() {
        boolean matricula = true;
        String mensaje = "";
        for (int i = 0; i < this.cursosSelec.size(); ++i) {
            ArrayList<MateriaRequisitoMD> requisitosFiltrados = this.filtrarRequisitos(this.cursosSelec.get(i).getMateria().getId(), "C");
            matricula = true;
            if (requisitosFiltrados.size() > 0) {
                matricula = false;
            }
            block1: for (int j = 0; j < requisitosFiltrados.size(); ++j) {
                this.estadoMateria = this.estadoMateriaEnMalla(requisitosFiltrados.get(j).getMateriaRequisito().getId());
                if (!this.estadoMateria.equals("C") && !this.estadoMateria.equals("M")) {
                    for (int k = 0; k < this.cursosSelec.size(); ++k) {
                        if (this.cursosSelec.get(k).getMateria().getNombre().equals(requisitosFiltrados.get(j).getMateriaRequisito().getNombre())) {
                            matricula = true;
                            continue block1;
                        }
                        mensaje = mensaje + this.cursosSelec.get(k).getMateria().getNombre() + " tiene como co-requisito: \n" + requisitosFiltrados.get(j).getMateriaRequisito().getNombre() + "\n";
                    }
                    continue;
                }
                matricula = true;
            }
        }
        if (!matricula) {
            mensaje = mensaje + "\nDebe matricularse en las materias con su co-requisito correspondiente.";
            JOptionPane.showMessageDialog(null, mensaje);
            return false;
        }
        return true;
    }

    public boolean validarTercerasMatriculas() {
        boolean guardar = false;
        for (int i = 0; i < this.cursosSelec.size(); ++i) {
            if (this.cursosSelec.get(i).getNumMatricula() != 3) continue;
            guardar = true;
            break;
        }
        return guardar;
    }

    public void llenarTblMateriasPendientes(ArrayList<CursoMD> cursos) {
        this.cursosPen = cursos;
        this.mdMatPen.setRowCount(0);
        if (!cursos.isEmpty()) {
            cursos.forEach(c -> {
                c.setNumMatricula(this.buscarNumeroMatricula(c.getMateria().getId()));
                Object[] valores = new Object[]{c.getMateria().getNombre(), c.getCapaciadActual(), c.getNumMatricula()};
                this.mdMatPen.addRow(valores);
            });
        }
    }

    private void llenarTblMatSelec(ArrayList<CursoMD> cursosSelec) {
        this.mdMatSelec.setRowCount(0);
        if (cursosSelec != null) {
            cursosSelec.forEach(c -> {
                Object[] valores = new Object[]{c.getMateria().getNombre(), c.getNombre()};
                this.mdMatSelec.addRow(valores);
            });
        }
    }

    private void pasarUnaMateria() {
        int posMat = this.frmAlmCurso.getTblMateriasPen().getSelectedRow();
        if (posMat >= 0) {
            if (this.cursosPen.get(posMat).getCapaciadActual() > 0) {
                this.horario = this.buscarHorarioCurso(this.cursosPen.get(posMat));
                if (this.cursosPen.get(posMat).getNombre().charAt(0) != 'C') {
                    if (this.chocanHoras(this.horario)) {
                        this.cursosPen.get(posMat).setNombre("C-" + this.cursosPen.get(posMat).getNombre());
                    } else {
                        this.llenarHorarioAlmn(this.horario);
                    }
                }
                this.cursosSelec.add(this.cursosPen.get(posMat));
                this.cursosPen.remove(posMat);
                this.llenarTblMateriasPendientes(this.cursosPen);
                this.llenarTblMatSelec(this.cursosSelec);
            } else {
                JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "No puede matricular en este curso, debido \na que no se disponen de mas cupos.");
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Seleecione una materia.");
        }
    }

    private void pasarTodasMaterias() {
        ArrayList csc = new ArrayList();
        this.cursosPen.forEach(c -> {
            if (c.getCapaciadActual() > 0) {
                this.horario = this.buscarHorarioCurso((CursoMD)c);
                if (c.getNombre().charAt(0) != 'C') {
                    if (this.chocanHoras(this.horario)) {
                        c.setNombre("C-" + c.getNombre());
                    } else {
                        this.llenarHorarioAlmn(this.horario);
                    }
                }
                this.cursosSelec.add((CursoMD)c);
            } else {
                csc.add(c);
            }
        });
        this.cursosPen = csc;
        this.llenarTblMateriasPendientes(this.cursosPen);
        this.llenarTblMatSelec(this.cursosSelec);
    }

    private void regresarUnaMateria() {
        int posMat = this.frmAlmCurso.getTblMateriasSelec().getSelectedRow();
        if (posMat >= 0) {
            this.cursosPen.add(this.cursosSelec.get(posMat));
            if (this.cursosSelec.get(posMat).getNombre().charAt(0) != 'C') {
                this.horario = this.buscarHorarioCurso(this.cursosSelec.get(posMat));
                this.quitarHorarioAlmn(this.horario);
            }
            this.cursosSelec.remove(posMat);
            this.llenarTblMateriasPendientes(this.cursosPen);
            this.llenarTblMatSelec(this.cursosSelec);
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Seleecione una materia.");
        }
    }

    private void regresarTodasMaterias() {
        this.cursosSelec = new ArrayList();
        this.horarioAlmn = new ArrayList();
        this.llenarTblMatSelec(this.cursosSelec);
        this.cargarMaterias();
        this.choques = "";
    }

    public void clickHorario() {
        int posPrd = this.frmAlmCurso.getCmbPrdLectivo().getSelectedIndex();
        int posCurso = this.frmAlmCurso.getCmbCurso().getSelectedIndex();
        if (posPrd > 0 && posCurso > 0) {
            JDInfoHorario jd = new JDInfoHorario((Frame)this.ctrPrin.getVtnPrin(), false);
            PnlHorarioClase pnl = new PnlHorarioClase();
            CambioPnlCTR.cambioPnl(jd.getPnlHorario(), pnl);
            PnlHorarioCursoCTR ctr = new PnlHorarioCursoCTR(pnl, this.frmAlmCurso.getCmbCurso().getSelectedItem().toString(), this.periodos.get(posPrd - 1).getID());
            ctr.iniciar();
            jd.setLocationRelativeTo(this.ctrPrin.getVtnPrin());
            jd.setVisible(true);
            jd.setTitle("Horario de " + this.frmAlmCurso.getCmbCurso().getSelectedItem().toString());
            this.ctrPrin.eventoJDCerrar(jd);
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Seleccione un curso primero.");
        }
    }

    public boolean chocanHoras(ArrayList<SesionClaseMD> horario) {
        this.choque = false;
        this.horarioAlmn.forEach(h -> horario.forEach(hc -> {
            if (h.getDia() == hc.getDia() && h.getHoraIni() == hc.getHoraIni() || h.getDia() == hc.getDia() && h.getHoraFin() == hc.getHoraFin()) {
                this.choque = true;
                this.choques = "Dia que choca: " + hc.getDia() + "\nChoca hora de: " + hc.getHoraIni() + " || " + hc.getHoraFin() + " \n \n";
            }
        }));
        return this.choque;
    }

    public void llenarHorarioAlmn(ArrayList<SesionClaseMD> horario) {
        horario.forEach(h -> this.horarioAlmn.add((SesionClaseMD)h));
    }

    public void quitarHorarioAlmn(ArrayList<SesionClaseMD> horario) {
        horario.forEach(h -> {
            for (int i = 0; i < this.horarioAlmn.size(); ++i) {
                if (h.getId() != this.horarioAlmn.get(i).getId()) continue;
                this.horarioAlmn.remove(i);
                break;
            }
        });
    }

    public void horarioAlmn() {
        PnlHorarioClase pnl = new PnlHorarioClase();
        JDInfoHorario jd = new JDInfoHorario((Frame)this.ctrPrin.getVtnPrin(), false);
        CambioPnlCTR.cambioPnl(jd.getPnlHorario(), pnl);
        PnlHorarioAlmnCTR ctr = new PnlHorarioAlmnCTR(this.horarioAlmn, pnl);
        jd.setTitle("Horario Alumno ");
        ctr.iniciar();
        jd.setVisible(true);
        this.ctrPrin.eventoJDCerrar(jd);
    }

    private void llamaReporteMatricula(String cedula, int idPrd) {
        try {
            JasperReport jr = (JasperReport)JRLoader.loadObject((URL)this.getClass().getResource("/vista/reportes/repImpresionMatricula.jasper"));
            HashMap<String, Object> parametro = new HashMap<String, Object>();
            parametro.put("cedula", cedula);
            parametro.put("idPeriodo", idPrd);
            parametro.put("usuario", CONS.USUARIO.getUsername());
            CON.mostrarReporte(jr, parametro, "Reporte de Matricula");
        }
        catch (JRException ex) {
            JOptionPane.showMessageDialog(null, "error" + (Object)((Object)ex));
        }
    }

    private ArrayList<MallaAlumnoMD> filtrarMalla(ArrayList<MallaAlumnoMD> mallaCompleta, String estado) {
        ArrayList<MallaAlumnoMD> mf = new ArrayList<MallaAlumnoMD>();
        mallaCompleta.forEach(m -> {
            if (m.getEstado().equals(estado)) {
                mf.add((MallaAlumnoMD)m);
            }
        });
        return mf;
    }

    private ArrayList<MallaAlumnoMD> filtrarTercerasMatriculas(ArrayList<MallaAlumnoMD> mallaPerdidas) {
        ArrayList<MallaAlumnoMD> mf = new ArrayList<MallaAlumnoMD>();
        mallaPerdidas.forEach(m -> {
            if (m.getMallaNumMatricula() == 2) {
                mf.add((MallaAlumnoMD)m);
            }
        });
        return mf;
    }

    private String estadoMateriaEnMalla(int idMateria) {
        this.estadoMateria = null;
        this.mallaCompleta.forEach(m -> {
            System.out.println("Id Materia Malla: " + m.getMateria().getId() + " Id Materia " + idMateria);
            if (m.getMateria().getId() == idMateria) {
                this.estadoMateria = m.getEstado();
                System.out.println("Estado Materia en Malla " + this.estadoMateria + " Materia " + m.getMateria().getNombre());
            }
        });
        return this.estadoMateria;
    }

    private ArrayList<MateriaRequisitoMD> filtrarRequisitos(int idMateria, String tipo) {
        ArrayList<MateriaRequisitoMD> filtrados = new ArrayList<MateriaRequisitoMD>();
        this.requisitos.forEach(m -> {
            if (m.getMateria().getId() == idMateria && m.getTipo().equals(tipo)) {
                filtrados.add((MateriaRequisitoMD)m);
            }
        });
        return filtrados;
    }

    private int buscarNumeroMatricula(int idMateria) {
        int num = -1;
        for (int i = 0; i < this.mallaCompleta.size(); ++i) {
            if (this.mallaCompleta.get(i).getMateria().getId() != idMateria) continue;
            num = this.mallaCompleta.get(i).getMallaNumMatricula();
            break;
        }
        return ++num;
    }

    private ArrayList<SesionClaseMD> buscarHorarioCurso(CursoMD curso) {
        ArrayList<SesionClaseMD> hc = new ArrayList<SesionClaseMD>();
        if (this.hcurso != null) {
            this.hcurso.forEach(h -> {
                if (h.getCurso().getId() == curso.getId()) {
                    h.setCurso(curso);
                    hc.add((SesionClaseMD)h);
                }
            });
        }
        return hc;
    }

    private void mostrarChoque() {
        JOptionPane.showMessageDialog(this.frmAlmCurso, "Choches: \n" + this.choques);
    }
}

