/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.AlumnoCarreraBD;
import modelo.alumno.AlumnoCarreraMD;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.persona.AlumnoBD;
import modelo.persona.AlumnoMD;
import modelo.validaciones.TxtVBuscador;
import modelo.validaciones.Validar;
import vista.alumno.FrmAlumnoCarrera;

public class FrmAlumnoCarreraCTR
extends DCTR {
    private final FrmAlumnoCarrera frmAlmCarrera;
    private final AlumnoCarreraBD ACBD = AlumnoCarreraBD.single();
    private boolean matriculado = false;
    private String carrera;
    private DefaultTableModel mdTbl;
    private final AlumnoBD ABD = AlumnoBD.single();
    private ArrayList<AlumnoMD> alumnos;
    private final CarreraBD CBD = CarreraBD.single();
    private ArrayList<CarreraMD> carreras;

    public FrmAlumnoCarreraCTR(FrmAlumnoCarrera frmAlmCarrera, VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.frmAlmCarrera = frmAlmCarrera;
    }

    public void iniciar() {
        this.ocultarErrores();
        this.cargarCmbCarreras();
        String[] titulo = new String[]{"C\u00e9dula", "Nombre"};
        String[][] datos = new String[][]{};
        this.mdTbl = TblEstilo.modelTblSinEditar(datos, titulo);
        this.frmAlmCarrera.getTblAlumnos().setModel(this.mdTbl);
        TblEstilo.formatoTbl(this.frmAlmCarrera.getTblAlumnos());
        this.frmAlmCarrera.getBtnGuardar().addActionListener(e -> this.guardar());
        this.frmAlmCarrera.getBtnBuscar().addActionListener(e -> this.buscarAlmns(this.frmAlmCarrera.getTxtBuscar().getText().trim()));
        this.frmAlmCarrera.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                String aguja = FrmAlumnoCarreraCTR.this.frmAlmCarrera.getTxtBuscar().getText().trim();
                if (e.getKeyCode() == 10) {
                    FrmAlumnoCarreraCTR.this.buscarAlmns(aguja);
                }
            }
        });
        this.frmAlmCarrera.getTxtBuscar().addKeyListener(new TxtVBuscador(this.frmAlmCarrera.getTxtBuscar(), this.frmAlmCarrera.getBtnBuscar()));
        TblEstilo.columnaMedida(this.frmAlmCarrera.getTblAlumnos(), 0, 100);
        this.ctrPrin.estadoCargaFrmFin("Alumno por carrera");
        this.frmAlmCarrera.getTblAlumnos().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FrmAlumnoCarreraCTR.this.clickAlumno();
            }
        });
        this.ctrPrin.agregarVtn(this.frmAlmCarrera);
    }

    public void ocultarErrores() {
        this.frmAlmCarrera.getLblError().setVisible(false);
    }

    private void guardar() {
        if (!this.matriculado) {
            int r;
            int posCar;
            boolean guardar;
            int posAlm = this.frmAlmCarrera.getTblAlumnos().getSelectedRow();
            boolean bl = guardar = !this.buscarSiEstaMatriculado(posAlm, posCar = this.frmAlmCarrera.getCmbCarreras().getSelectedIndex());
            if (posAlm < 0 || posCar < 1) {
                guardar = false;
                this.frmAlmCarrera.getLblError().setVisible(true);
            } else {
                this.frmAlmCarrera.getLblError().setVisible(false);
            }
            if (guardar && (r = JOptionPane.showConfirmDialog(this.ctrPrin.getVtnPrin(), "Se matricula a: \n" + this.alumnos.get(posAlm).getNombreCompleto() + "\n En: \n" + this.carreras.get(posCar - 1).getNombre())) == 0) {
                AlumnoCarreraMD ac = new AlumnoCarreraMD();
                ac.setAlumno(this.alumnos.get(posAlm));
                ac.setCarrera(this.carreras.get(posCar - 1));
                if (this.ACBD.guardar(ac)) {
                    this.frmAlmCarrera.dispose();
                    this.ctrPrin.cerradoJIF();
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), "Ya esta matriculado.\n " + this.carrera + "No se puede inscribir en otra carrera.");
        }
    }

    private boolean buscarSiEstaMatriculado(int posAlmn, int posCar) {
        this.carrera = this.ACBD.estaMatriculadoEn(this.alumnos.get(posAlmn).getId_Alumno(), this.carreras.get(posCar - 1).getId());
        if (this.carrera.length() > 0) {
            JOptionPane.showMessageDialog(this.ctrPrin.getVtnPrin(), this.alumnos.get(posAlmn).getNombreCompleto() + "\nSe encuentra matriculado en: \n" + this.carrera);
            return true;
        }
        return false;
    }

    private void clickAlumno() {
        int posAlmn = this.frmAlmCarrera.getTblAlumnos().getSelectedRow();
        int posCar = this.frmAlmCarrera.getCmbCarreras().getSelectedIndex();
        if (posAlmn >= 0 && posCar > 0) {
            this.matriculado = this.buscarSiEstaMatriculado(posAlmn, posCar);
        }
    }

    public void buscarAlmns(String aguja) {
        if (Validar.esLetrasYNumeros(aguja)) {
            this.frmAlmCarrera.getCmbCarreras().setSelectedIndex(0);
            this.alumnos = this.ABD.buscarAlumnos(aguja);
            this.mdTbl.setRowCount(0);
            if (this.alumnos != null) {
                this.alumnos.forEach(a -> {
                    Object[] valores = new Object[]{a.getIdentificacion(), a.getPrimerApellido() + " " + a.getSegundoApellido() + " " + a.getPrimerNombre() + " " + a.getSegundoNombre()};
                    this.mdTbl.addRow(valores);
                });
            }
        }
    }

    private void cargarCmbCarreras() {
        this.carreras = this.CBD.cargarCarreras();
        if (this.carreras != null) {
            this.frmAlmCarrera.getCmbCarreras().removeAllItems();
            this.frmAlmCarrera.getCmbCarreras().addItem("Seleccione");
            this.carreras.forEach(c -> this.frmAlmCarrera.getCmbCarreras().addItem(c.getNombre()));
        }
    }
}

