/*
 * Decompiled with CFR 0.152.
 */
package controlador.alumno;

import controlador.alumno.IAlumnoEgresadoVTNCTR;
import controlador.alumno.JDEgresarAlumnoCTR;
import controlador.principal.DCTR;
import controlador.principal.VtnPrincipalCTR;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.table.DefaultTableModel;
import modelo.alumno.Egresado;
import modelo.alumno.EgresadoBD;
import modelo.carrera.CarreraBD;
import modelo.carrera.CarreraMD;
import modelo.estilo.TblEstilo;
import modelo.periodolectivo.PeriodoLectivoBD;
import modelo.periodolectivo.PeriodoLectivoMD;
import vista.alumno.VtnAlumnoEgresados;

public abstract class AVtnAlumnoEgresadoCTR
extends DCTR {
    protected final VtnAlumnoEgresados vtn;
    protected List<Egresado> egresados;
    protected List<Egresado> todosEgresados;
    protected DefaultTableModel mdTbl;
    protected final EgresadoBD EBD = EgresadoBD.single();
    private final CarreraBD CBD = CarreraBD.single();
    private final PeriodoLectivoBD PBD = PeriodoLectivoBD.single();
    private ArrayList<CarreraMD> todasCarreras;
    private ArrayList<PeriodoLectivoMD> todosPeriodos;
    protected ArrayList<CarreraMD> carreras;
    protected ArrayList<PeriodoLectivoMD> periodos;
    private final JDEgresarAlumnoCTR ECTR;
    private IAlumnoEgresadoVTNCTR VTNCTR;

    public AVtnAlumnoEgresadoCTR(VtnPrincipalCTR ctrPrin) {
        super(ctrPrin);
        this.vtn = new VtnAlumnoEgresados();
        this.ECTR = new JDEgresarAlumnoCTR(ctrPrin);
    }

    protected void iniciarAcciones() {
        this.vtn.getBtnEliminar().addActionListener(e -> this.clickEliminar());
        this.vtn.getBtnEditar().addActionListener(e -> this.clickEditar());
        this.vtn.getBtnNotasAlumno().setVisible(false);
        this.vtn.getBtnNotasPeriodo().setVisible(false);
    }

    private void clickEliminar() {
        int posFila = this.vtn.getTblEgresados().getSelectedRow();
        if (posFila >= 0) {
            int r = JOptionPane.showConfirmDialog(this.vtn, "Esta seguro de eliminar el egreso de: \n" + this.egresados.get(posFila).getAlmnCarrera().getAlumno().getNombreCompleto());
            if (r == 0) {
                if (this.EBD.eliminar(this.egresados.get(posFila).getId())) {
                    JOptionPane.showMessageDialog(this.vtn, "Eliminamos correctamente.");
                    this.mdTbl.removeRow(posFila);
                } else {
                    JOptionPane.showMessageDialog(this.vtn, "No se elimino el registro.");
                }
            }
        } else {
            this.errorNoSeleccionoFila();
        }
    }

    private void clickEditar() {
        int posFila = this.vtn.getTblEgresados().getSelectedRow();
        if (posFila >= 0) {
            this.ECTR.editar(this.egresados.get(posFila));
        } else {
            this.errorNoSeleccionoFila();
        }
    }

    protected void iniciarVtn(String[] titulo, IAlumnoEgresadoVTNCTR VTNCTR) {
        this.VTNCTR = VTNCTR;
        this.mdTbl = TblEstilo.modelTblSinEditar(titulo);
        this.vtn.getTblEgresados().setModel(this.mdTbl);
        this.cargarCmb();
        this.vtn.getCmbCarrera().addActionListener(e -> this.clickCarreras());
        this.vtn.getCmbPeriodo().addActionListener(e -> this.clickPeriodo());
    }

    private void cargarCmb() {
        this.todasCarreras = this.CBD.cargarCarrerasCmb();
        this.todosPeriodos = this.PBD.cargarPrdParaCmbVtn();
        this.carreras = this.todasCarreras;
        this.periodos = this.todosPeriodos;
        this.llenarCmbCarreras(this.carreras);
        this.llenarCmbPeriodos(this.periodos);
    }

    private void clickPeriodo() {
        int posPeriodo = this.vtn.getCmbPeriodo().getSelectedIndex();
        if (posPeriodo > 0 && this.vtnCargada) {
            this.egresados = new ArrayList<Egresado>();
            this.todosEgresados.forEach(e -> {
                if (e.getPeriodo().getNombre().equals(this.vtn.getCmbPeriodo().getSelectedItem().toString())) {
                    this.egresados.add((Egresado)e);
                }
            });
            this.VTNCTR.llenarTbl(this.egresados);
        } else {
            this.clickCarreras();
        }
    }

    private void clickCarreras() {
        int posCarrera = this.vtn.getCmbCarrera().getSelectedIndex();
        if (posCarrera > 0 && this.vtnCargada) {
            this.periodos = new ArrayList();
            this.todosPeriodos.forEach(p -> {
                if (p.getCarrera().getId() == this.carreras.get(posCarrera - 1).getId()) {
                    this.periodos.add((PeriodoLectivoMD)p);
                }
            });
            this.llenarCmbPeriodos(this.periodos);
            this.egresados = new ArrayList<Egresado>();
            this.todosEgresados.forEach(e -> {
                if (e.getAlmnCarrera().getCarrera().getCodigo().equals(this.vtn.getCmbCarrera().getSelectedItem().toString())) {
                    this.egresados.add((Egresado)e);
                }
            });
            this.VTNCTR.llenarTbl(this.egresados);
        } else {
            this.periodos = this.todosPeriodos;
            this.llenarCmbPeriodos(this.periodos);
            this.egresados = this.todosEgresados;
            this.VTNCTR.llenarTbl(this.egresados);
        }
    }

    private void llenarCmbCarreras(ArrayList<CarreraMD> carreras) {
        this.vtn.getCmbCarrera().removeAllItems();
        this.vtn.getCmbCarrera().addItem("Seleccione");
        carreras.forEach(c -> this.vtn.getCmbCarrera().addItem(c.getCodigo()));
    }

    private void llenarCmbPeriodos(ArrayList<PeriodoLectivoMD> periodos) {
        this.vtn.getCmbPeriodo().removeAllItems();
        this.vtn.getCmbPeriodo().addItem("Seleccione");
        periodos.forEach(p -> this.vtn.getCmbPeriodo().addItem(p.getNombre()));
    }
}

