/*
 * Decompiled with CFR 0.152.
 */
package controlador.accesos;

import controlador.Libraries.Effects;
import controlador.principal.VtnPrincipalCTR;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import modelo.accesosDelRol.AccesosDelRolBD;
import modelo.usuario.RolBD;
import utils.CONS;
import vista.accesos.FrmAccesosDeRol;

public class FrmAccesosAddCTR {
    private final VtnPrincipalCTR desktop;
    private final FrmAccesosDeRol vista;
    private final AccesosDelRolBD modelo;
    private RolBD rol;
    private List<AccesosDelRolBD> listaPermisos;
    private DefaultTableModel tblPermisos;

    public FrmAccesosAddCTR(VtnPrincipalCTR destop) {
        this.desktop = destop;
        this.vista = new FrmAccesosDeRol();
        this.modelo = new AccesosDelRolBD();
    }

    public void setRol(RolBD rol) {
        this.rol = rol;
    }

    public void Init() {
        Effects.addInDesktopPane(this.vista, this.desktop.getVtnPrin().getDpnlPrincipal());
        this.tblPermisos = (DefaultTableModel)this.vista.getTabPermisos().getModel();
        this.listaPermisos = this.modelo.selectWhere(this.rol.getId());
        this.cargarTabla();
        this.vista.getLblRolSeleccionado().setText(this.rol.getNombre());
        this.InitEventos();
    }

    private void InitEventos() {
        this.vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmAccesosAddCTR.this.cargarTablaFilter(FrmAccesosAddCTR.this.vista.getTxtBuscar().getText().toLowerCase());
            }
        });
        this.tblPermisos.addTableModelListener(new TableModelListener(){
            boolean active = false;

            @Override
            public void tableChanged(TableModelEvent e) {
                if (!this.active && e.getType() == 0) {
                    this.active = true;
                    FrmAccesosAddCTR.this.activarPermisos();
                    this.active = false;
                }
            }
        });
        this.vista.getTxtBuscar().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                FrmAccesosAddCTR.this.cargarTablaFilter(FrmAccesosAddCTR.this.vista.getTxtBuscar().getText());
            }
        });
    }

    private int getRow() {
        return this.vista.getTabPermisos().getSelectedRow();
    }

    private void cargarTabla() {
        this.tblPermisos.setRowCount(0);
        this.listaPermisos.stream().sorted(this.sorter()).forEach(this.agregarFilas());
    }

    private Consumer<AccesosDelRolBD> agregarFilas() {
        return obj -> {
            this.tblPermisos.addRow(new Object[]{this.tblPermisos.getDataVector().size() + 1, obj.getAcceso().getNombre(), obj.isActivo(), obj.getId()});
            this.vista.getLblResultados().setText(this.tblPermisos.getDataVector().size() + " Resultados");
        };
    }

    private Comparator<AccesosDelRolBD> sorter() {
        return (item1, item2) -> item1.getAcceso().getNombre().compareTo(item2.getAcceso().getNombre());
    }

    private void cargarTablaFilter(String aguja) {
        this.tblPermisos.setRowCount(0);
        this.listaPermisos.stream().filter(item -> item.getAcceso().getNombre().toLowerCase().contains(aguja.toLowerCase())).sorted(this.sorter()).forEach(this.agregarFilas());
    }

    private void activarPermisos() {
        new Thread(() -> {
            int id = (Integer)this.tblPermisos.getValueAt(this.getRow(), 3);
            boolean activo = (Boolean)this.tblPermisos.getValueAt(this.getRow(), 2);
            AccesosDelRolBD acceso = this.listaPermisos.stream().filter(item -> item.getId() == id).findFirst().get();
            acceso.setActivo(activo);
            if (acceso.editar()) {
                if (activo) {
                    this.vista.getLblEstado().setText("SE HA DADO EL PERMISO: " + acceso.getAcceso().getNombre());
                    this.vista.getLblEstado().setForeground(CONS.SUCCESS_COLOR);
                } else {
                    this.vista.getLblEstado().setText("SE HA QUITADO EL PERMISO: " + acceso.getAcceso().getNombre());
                    this.vista.getLblEstado().setForeground(CONS.ERROR_COLOR);
                }
            }
        }).start();
    }
}

