/*
 * Decompiled with CFR 0.152.
 */
package controlador.Libraries.cellEditor;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class TextFieldCellEditor
extends JTextField
implements TableCellEditor {
    private CellEditorListener cellEditorListener = null;
    private Object oldValue;
    private final boolean editar;

    public TextFieldCellEditor(boolean editar) {
        this.editar = editar;
        super.setOpaque(true);
        super.setBorder(null);
        super.setHorizontalAlignment(0);
        super.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                TextFieldCellEditor.this.selectAll();
            }
        });
        super.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TextFieldCellEditor.this.stopCellEditing();
                }
            }
        });
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int column) {
        super.setText(obj.toString());
        if (isSelected) {
            this.selectAll();
        }
        this.setFont(new Font("Arial", 0, 12));
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        return super.getText();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return this.editar;
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.cellEditorListener.editingStopped(new ChangeEvent(this));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorListener.editingCanceled(new ChangeEvent(this));
    }

    @Override
    public void addCellEditorListener(CellEditorListener celleditorlistener) {
        this.cellEditorListener = celleditorlistener;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener celleditorlistener) {
        if (this.cellEditorListener == this.cellEditorListener) {
            this.cellEditorListener = null;
        }
    }
}

