/*
 * Decompiled with CFR 0.152.
 */
package controlador.Libraries.cellEditor;

import java.awt.Component;
import java.awt.Font;
import java.util.EventObject;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class ComboBoxCellEditor
extends JComboBox
implements TableCellEditor {
    private CellEditorListener cellEditorListener = null;
    private Object oldValue;
    private final boolean editar;
    private final List<String> items;

    public ComboBoxCellEditor(boolean editar, List<String> items) {
        this.editar = editar;
        this.items = items;
        items.forEach(obj -> this.addItem(obj));
        super.addItemListener(e -> this.stopCellEditing());
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object obj, boolean isSelected, int row, int column) {
        super.setSelectedItem(obj.toString());
        this.setFont(new Font("Arial", 0, 12));
        return this;
    }

    @Override
    public Object getCellEditorValue() {
        return super.getSelectedItem();
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        return this.editar;
    }

    @Override
    public boolean shouldSelectCell(EventObject e) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        try {
            this.cellEditorListener.editingStopped(new ChangeEvent(this));
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException runtimeException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public void cancelCellEditing() {
        this.cellEditorListener.editingCanceled(new ChangeEvent(this));
    }

    @Override
    public void addCellEditorListener(CellEditorListener celleditorlistener) {
        this.cellEditorListener = celleditorlistener;
    }

    @Override
    public void removeCellEditorListener(CellEditorListener celleditorlistener) {
        if (this.cellEditorListener == this.cellEditorListener) {
            // empty if block
        }
    }
}

