/*
 * Decompiled with CFR 0.152.
 */
package controlador.Libraries;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import org.postgresql.util.Base64;

public class ImgLib {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageIcon JFCToImageIcon(JFileChooser findFile) {
        ImageIcon image = null;
        try {
            URI uri = findFile.getSelectedFile().toURI();
            try (FileInputStream input = new FileInputStream(new File(uri));){
                BufferedImage bffImage = ImageIO.read(input);
                if (bffImage == null) {
                    ImageIcon imageIcon = null;
                    return imageIcon;
                }
                image = new ImageIcon(bffImage);
                return image;
            }
        }
        catch (FileNotFoundException ex) {
            System.out.println(ex.getMessage());
            return image;
        }
        catch (IOException ex) {
            System.out.println(ex.getMessage());
        }
        return image;
    }

    public static FileInputStream getImgFileFromJFC(JFileChooser JFileChooser2) {
        try {
            return new FileInputStream(new File(JFileChooser2.getSelectedFile().toPath().toUri()));
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(ImgLib.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static void setImageInLabel(Image image, JLabel label) {
        if (image != null && label.getHeight() != 0 && label.getWidth() != 0) {
            label.setSize(label.getWidth(), label.getHeight());
            ImageIcon icon = new ImageIcon(image.getScaledInstance(label.getWidth(), label.getHeight(), 1));
            label.setIcon(icon);
        }
    }

    public static String getStringPathFromJFC(JFileChooser JfileChooser) {
        return JfileChooser.getSelectedFile().toPath().toString();
    }

    private static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        BufferedImage buffImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2D = buffImage.createGraphics();
        g2D.drawImage(image, 0, 0, null);
        g2D.dispose();
        return buffImage;
    }

    public static String setImageInBase64(Image image) {
        if (image != null) {
            String base = null;
            ByteArrayOutputStream byteAOS = new ByteArrayOutputStream();
            try {
                BufferedImage img = ImgLib.toBufferedImage(image);
                ImageIO.write((RenderedImage)img, "PNG", byteAOS);
                base = Base64.encodeBytes((byte[])byteAOS.toByteArray());
            }
            catch (IOException e) {
                System.out.println(e.getMessage());
            }
            return base;
        }
        return null;
    }

    public static Image byteToImage(byte[] byteFoto) {
        if (byteFoto != null) {
            return new ImageIcon(byteFoto).getImage();
        }
        return null;
    }
}

